/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.filter;

import java.time.Duration;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.domain.definition.entity.BusinessEntity;
import org.thingsboard.trendz.domain.definition.entity.BusinessEntityType;
import org.thingsboard.trendz.domain.definition.view.config.DateAggregationType;
import org.thingsboard.trendz.domain.definition.view.config.FilterCondition;
import org.thingsboard.trendz.domain.definition.view.config.RuntimeFilterField;
import org.thingsboard.trendz.domain.definition.view.config.ViewConfig;
import org.thingsboard.trendz.domain.definition.view.config.ViewField;
import org.thingsboard.trendz.domain.measurement.MeasurementReport;
import org.thingsboard.trendz.domain.runtime.DataCell;
import org.thingsboard.trendz.domain.runtime.DataRow;
import org.thingsboard.trendz.domain.runtime.FieldFilterOption;
import org.thingsboard.trendz.domain.runtime.ViewReport;
import org.thingsboard.trendz.exception.BadConfiguredTaskException;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.definition.BusinessEntityService;
import org.thingsboard.trendz.service.filter.FilterRequestService;
import org.thingsboard.trendz.service.view.ViewBuildingResult;
import org.thingsboard.trendz.service.view.ViewBuildingService;
import reactor.core.publisher.Mono;

@Service
public class FilterRequestService {
    private static final Logger log = LoggerFactory.getLogger(FilterRequestService.class);
    public static final Map<String, String> ENGLISH_TO_LABEL_MAP = Map.ofEntries(Map.entry("Monday", "trendz.datepicker.week.monday"), Map.entry("Tuesday", "trendz.datepicker.week.tuesday"), Map.entry("Wednesday", "trendz.datepicker.week.wednesday"), Map.entry("Thursday", "trendz.datepicker.week.thursday"), Map.entry("Friday", "trendz.datepicker.week.friday"), Map.entry("Saturday", "trendz.datepicker.week.saturday"), Map.entry("Sunday", "trendz.datepicker.week.sunday"), Map.entry("January", "trendz.datepicker.month.january"), Map.entry("February", "trendz.datepicker.month.february"), Map.entry("March", "trendz.datepicker.month.march"), Map.entry("April", "trendz.datepicker.month.april"), Map.entry("May", "trendz.datepicker.month.may"), Map.entry("June", "trendz.datepicker.month.june"), Map.entry("July", "trendz.datepicker.month.july"), Map.entry("August", "trendz.datepicker.month.august"), Map.entry("September", "trendz.datepicker.month.september"), Map.entry("October", "trendz.datepicker.month.october"), Map.entry("November", "trendz.datepicker.month.november"), Map.entry("December", "trendz.datepicker.month.december"));
    private static final Map<DateAggregationType, Set<String>> DATE_TYPE_TO_FILTER_OPTIONS_MAP = Map.of(DateAggregationType.HOUR, Set.of("0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23"), DateAggregationType.DAY, Set.of("trendz.datepicker.week.monday", "trendz.datepicker.week.tuesday", "trendz.datepicker.week.wednesday", "trendz.datepicker.week.thursday", "trendz.datepicker.week.friday", "trendz.datepicker.week.saturday", "trendz.datepicker.week.sunday"), DateAggregationType.DATE, Set.of("0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "30", "31"), DateAggregationType.MONTH, Set.of("trendz.datepicker.month.january", "trendz.datepicker.month.february", "trendz.datepicker.month.march", "trendz.datepicker.month.april", "trendz.datepicker.month.may", "trendz.datepicker.month.june", "trendz.datepicker.month.july", "trendz.datepicker.month.august", "trendz.datepicker.month.september", "trendz.datepicker.month.october", "trendz.datepicker.month.november", "trendz.datepicker.month.december"));
    private final ViewBuildingService viewBuildingService;
    private final BusinessEntityService businessEntityService;
    private final long timeoutMs;

    @Autowired
    public FilterRequestService(ViewBuildingService viewBuildingService, BusinessEntityService businessEntityService, @Value(value="5000") long timeoutMs) {
        this.viewBuildingService = viewBuildingService;
        this.businessEntityService = businessEntityService;
        this.timeoutMs = timeoutMs;
    }

    public Mono<ViewReport> processFilterRequest(ViewConfig viewConfig, JwtSecurityUser user) {
        log.info("The filter request processing is started.");
        long startTs = System.currentTimeMillis();
        List allFields = viewConfig.getAllFields();
        this.removeAndReconfigureData(viewConfig, user);
        if (allFields.isEmpty()) {
            return Mono.just((Object)new ViewReport());
        }
        UUID selectedFilterViewFieldId = viewConfig.getSelectedFilterViewFieldId();
        if (selectedFilterViewFieldId != null) {
            this.removeSelectedFilterSelection(viewConfig);
        }
        List<UUID> viewFieldInRuntimeFiltersIds = viewConfig.getRuntimeFilters().stream().map(RuntimeFilterField::getViewFieldId).toList();
        viewConfig.setRootEntityId(null);
        return this.viewBuildingService.buildView(viewConfig, user, new MeasurementReport()).map(ViewBuildingResult::getViewReport).map(report -> {
            this.postProcess(report, selectedFilterViewFieldId);
            this.setOptionsForDateFilters(report, allFields, viewFieldInRuntimeFiltersIds);
            return report;
        }).timeout(Duration.ofMillis(this.timeoutMs)).onErrorResume(throwable -> {
            ViewReport report = ViewReport.builder().filterOptions(Collections.emptyList()).build();
            return Mono.just((Object)report);
        }).doOnNext(report -> {
            long endTs = System.currentTimeMillis();
            log.info("The filter request processing is finished, time = {}", (Object)(endTs - startTs));
        });
    }

    private void removeAndReconfigureData(ViewConfig viewConfig, JwtSecurityUser user) {
        List allFields = viewConfig.getAllFields();
        Map idToFieldMap = allFields.stream().collect(Collectors.toMap(ViewField::getId, Function.identity()));
        HashSet<UUID> usedBusinessEntityFieldIds = new HashSet<UUID>();
        HashSet<DateAggregationType> usedDateFieldAggregations = new HashSet<DateAggregationType>();
        for (RuntimeFilterField filterField : viewConfig.getRuntimeFilters()) {
            UUID viewFieldId = filterField.getViewFieldId();
            ViewField viewField2 = (ViewField)idToFieldMap.get(viewFieldId);
            if (viewField2.isVirtualDateField()) {
                DateAggregationType dateGrouping = viewField2.getDateGrouping();
                if (usedDateFieldAggregations.contains(dateGrouping)) {
                    throw new BadConfiguredTaskException("You can not use more than one date filter with same grouping aggregations.");
                }
                usedDateFieldAggregations.add(dateGrouping);
                continue;
            }
            UUID befId = viewField2.getEntityFieldId();
            if (usedBusinessEntityFieldIds.contains(befId)) {
                throw new BadConfiguredTaskException("You can not use more than one filter on same business entity field.");
            }
            usedBusinessEntityFieldIds.add(befId);
        }
        Map filterFieldMap = viewConfig.getRuntimeFilters().stream().collect(Collectors.toMap(RuntimeFilterField::getViewFieldId, Function.identity()));
        List filteringFields = allFields.stream().filter(viewField -> {
            RuntimeFilterField filterField = (RuntimeFilterField)filterFieldMap.get(viewField.getId());
            if (filterField == null) {
                return false;
            }
            if (filterField.getViewFieldId().equals(viewConfig.getSelectedFilterViewFieldId())) {
                return true;
            }
            return this.filteringAbsentFiltersPredicate(filterField);
        }).filter(field -> {
            if (field.isVirtualDateField()) {
                return false;
            }
            if (field.isAlarmField()) {
                return true;
            }
            if (!this.businessEntityService.findEntityFieldById(user, field.getEntityFieldId()).hasTime()) {
                return true;
            }
            Optional businessEntityOpt = this.businessEntityService.findEntityById(user, field.getBusinessEntityId());
            return businessEntityOpt.isPresent() && BusinessEntityType.EXTERNAL.equals((Object)((BusinessEntity)businessEntityOpt.get()).getQuery().getEntityType());
        }).peek(field -> field.setHidden(false)).collect(Collectors.toList());
        viewConfig.setXAxis(filteringFields);
        viewConfig.setYAxis(Collections.emptyList());
        viewConfig.setSeries(Collections.emptyList());
        viewConfig.setHiddenFields(Collections.emptyList());
    }

    private boolean filteringAbsentFiltersPredicate(RuntimeFilterField filterField) {
        return switch (1.$SwitchMap$org$thingsboard$trendz$domain$definition$view$config$FilterCondition[filterField.getCondition().ordinal()]) {
            default -> throw new IncompatibleClassChangeError();
            case 1, 2 -> {
                if (!filterField.getSelection().isEmpty()) {
                    yield true;
                }
                yield false;
            }
            case 3, 4, 5, 6, 7, 8, 9, 10 -> {
                if (filterField.getNumericParam() != null) {
                    yield true;
                }
                yield false;
            }
            case 11, 12, 13, 14 -> {
                if (filterField.getStrParam() != null) {
                    yield true;
                }
                yield false;
            }
            case 15 -> false;
        };
    }

    private void removeSelectedFilterSelection(ViewConfig viewConfig) {
        viewConfig.getRuntimeFilters().stream().filter(runtimeFilterField -> runtimeFilterField.getViewFieldId().equals(viewConfig.getSelectedFilterViewFieldId())).forEach(runtimeFilterField -> {
            runtimeFilterField.getSelection().clear();
            runtimeFilterField.setNumericParam(null);
            runtimeFilterField.setStrParam(null);
            runtimeFilterField.setCondition(FilterCondition.ANY);
        });
    }

    private void postProcess(ViewReport report, UUID selectedFilterViewFieldId) {
        for (FieldFilterOption option : report.getFilterOptions()) {
            option.getOptions().clear();
            if (!option.getViewFieldId().equals(selectedFilterViewFieldId)) continue;
            for (DataRow row : report.getRows()) {
                DataCell dataCell = row.findCellByFieldId(option.getViewFieldId());
                if (dataCell == null || dataCell.getData() == null) continue;
                option.getOptions().add(dataCell.getData().toString());
            }
        }
    }

    private void setOptionsForDateFilters(ViewReport viewReport, List<ViewField> allFields, List<UUID> viewFieldInRuntimeFiltersIds) {
        List<ViewField> virtualDateViewFields = allFields.stream().filter(ViewField::isVirtualDateField).filter(vf -> viewFieldInRuntimeFiltersIds.contains(vf.getId())).toList();
        for (ViewField dateViewField : virtualDateViewFields) {
            UUID viewFieldId = dateViewField.getId();
            Set optionsToBeAdded = (Set)DATE_TYPE_TO_FILTER_OPTIONS_MAP.get(dateViewField.getDateGrouping());
            if (Objects.nonNull(optionsToBeAdded)) {
                viewReport.getFilterOptions().add(new FieldFilterOption(viewFieldId, optionsToBeAdded));
                continue;
            }
            viewReport.getFilterOptions().add(new FieldFilterOption(viewFieldId, Set.of()));
        }
    }
}

