/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.executor;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.util.EnumMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.exception.TrendzException;
import org.thingsboard.trendz.service.executor.ExecutorManagementService;
import org.thingsboard.trendz.service.executor.ExecutorName;
import org.thingsboard.trendz.service.executor.ExecutorProperties;
import org.thingsboard.trendz.service.executor.ExecutorType;
import org.thingsboard.trendz.service.metrics.ExecutorManagementMetricService;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class ExecutorManagementService {
    private static final Logger log = LoggerFactory.getLogger(ExecutorManagementService.class);
    private final ExecutorProperties executorProperties;
    private final ExecutorManagementMetricService executorManagementMetricService;
    private final Map<ExecutorName, ExecutorService> executorServiceMap;

    @Autowired
    public ExecutorManagementService(ExecutorProperties executorProperties, ExecutorManagementMetricService executorManagementMetricService) {
        this.executorProperties = executorProperties;
        this.executorManagementMetricService = executorManagementMetricService;
        this.executorServiceMap = new EnumMap(ExecutorName.class);
        for (ExecutorName name : ExecutorName.values()) {
            String stringName = name.getValue();
            ExecutorType type = this.executorProperties.getType().getOrDefault(stringName, ExecutorType.FIXED);
            Integer threadCount = (Integer)this.executorProperties.getThreadCount().get(stringName);
            Integer queueSize = (Integer)this.executorProperties.getQueueSize().get(stringName);
            ExecutorService executorService = switch (1.$SwitchMap$org$thingsboard$trendz$service$executor$ExecutorType[type.ordinal()]) {
                case 1 -> this.createFixedExecutor(name, threadCount.intValue());
                case 2 -> this.createScheduledExecutor(name, threadCount.intValue());
                case 3 -> this.createThrottlingExecutor(name, threadCount.intValue(), queueSize.intValue());
                default -> throw new TrendzException("Unsupported executor type: " + String.valueOf(type));
            };
            this.executorManagementMetricService.initializeServiceGauges((ThreadPoolExecutor)executorService, name.getValue());
            this.executorServiceMap.put(name, executorService);
        }
    }

    @PostConstruct
    public void init() {
        ScheduledExecutorService scheduledLoggingExecutor = (ScheduledExecutorService)this.getExecutorByName(ExecutorName.EXECUTOR_MANAGEMENT_LOGGING);
        scheduledLoggingExecutor.scheduleAtFixedRate(() -> {
            StringBuilder builder = new StringBuilder("\nExecutor service status:\n");
            for (Map.Entry entry : this.executorServiceMap.entrySet()) {
                String key = ((ExecutorName)entry.getKey()).getValue();
                ThreadPoolExecutor executor = (ThreadPoolExecutor)entry.getValue();
                builder.append(String.format("%30s", key)).append(" : \t").append("queue = ").append(executor.getQueue().size()).append(", ").append("active count = ").append(executor.getActiveCount()).append(", ").append("pool size = ").append(executor.getPoolSize()).append(", ").append("\n");
            }
            log.debug(builder.toString());
        }, 0L, 10L, TimeUnit.SECONDS);
    }

    @PreDestroy
    public void close() {
        for (ExecutorService executorService : this.executorServiceMap.values()) {
            executorService.shutdownNow();
        }
    }

    public ExecutorService getExecutorByName(ExecutorName name) {
        return (ExecutorService)this.executorServiceMap.get(name);
    }

    private ExecutorService createFixedExecutor(ExecutorName name, int threadCount) {
        ThreadFactory threadFactory = ExecutorManagementService.getThreadFactory((String)"(fixed)", (ExecutorName)name);
        return Executors.newFixedThreadPool(threadCount, threadFactory);
    }

    private ExecutorService createScheduledExecutor(ExecutorName name, int threadCount) {
        ThreadFactory threadFactory = ExecutorManagementService.getThreadFactory((String)"(scheduled)", (ExecutorName)name);
        return Executors.newScheduledThreadPool(threadCount, threadFactory);
    }

    private ExecutorService createThrottlingExecutor(ExecutorName name, int threadCount, int queueSize) {
        ThreadFactory threadFactory = ExecutorManagementService.getThreadFactory((String)"(throttling)", (ExecutorName)name);
        LinkedBlockingQueue<Runnable> queue = new LinkedBlockingQueue<Runnable>(queueSize);
        return new ThreadPoolExecutor(threadCount, threadCount, 0L, TimeUnit.MILLISECONDS, queue, threadFactory, new ThreadPoolExecutor.AbortPolicy());
    }

    private static ThreadFactory getThreadFactory(String prefix, ExecutorName name) {
        return new ThreadFactoryBuilder().setNameFormat("app-" + prefix + "-" + name.getValue() + "-%d").setUncaughtExceptionHandler((thread, throwable) -> log.error("The uncaught exception was detected for thread '{}'", (Object)thread.getName(), (Object)throwable)).build();
    }

    public static RejectedExecutionHandler getCancellingRejectionPolicy() {
        return (runnable, executor) -> {
            Future future = (Future)((Object)runnable);
            future.cancel(true);
            log.warn("Execution of given runnable is rejected");
        };
    }

    public ExecutorProperties getExecutorProperties() {
        return this.executorProperties;
    }

    public ExecutorManagementMetricService getExecutorManagementMetricService() {
        return this.executorManagementMetricService;
    }

    public Map<ExecutorName, ExecutorService> getExecutorServiceMap() {
        return this.executorServiceMap;
    }
}

