/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.definition.metadata;

import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.dao.business.metadata.BusinessEntityMetadataDao;
import org.thingsboard.trendz.domain.definition.entity.BusinessEntity;
import org.thingsboard.trendz.domain.definition.entity.metadata.BusinessEntityMetadata;
import org.thingsboard.trendz.domain.runtime.ItemLite;
import org.thingsboard.trendz.exception.service.definition.BusinessEntityNotFoundException;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.definition.BusinessEntityService;
import org.thingsboard.trendz.service.provider.TbRestDataSource;
import org.thingsboard.trendz.tools.DonReactive;
import reactor.core.publisher.Mono;

@Service
public class BusinessEntityMetadataService {
    private final BusinessEntityService businessEntityService;
    private final BusinessEntityMetadataDao entityMetadataDao;
    private final TbRestDataSource tbRestDataSource;

    @Autowired
    public BusinessEntityMetadataService(BusinessEntityService businessEntityService, BusinessEntityMetadataDao entityMetadataDao, TbRestDataSource tbRestDataSource) {
        this.businessEntityService = businessEntityService;
        this.entityMetadataDao = entityMetadataDao;
        this.tbRestDataSource = tbRestDataSource;
    }

    public ItemLite getItem(UUID entityId, JwtSecurityUser user, String jwtToken) {
        return this.entityMetadataDao.getMetadata(user, entityId).map(BusinessEntityMetadata::getItemLite).orElseGet(() -> {
            BusinessEntity businessEntity = (BusinessEntity)this.businessEntityService.findEntityById(user, entityId).orElseThrow(() -> new BusinessEntityNotFoundException(entityId, user.getTenantId()));
            return ((Optional)DonReactive.block((Mono)this.tbRestDataSource.getLastActiveEntity(businessEntity, user, jwtToken))).orElseGet(ItemLite::new);
        });
    }

    public void saveItem(UUID entityId, JwtSecurityUser user, ItemLite itemLite) {
        this.businessEntityService.findEntityById(user, entityId).orElseThrow(() -> new BusinessEntityNotFoundException(entityId, user.getTenantId()));
        this.entityMetadataDao.updateMetadata(entityId, user, itemLite);
    }

    public List<BusinessEntityMetadata> saveAll(List<BusinessEntityMetadata> businessEntityMetadata) {
        return this.entityMetadataDao.saveAll(businessEntityMetadata);
    }

    public List<BusinessEntityMetadata> getAll(JwtSecurityUser user) {
        return this.entityMetadataDao.findAllByTenantId(user);
    }
}

