/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.definition;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.dao.business.BusinessEntityDao;
import org.thingsboard.trendz.domain.definition.entity.BusinessEntity;
import org.thingsboard.trendz.domain.definition.entity.field.BusinessEntityField;
import org.thingsboard.trendz.exception.TrendzException;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.security.service.AuthenticationService;
import org.thingsboard.trendz.service.definition.TopologyStorage;
import org.thingsboard.trendz.service.definition.TopologyStorageService;
import org.thingsboard.trendz.service.provider.TbAssetService;
import org.thingsboard.trendz.service.provider.TbDeviceService;
import org.thingsboard.trendz.tools.DonReactive;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Service
public class TopologyStorageService {
    private static final Logger log = LoggerFactory.getLogger(TopologyStorageService.class);
    public static final String TOPOLOGY_STORAGE_CACHE_NAME = "topologyStorage";
    private final BusinessEntityDao businessEntityDao;
    private final AuthenticationService authenticationService;
    private final TbAssetService assetService;
    private final TbDeviceService deviceService;

    @Autowired
    public TopologyStorageService(BusinessEntityDao businessEntityDao, AuthenticationService authenticationService, TbAssetService assetService, TbDeviceService deviceService) {
        this.businessEntityDao = businessEntityDao;
        this.authenticationService = authenticationService;
        this.assetService = assetService;
        this.deviceService = deviceService;
    }

    @Cacheable(cacheNames={"topologyStorage"}, key="{'key_'+ #user.tenantId + '_' + #user.customerId}")
    public TopologyStorage loadAllEntities(JwtSecurityUser user) {
        if (user.isTenantUser()) {
            return this.initializeTenantData(user);
        }
        return this.initializeCustomerData(user);
    }

    @CacheEvict(cacheNames={"topologyStorage"}, allEntries=true)
    public void resetCache(JwtSecurityUser user) {
        log.debug("Storage cache reset is triggered");
    }

    private TopologyStorage initializeTenantData(JwtSecurityUser user) {
        log.debug("Initialization of topology as TENANT is started: tenant id: {}", (Object)user.getTenantId());
        Map entityMap = this.businessEntityDao.findAllByTenantId(user.getTenantId()).stream().collect(Collectors.toMap(BusinessEntity::getId, Function.identity()));
        Map fieldMap = entityMap.values().stream().map(BusinessEntity::getFields).flatMap(Collection::stream).collect(Collectors.toMap(BusinessEntityField::getId, Function.identity()));
        log.debug("Initialization of topology as TENANT is finished: tenant id {}, entity count {}, field count {}", new Object[]{user.getTenantId(), entityMap.size(), fieldMap.size()});
        return TopologyStorage.builder().entityMap(entityMap).fieldMap(fieldMap).build();
    }

    private TopologyStorage initializeCustomerData(JwtSecurityUser user) {
        long startTs = System.currentTimeMillis();
        log.debug("Initialization of topology as CUSTOMER: Started - tenant id {} customer id {}, user id {}, start ts {}", new Object[]{user.getTenantId(), user.getCustomerId(), user.getUserId(), startTs});
        if (!user.isCustomerUser()) {
            throw new TrendzException("Only customer users can initialize the customer data!");
        }
        String jwtToken = this.authenticationService.getToken(user);
        List businessEntitiesByTenant = this.businessEntityDao.findAllByTenantId(user.getTenantId());
        log.debug("Initialization of topology as CUSTOMER: count of found by tenant: {} (start ts = {})", (Object)businessEntitiesByTenant.size(), (Object)startTs);
        List resultEntities = (List)DonReactive.block((Mono)Flux.fromIterable((Iterable)businessEntitiesByTenant).flatMap(businessEntity -> {
            if (businessEntity.isSharedWithCustomers()) {
                return Mono.just((Object)businessEntity);
            }
            return Mono.just((Object)businessEntity).flatMap(entity -> switch (1.$SwitchMap$org$thingsboard$trendz$domain$definition$entity$BusinessEntityType[businessEntity.getQuery().getEntityType().ordinal()]) {
                case 1 -> this.assetService.loadOneAsset(entity, user, jwtToken);
                case 2 -> this.deviceService.loadOneDevice(entity, user, jwtToken);
                default -> Mono.empty();
            }).map(item -> businessEntity);
        }).collectList());
        log.debug("Initialization of topology as CUSTOMER: count of filtered by customer: {} (start ts = {})", (Object)resultEntities.size(), (Object)startTs);
        Map entityMap = resultEntities.stream().collect(Collectors.toMap(BusinessEntity::getId, Function.identity()));
        Map fieldMap = entityMap.values().stream().map(BusinessEntity::getFields).flatMap(Collection::stream).collect(Collectors.toMap(BusinessEntityField::getId, Function.identity()));
        long endTs = System.currentTimeMillis();
        if (entityMap.isEmpty()) {
            log.warn("Initialization of topology as CUSTOMER provides no entities!");
        }
        log.debug("Initialization of topology as CUSTOMER: Finished - tenant id {} customer id {}, user id {}, start ts {}, duration {}ms, entity count {}, field count {}", new Object[]{user.getTenantId(), user.getCustomerId(), user.getUserId(), startTs, endTs - startTs, entityMap.size(), fieldMap.size()});
        return TopologyStorage.builder().entityMap(entityMap).fieldMap(fieldMap).build();
    }
}

