/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.definition;

import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.dao.system.ApplicationPropertyDao;
import org.thingsboard.trendz.domain.definition.ApplicationProperty;

@Service
public class ApplicationPropertyService {
    private static final Logger log = LoggerFactory.getLogger(ApplicationPropertyService.class);
    @Autowired
    private ApplicationPropertyDao applicationPropertyDao;

    public List<ApplicationProperty> getAllProperties() {
        return this.applicationPropertyDao.getAllProperties();
    }

    public Optional<String> getProperty(String key) {
        if (key == null) {
            return Optional.empty();
        }
        return this.applicationPropertyDao.getPropertyByKey(key).map(ApplicationProperty::getValue);
    }

    public void setProperty(String key, String value) {
        this.applicationPropertyDao.saveProperty(new ApplicationProperty(key, value));
    }

    public void deleteProperty(String key) {
        this.applicationPropertyDao.deleteProperty(key);
    }
}

