/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.customize;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.Cache;
import org.springframework.stereotype.Service;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.thingsboard.server.common.data.wl.Palette;
import org.thingsboard.server.common.data.wl.PaletteSettings;
import org.thingsboard.server.common.data.wl.WhiteLabelingParams;
import org.thingsboard.trendz.dao.customize.CustomViewSettingsDao;
import org.thingsboard.trendz.dao.customize.DomainTenantPairDao;
import org.thingsboard.trendz.domain.customize.CustomViewSettings;
import org.thingsboard.trendz.domain.customize.PaletteSelection;
import org.thingsboard.trendz.domain.customize.UserRecord;
import org.thingsboard.trendz.exception.service.customize.CustomizationException;
import org.thingsboard.trendz.exception.service.customize.TbWhitelabelingLoadException;
import org.thingsboard.trendz.exception.service.customize.TrendzCustomizationException;
import org.thingsboard.trendz.exception.service.provider.TbWebClientException;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.security.service.AuthenticationService;
import org.thingsboard.trendz.service.customize.UserManagementService;
import org.thingsboard.trendz.service.provider.TbRestDataSource;
import org.thingsboard.trendz.service.provider.cache.CacheConfigurationName;
import org.thingsboard.trendz.service.provider.cache.CacheService;
import org.thingsboard.trendz.subscription.LicenceService;
import org.thingsboard.trendz.subscription.SubscriptionType;
import org.thingsboard.trendz.tools.DonReactive;
import reactor.core.publisher.Mono;

@Service
public class CustomizationService {
    private static final Logger log = LoggerFactory.getLogger(CustomizationService.class);
    private final TbRestDataSource tbRestDataSource;
    private final AuthenticationService authenticationService;
    private final CustomViewSettingsDao customViewSettingsDao;
    private final DomainTenantPairDao domainTenantPairDao;
    private final LicenceService licenceService;
    private final UserManagementService userManagementService;
    private final Cache customViewSettingsCache;
    private final Cache domainTrackCache;
    private final Cache domainAllowedWhiteLabelingCache;
    private final Cache userTrackCache;
    private final boolean cloud;
    private final boolean test;
    public static final String WHITELABELING_API_PREFIX = "apiTrendz";
    public static final String WHITELABELING_DEFAULT_PREFIX = "trendz";
    public static final String WHITELABELING_CLOUD_ALTERNATIVE_PREFIX = "analytics";
    public static final Set<String> TB_CLOUD_URLS = Set.of("eu.thingsboard.cloud", "thingsboard.cloud", "tbqa.cloud");

    @Autowired
    public CustomizationService(TbRestDataSource tbRestDataSource, AuthenticationService authenticationService, CustomViewSettingsDao customViewSettingsDao, DomainTenantPairDao domainTenantPairDao, LicenceService licenceService, UserManagementService userManagementService, CacheService cacheService, @Value(value="${deployment.cloud}") boolean cloud, @Value(value="${deployment.test}") boolean test) {
        this.tbRestDataSource = tbRestDataSource;
        this.authenticationService = authenticationService;
        this.customViewSettingsDao = customViewSettingsDao;
        this.domainTenantPairDao = domainTenantPairDao;
        this.licenceService = licenceService;
        this.userManagementService = userManagementService;
        this.customViewSettingsCache = cacheService.getCache(CacheConfigurationName.tenantCustomViewSettingsCacheName);
        this.domainTrackCache = cacheService.getCache(CacheConfigurationName.domainTrackCacheName);
        this.domainAllowedWhiteLabelingCache = cacheService.getCache(CacheConfigurationName.domainAllowedWhiteLabelingCacheName);
        this.userTrackCache = cacheService.getCache(CacheConfigurationName.userTrackCacheName);
        this.cloud = cloud;
        this.test = test;
    }

    public void trackDomain(JwtSecurityUser user, String domain) {
        if (!TB_CLOUD_URLS.contains(domain)) {
            this.domainTrackCache.get((Object)user.getTenantId(), () -> {
                this.domainTenantPairDao.writePair(domain, user.getTenantId());
                return true;
            });
        }
    }

    public void detachFromDomains(JwtSecurityUser user) {
        UUID tenantId = user.getTenantId();
        Set domains = this.domainTenantPairDao.findByTenantId(tenantId);
        this.domainTenantPairDao.removeAllByTenantId(tenantId);
        this.domainTrackCache.evict((Object)tenantId);
        this.userTrackCache.evict((Object)user);
        log.info("Tenant was detached from following domains: domains = {}, user = {}", (Object)domains, (Object)user);
    }

    public String getCompanyName(String input) {
        if (input == null || input.isEmpty()) {
            return input;
        }
        StringBuilder result = new StringBuilder();
        result.append(Character.toUpperCase(input.charAt(0)));
        for (int i = 1; i < input.length(); ++i) {
            char currentChar = input.charAt(i);
            if (Character.isUpperCase(currentChar)) {
                result.append(" ");
            }
            result.append(currentChar);
        }
        return result.toString();
    }

    public boolean checkAccessOfWhiteLabeling(JwtSecurityUser user) {
        if (this.licenseForbidsWhiteLabeling(user)) {
            return false;
        }
        Optional whiteLabelingParams = this.getWhiteLabelingParams(user);
        return whiteLabelingParams.isPresent();
    }

    public CustomViewSettings getCustomViewSettings(String domain) {
        return this.getCustomViewSettings(domain, JwtSecurityUser.NOT_USER);
    }

    public CustomViewSettings getCustomViewSettings(String domain, JwtSecurityUser user) {
        if (JwtSecurityUser.NOT_USER.equals((Object)user)) {
            if (TB_CLOUD_URLS.contains(domain)) {
                log.debug("Default customization provided for cloud-domain without tenant: domain = {}, user = {}", (Object)domain, (Object)user);
                return this.createDefaultCustomViewSettings(domain);
            }
            boolean allowedUserExists = Boolean.TRUE.equals(this.domainAllowedWhiteLabelingCache.get((Object)domain, () -> {
                Set tenantIdSet = this.domainTenantPairDao.findByDomain(domain);
                log.debug("Found {} tenants for domain [{}]", (Object)tenantIdSet.size(), (Object)domain);
                if (tenantIdSet.isEmpty()) {
                    return true;
                }
                boolean allowed = false;
                for (UUID tenantId : tenantIdSet) {
                    Optional<JwtSecurityUser> userOpt = this.userManagementService.findFirstTenantUserByTenantId(tenantId).map(UserRecord::getUser);
                    if (!userOpt.isPresent() || this.licenseForbidsWhiteLabeling(userOpt.get())) continue;
                    allowed = true;
                    break;
                }
                log.debug("Domain white labeling permission check, domain = {}, result = {}", (Object)domain, (Object)allowed);
                return allowed;
            }));
            if (allowedUserExists) {
                log.debug("Special customization provided for self-domain without tenant: domain = {}, user = {}", (Object)domain, (Object)user);
                return this.provideCustomViewSettings(domain);
            }
            log.debug("Default customization provided for self-domain with low-level subscription tenant: domain = {}, user = {}", (Object)domain, (Object)user);
            return this.createDefaultCustomViewSettings(domain);
        }
        if (this.licenseForbidsWhiteLabeling(user)) {
            log.debug("Default customization provided for low-level subscription tenant: domain = {}, user = {}", (Object)domain, (Object)user);
            return this.createDefaultCustomViewSettings(domain);
        }
        Set domains = this.domainTenantPairDao.findByTenantId(user.getTenantId());
        if (TB_CLOUD_URLS.contains(domain)) {
            if (domains.isEmpty()) {
                log.debug("Default customization created for cloud-domain with new tenant: domain = {}, user = {}", (Object)domain, (Object)user);
                return this.provideCustomViewSettings(domain, user);
            }
            if (domains.size() == 1) {
                String foundDomain = (String)domains.iterator().next();
                log.debug("Special customization provided for cloud-domain with known tenant: domain = {}, user = {}", (Object)foundDomain, (Object)user);
                return this.provideCustomViewSettings(foundDomain, user);
            }
            log.warn("You have ambiguous domain settings, details: domain = CLOUD, user = {}, registered domains = {}", (Object)user, (Object)domains);
            throw new CustomizationException("You have ambiguous domain settings!");
        }
        if (domains.isEmpty()) {
            log.debug("Special customization created for self-domain with known tenant: domain = {}, user = {}", (Object)domain, (Object)user);
            return this.provideCustomViewSettings(domain, user);
        }
        if (domains.size() == 1) {
            String foundDomain = (String)domains.iterator().next();
            if (foundDomain.equals(domain)) {
                log.debug("Special customization found for self-domain with known tenant: domain = {}, user = {}", (Object)domain, (Object)user);
                return this.provideCustomViewSettings(domain, user);
            }
            log.warn("You can get only your customization settings, details: domain = {}, user = {}, registered domains = {}", new Object[]{domain, user, domains});
            throw new CustomizationException("Your customization settings are wired to another domain name [%s], but you are using is [%s]".formatted(foundDomain, domain));
        }
        log.warn("You have ambiguous domain settings, details: domain = {}, user = {}, registered domains = {}", new Object[]{domain, user, domains});
        throw new CustomizationException("You have ambiguous domain settings!");
    }

    public CustomViewSettings setupCustomViewSettings(CustomViewSettings settings, String domain, JwtSecurityUser user) {
        if (this.licenseForbidsWhiteLabeling(user)) {
            log.warn("You can have not customization settings, details: domain = CLOUD, asked domain = {}, user = {}", (Object)settings.getDomain(), (Object)user);
            throw new CustomizationException("Your subscription is too low to have customization settings!");
        }
        this.validateSettings(settings);
        Set domains = this.domainTenantPairDao.findByTenantId(user.getTenantId());
        if (TB_CLOUD_URLS.contains(domain)) {
            if (domains.isEmpty()) {
                log.debug("You do not have any custom domain for customization: domain = CLOUD, asked domain = {}, user = {}, registered domains = {}", new Object[]{settings.getDomain(), user, domains});
                throw new CustomizationException("You do not have any custom domain for customization!");
            }
            if (domains.size() == 1) {
                String foundDomain = (String)domains.iterator().next();
                if (TB_CLOUD_URLS.contains(settings.getDomain()) || foundDomain.equals(settings.getDomain())) {
                    log.debug("Saved customization for cloud with domain and tenant: domain = CLOUD, asked domain = {}, user = {}, registered domains = {}", new Object[]{settings.getDomain(), user, domains});
                    settings.setDomain(foundDomain);
                    return this.saveCustomViewSettings(settings, user);
                }
                log.warn("You can set only your customization settings, details: domain = CLOUD, asked domain = {}, user = {}, registered domains = {}", new Object[]{settings.getDomain(), user, domains});
                throw new CustomizationException("You can set only your customization settings!");
            }
        }
        if (!domain.equals(settings.getDomain())) {
            log.warn("Domain and settings are not match, details: domain = {}}, asked domain = {}, user = {}, registered domains = {}", new Object[]{domain, settings.getDomain(), user, domains});
            throw new CustomizationException("Domain and settings are not match!");
        }
        if (domains.isEmpty()) {
            log.warn("Domain is not tracked, but it is impossible, details: domain = {}}, asked domain = {}, user = {}, registered domains = {}", new Object[]{domain, settings.getDomain(), user, domains});
            throw new CustomizationException("Domain is not tracked, but it is impossible!");
        }
        if (domains.size() == 1) {
            String foundDomain = (String)domains.iterator().next();
            if (foundDomain.equals(settings.getDomain())) {
                Optional whitelabelingParams = this.getWhiteLabelingParams(user);
                boolean whitelabelingEnabled = whitelabelingParams.isPresent();
                if (!whitelabelingEnabled && settings.getPaletteSelection() == PaletteSelection.TB_SELECTION) {
                    throw new TbWhitelabelingLoadException("TB service does not have white labeling");
                }
                if (whitelabelingParams.isPresent()) {
                    PaletteSettings paletteSettings = whitelabelingParams.map(WhiteLabelingParams::getPaletteSettings).orElse(null);
                    settings.setTbPaletteSettings(paletteSettings);
                }
                log.debug("Saved customization for self-hosted with domain and tenant: domain = {}, user = {}", (Object)settings.getDomain(), (Object)user);
                return this.saveCustomViewSettings(settings, user);
            }
            log.warn("You can set only your customization settings, details: domain = {}}, asked domain = {}, user = {}, registered domains = {}", new Object[]{domain, settings.getDomain(), user, domains});
            throw new CustomizationException("You can set only your customization settings!");
        }
        log.warn("You have ambiguous domain settings, details: domain = {}}, asked domain = {}, user = {}, registered domains = {}", new Object[]{domain, settings.getDomain(), user, domains});
        throw new CustomizationException("You have ambiguous domain settings!");
    }

    public String fetchUserLanguage(JwtSecurityUser user) {
        String defaultLanguage = "en_US";
        String jwtToken = this.authenticationService.getToken(user);
        Optional langOpt = (Optional)DonReactive.block((Mono)this.tbRestDataSource.getUserByUserId(jwtToken, user.getUserId()).map(u -> {
            JsonNode userAdditionalInfo = u.getAdditionalInfo();
            if (Objects.isNull(userAdditionalInfo) || userAdditionalInfo.isNull()) {
                return Optional.empty();
            }
            JsonNode langNode = userAdditionalInfo.get("lang");
            if (Objects.isNull(langNode) || langNode.isNull()) {
                return Optional.empty();
            }
            return Optional.of(langNode.asText());
        }).defaultIfEmpty(Optional.empty()));
        if (Objects.isNull(langOpt)) {
            return "en_US";
        }
        return langOpt.orElse("en_US");
    }

    private CustomViewSettings provideCustomViewSettings(String domain) {
        String key = this.getCustomViewSettingsKey(domain, null);
        return (CustomViewSettings)this.customViewSettingsCache.get((Object)key, () -> this.customViewSettingsDao.findCustomSettings(domain).orElseGet(() -> this.createDefaultCustomViewSettings(domain)));
    }

    private CustomViewSettings provideCustomViewSettings(String domain, JwtSecurityUser user) {
        String key = this.getCustomViewSettingsKey(domain, user);
        CustomViewSettings cachedValue = (CustomViewSettings)this.customViewSettingsCache.get((Object)key, CustomViewSettings.class);
        if (cachedValue == null) {
            cachedValue = this.customViewSettingsDao.findCustomSettings(domain).orElseGet(() -> {
                CustomViewSettings defaultData = this.createDefaultCustomViewSettings(domain, user);
                this.customViewSettingsDao.saveCustomSettings(defaultData);
                this.saveCustomViewSettings(defaultData, user);
                return defaultData;
            });
        }
        return cachedValue;
    }

    private CustomViewSettings createDefaultCustomViewSettings(String domain) {
        return this.createDefaultCustomViewSettings(domain, null);
    }

    private CustomViewSettings createDefaultCustomViewSettings(String domain, JwtSecurityUser user) {
        PaletteSettings tbPaletteSettings = user == null ? null : (PaletteSettings)this.getWhiteLabelingParams(user).map(WhiteLabelingParams::getPaletteSettings).orElse(null);
        return CustomViewSettings.builder().domain(domain).url(WHITELABELING_DEFAULT_PREFIX).paletteSelection(PaletteSelection.DEFAULT).trendzPaletteSettings(null).tbPaletteSettings(null).tabName("Trendz").logoBase64(null).darkMode(false).tbPaletteSettings(tbPaletteSettings).trendzPaletteSettings(this.getDefaultPaletteSettings()).thingsboardRedirectUrl("None").build();
    }

    private CustomViewSettings saveCustomViewSettings(CustomViewSettings settings, JwtSecurityUser user) {
        String keyWithUser = this.getCustomViewSettingsKey(settings.getDomain(), user);
        String keyWithoutUser = this.getCustomViewSettingsKey(settings.getDomain(), null);
        this.customViewSettingsCache.put((Object)keyWithUser, (Object)settings);
        this.customViewSettingsCache.put((Object)keyWithoutUser, (Object)settings);
        this.domainAllowedWhiteLabelingCache.evict((Object)settings.getDomain());
        return this.customViewSettingsDao.saveCustomSettings(settings);
    }

    private boolean licenseForbidsWhiteLabeling(JwtSecurityUser user) {
        SubscriptionType subscriptionType = this.licenceService.getSubscriptionType(user);
        return subscriptionType != null && Set.of(SubscriptionType.UNKNOWN, SubscriptionType.MAKER).contains(subscriptionType);
    }

    private String getCustomViewSettingsKey(String domain, JwtSecurityUser user) {
        if (user == null) {
            return domain;
        }
        return domain + String.valueOf(user);
    }

    private void validateSettings(CustomViewSettings settings) {
        Set<String> forbiddenUrls;
        Set<String> allowedUrls;
        if (this.cloud ? !(allowedUrls = Set.of(WHITELABELING_DEFAULT_PREFIX, WHITELABELING_CLOUD_ALTERNATIVE_PREFIX)).contains(settings.getUrl()) : (forbiddenUrls = Set.of("", WHITELABELING_API_PREFIX)).contains(settings.getUrl())) {
            throw new TrendzCustomizationException("Forbidden url!");
        }
    }

    private Optional<WhiteLabelingParams> getWhiteLabelingParams(JwtSecurityUser user) {
        try {
            String jwtToken = this.authenticationService.getToken(user);
            return (Optional)DonReactive.block((Mono)this.tbRestDataSource.loadCurrentWhiteLabelParams(jwtToken));
        }
        catch (TbWebClientException e) {
            if (e.getCause() instanceof WebClientResponseException.Forbidden) {
                return Optional.empty();
            }
            if (e.getCause() instanceof WebClientResponseException.NotFound) {
                return Optional.empty();
            }
            throw e;
        }
    }

    private PaletteSettings getDefaultPaletteSettings() {
        Palette primaryPalette = new Palette();
        primaryPalette.setColors(Map.of("color", "#5555FF", "contrastColor", "#555563"));
        Palette accentPalette = new Palette();
        PaletteSettings paletteSettings = new PaletteSettings();
        paletteSettings.setPrimaryPalette(primaryPalette);
        paletteSettings.setAccentPalette(accentPalette);
        return paletteSettings;
    }
}

