/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.chat;

import java.util.Optional;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.domain.assistance.ErrorMetadata;
import org.thingsboard.trendz.domain.chat.ChatMessage;
import org.thingsboard.trendz.domain.chat.ChatRequest;
import org.thingsboard.trendz.domain.chat.ChatType;
import org.thingsboard.trendz.exception.TrendzException;
import org.thingsboard.trendz.exception.assistance.AiAgentErrorException;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.assistance.domain.ViewAssistanceContext;
import org.thingsboard.trendz.service.assistance.domain.ViewAssistanceResponse;
import org.thingsboard.trendz.service.assistance.domain.ViewAssistanceState;
import org.thingsboard.trendz.service.assistance.view.ViewAssistanceSupervisor;
import org.thingsboard.trendz.service.chat.ChatMessageProcessor;
import org.thingsboard.trendz.service.chat.ChatService;
import org.thingsboard.trendz.service.task.TaskExecutionProgressStepBuilder;
import org.thingsboard.trendz.tools.json.JsonUtils;
import reactor.core.publisher.Mono;

@Service
public class ViewAssistanceChatMessageProcessor
implements ChatMessageProcessor<ViewAssistanceContext> {
    private final ViewAssistanceSupervisor viewAssistanceSupervisor;
    private final ChatService chatService;

    @Autowired
    public ViewAssistanceChatMessageProcessor(ViewAssistanceSupervisor viewAssistanceSupervisor, ChatService chatService) {
        this.viewAssistanceSupervisor = viewAssistanceSupervisor;
        this.chatService = chatService;
    }

    public ChatType getChatType() {
        return ChatType.VIEW_ASSISTANT;
    }

    public Mono<?> processChatRequest(TaskExecutionProgressStepBuilder stepBuilder, ViewAssistanceContext context) {
        ViewAssistanceResponse viewAssistanceResponse = new ViewAssistanceResponse();
        try {
            viewAssistanceResponse = this.viewAssistanceSupervisor.processRequest(context);
        }
        catch (AiAgentErrorException aiAgentErrorException) {
            viewAssistanceResponse = ViewAssistanceResponse.builder().errorMetadata(aiAgentErrorException.getErrorMetadata()).build();
        }
        catch (TrendzException e) {
            viewAssistanceResponse.setErrorMetadata(ErrorMetadata.builder().comment(e.getMessage()).build());
            throw e;
        }
        catch (Throwable e) {
            viewAssistanceResponse.setErrorMetadata(ErrorMetadata.builder().comment(e.getMessage()).build());
            throw new TrendzException("Something went wrong", e);
        }
        finally {
            viewAssistanceResponse.setAgentMetadataList(context.getAgentMetadataContainer());
            viewAssistanceResponse.setViewAssistanceState(context.getViewAssistanceState());
            this.chatService.populateChatMessageJsonJobResponse(context.getMessageId(), viewAssistanceResponse);
            this.chatService.populateChatSummary(context.getChatId(), context.getChatSummary());
        }
        return Mono.just((Object)viewAssistanceResponse);
    }

    public ViewAssistanceContext createNewContext(ChatRequest chatRequest, JwtSecurityUser user) {
        Optional<ViewAssistanceResponse> previousResponse = this.chatService.getLastChatMessage(user, chatRequest.getChatId(), Set.of(chatRequest.getMessageId())).map(ChatMessage::getJsonJobResponse).map(s -> (ViewAssistanceResponse)JsonUtils.fromJson((String)s, ViewAssistanceResponse.class));
        ViewAssistanceContext context = new ViewAssistanceContext();
        previousResponse.ifPresentOrElse(viewAssistanceResponse -> {
            context.setPreviousMessageAgentMetadata(viewAssistanceResponse.getAgentMetadataList());
            context.setViewAssistanceState(viewAssistanceResponse.getViewAssistanceState());
            context.setPreviousViewConfig(viewAssistanceResponse.getGeneratedViewConfig());
        }, () -> context.setViewAssistanceState(new ViewAssistanceState()));
        return context;
    }
}

