/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.chat;

import java.util.ArrayList;
import java.util.Optional;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.domain.assistance.ErrorMetadata;
import org.thingsboard.trendz.domain.chat.ChatMessage;
import org.thingsboard.trendz.domain.chat.ChatRequest;
import org.thingsboard.trendz.domain.chat.ChatType;
import org.thingsboard.trendz.domain.definition.entity.BusinessEntity;
import org.thingsboard.trendz.domain.metric.MetricDefinition;
import org.thingsboard.trendz.domain.metric.assistance.MetricCodeAssistanceContext;
import org.thingsboard.trendz.domain.metric.assistance.MetricCodeAssistanceResponse;
import org.thingsboard.trendz.exception.TrendzException;
import org.thingsboard.trendz.exception.service.definition.BusinessEntityNotFoundException;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.chat.ChatMessageProcessor;
import org.thingsboard.trendz.service.chat.ChatService;
import org.thingsboard.trendz.service.definition.BusinessEntityService;
import org.thingsboard.trendz.service.metric.MetricExplorationService;
import org.thingsboard.trendz.service.metric.assistance.MetricCodeAssistanceSupervisor;
import org.thingsboard.trendz.service.task.TaskExecutionProgressStepBuilder;
import org.thingsboard.trendz.tools.json.JsonUtils;
import reactor.core.publisher.Mono;

@Service
public class MetricCodeAssistanceChatMessageProcessor
implements ChatMessageProcessor<MetricCodeAssistanceContext> {
    private final ChatService chatService;
    private final BusinessEntityService businessEntityService;
    private final MetricExplorationService metricExplorationService;
    private final MetricCodeAssistanceSupervisor metricCodeAssistanceSupervisor;

    @Autowired
    public MetricCodeAssistanceChatMessageProcessor(ChatService chatService, BusinessEntityService businessEntityService, MetricExplorationService metricExplorationService, MetricCodeAssistanceSupervisor metricCodeAssistanceSupervisor) {
        this.chatService = chatService;
        this.businessEntityService = businessEntityService;
        this.metricExplorationService = metricExplorationService;
        this.metricCodeAssistanceSupervisor = metricCodeAssistanceSupervisor;
    }

    public ChatType getChatType() {
        return ChatType.METRIC_CODE_ASSISTANT;
    }

    public Mono<?> processChatRequest(TaskExecutionProgressStepBuilder stepBuilder, MetricCodeAssistanceContext context) {
        if (context.getMetricDefinition() == null) {
            MetricDefinition metricDefinition = this.metricExplorationService.getMetricDefinitionById(context.getChatLite().getMetricId(), context.getUser());
            context.setMetricDefinition(metricDefinition);
        }
        if (context.getCode() == null) {
            context.setCode(context.getMetricDefinition().getCode());
        }
        if (context.getItemId() == null) {
            context.setItemId(context.getMetricDefinition().getItem().getId());
        }
        BusinessEntity businessEntity = (BusinessEntity)this.businessEntityService.findEntityById(context.getUser(), context.getMetricDefinition().getBusinessEntityId()).orElseThrow(() -> new BusinessEntityNotFoundException(context.getMetricDefinition().getBusinessEntityId(), context.getUser().getTenantId()));
        context.setBusinessEntity(businessEntity);
        MetricCodeAssistanceResponse response = new MetricCodeAssistanceResponse();
        try {
            response = this.metricCodeAssistanceSupervisor.process(stepBuilder, context);
        }
        catch (TrendzException e) {
            response.setErrorMetadata(ErrorMetadata.builder().comment(e.getMessage()).build());
            throw e;
        }
        catch (Throwable e) {
            response.setErrorMetadata(ErrorMetadata.builder().comment(e.getMessage()).build());
            throw new TrendzException("Something went wrong", e);
        }
        finally {
            response.setAgentMetadataList(context.getAgentMetadataContainer());
            this.chatService.populateChatMessageJsonJobResponse(context.getMessageId(), response);
            this.chatService.populateChatSummary(context.getChatId(), context.getChatSummary());
        }
        return Mono.just((Object)response);
    }

    public MetricCodeAssistanceContext createNewContext(ChatRequest chatRequest, JwtSecurityUser user) {
        MetricCodeAssistanceContext context = new MetricCodeAssistanceContext();
        context.setCode(chatRequest.getCode());
        context.setItemId(chatRequest.getItemId());
        context.setDatePickerConfig(chatRequest.getDatePickerConfig());
        Optional<MetricCodeAssistanceResponse> previousResponse = this.chatService.getLastChatMessage(user, chatRequest.getChatId(), Set.of(chatRequest.getMessageId())).map(ChatMessage::getJsonJobResponse).map(s -> (MetricCodeAssistanceResponse)JsonUtils.fromJson((String)s, MetricCodeAssistanceResponse.class));
        previousResponse.ifPresentOrElse(response -> {
            response.getAllRequirements().forEach(metricDefinitionRequirement -> metricDefinitionRequirement.setNew(false));
            context.setMetricDefinition(response.getModified());
            context.setRequirementList(response.getAllRequirements());
        }, () -> context.setRequirementList(new ArrayList()));
        return context;
    }
}

