/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.chat;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.springframework.data.domain.Page;
import org.thingsboard.trendz.domain.chat.Chat;
import org.thingsboard.trendz.domain.chat.ChatConfig;
import org.thingsboard.trendz.domain.chat.ChatFilteringField;
import org.thingsboard.trendz.domain.chat.ChatInitRequest;
import org.thingsboard.trendz.domain.chat.ChatLite;
import org.thingsboard.trendz.domain.chat.ChatMessage;
import org.thingsboard.trendz.domain.chat.ChatMessageLite;
import org.thingsboard.trendz.domain.chat.ChatMessagePostRequest;
import org.thingsboard.trendz.domain.chat.ChatMessageProcessResponse;
import org.thingsboard.trendz.domain.chat.ChatMessageSortingField;
import org.thingsboard.trendz.domain.chat.ChatSortingField;
import org.thingsboard.trendz.domain.metric.assistance.MetricCodeAssistanceResponse;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.assistance.domain.ViewAssistanceResponse;

public interface ChatService {
    public Page<ChatLite> getAllChatLite(int var1, int var2, JwtSecurityUser var3, List<ChatFilteringField> var4, List<ChatSortingField> var5);

    public ChatMessageProcessResponse initChat(ChatInitRequest var1, JwtSecurityUser var2);

    public ChatMessageProcessResponse postNewMessage(UUID var1, ChatMessagePostRequest var2, JwtSecurityUser var3);

    public ChatMessageProcessResponse editLastMessage(UUID var1, ChatMessagePostRequest var2, JwtSecurityUser var3);

    public ChatLite getChatLite(UUID var1, JwtSecurityUser var2);

    public Page<ChatMessageLite> getAllChatMessageLite(UUID var1, int var2, int var3, JwtSecurityUser var4, List<ChatMessageSortingField> var5);

    public List<ChatMessageLite> getAllChatMessageLite(UUID var1, JwtSecurityUser var2);

    public ChatMessage getChatMessage(UUID var1, UUID var2, JwtSecurityUser var3);

    public void populateChatMessageJsonJobResponse(UUID var1, ViewAssistanceResponse var2);

    public void populateChatMessageJsonJobResponse(UUID var1, MetricCodeAssistanceResponse var2);

    public void populateChatSummary(UUID var1, String var2);

    public void deleteChat(UUID var1, JwtSecurityUser var2);

    public ChatLite updateChat(UUID var1, ChatConfig var2, JwtSecurityUser var3);

    public List<Chat> getAllChats(JwtSecurityUser var1);

    public List<ChatMessage> getAllChatMessages(JwtSecurityUser var1);

    public List<Chat> importAllChats(JwtSecurityUser var1, List<Chat> var2);

    public List<ChatMessage> importAllChatMessages(List<ChatMessage> var1);

    public Optional<ChatMessage> getLastChatMessage(JwtSecurityUser var1, UUID var2, Set<UUID> var3);
}

