/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.calculation;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.Device;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.asset.Asset;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.IdBased;
import org.thingsboard.trendz.domain.definition.calculation.proxy.AttributeLite;
import org.thingsboard.trendz.domain.definition.calculation.proxy.AttributeRequest;
import org.thingsboard.trendz.domain.definition.calculation.proxy.AttributesProxyRequest;
import org.thingsboard.trendz.domain.definition.calculation.proxy.RelationLite;
import org.thingsboard.trendz.domain.definition.calculation.proxy.RelationsProxyRequest;
import org.thingsboard.trendz.domain.definition.calculation.proxy.TelemetryProxyRequest;
import org.thingsboard.trendz.domain.definition.entity.BusinessEntityType;
import org.thingsboard.trendz.domain.definition.entity.relation.Direction;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.security.service.AuthenticationService;
import org.thingsboard.trendz.service.calculation.TrendzProxyService;
import org.thingsboard.trendz.service.provider.TbRestDataSource;
import org.thingsboard.trendz.service.provider.TsData;
import org.thingsboard.trendz.tools.DonReactive;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Service
public class TrendzProxyService {
    private static final Logger log = LoggerFactory.getLogger(TrendzProxyService.class);
    private static final Set<EntityType> SUPPORTED_ENTITY_TYPES = Set.of(EntityType.ASSET, EntityType.DEVICE);
    private final AuthenticationService authenticationService;
    private final TbRestDataSource tbRestDataSource;

    @Autowired
    public TrendzProxyService(AuthenticationService authenticationService, TbRestDataSource tbRestDataSource) {
        this.authenticationService = authenticationService;
        this.tbRestDataSource = tbRestDataSource;
    }

    public Map<String, List<TsData>> retrieveTelemetry(TelemetryProxyRequest request, JwtSecurityUser user) {
        if (EntityId.NULL_UUID.equals(request.getEntityId())) {
            return Collections.emptyMap();
        }
        String jwtToken = this.authenticationService.getToken(user);
        Mono monoTelemetryMap = this.tbRestDataSource.loadTelemetry(BusinessEntityType.valueOf((String)request.getEntityType().name()), request.getEntityId(), String.join((CharSequence)",", request.getKeys()), request.getStartTs(), request.getEndTs(), jwtToken).doOnNext(map -> request.getKeys().forEach(key -> map.putIfAbsent(key, Collections.emptyList())));
        return (Map)DonReactive.block((Mono)monoTelemetryMap);
    }

    public Map<String, Map<String, Object>> retrieveAttributes(AttributesProxyRequest request, JwtSecurityUser user) {
        if (EntityId.NULL_UUID.equals(request.getEntityId())) {
            return Collections.emptyMap();
        }
        String jwtToken = this.authenticationService.getToken(user);
        Map requestMap = request.getAttributes().stream().collect(Collectors.groupingBy(AttributeRequest::getScope, Collectors.mapping(AttributeRequest::getKey, Collectors.toSet())));
        Mono monoAttributesMap = Flux.fromIterable(requestMap.keySet()).flatMap(scope -> this.getAttributes(scope, request.getAttributes(), request.getEntityType(), jwtToken, request.getEntityId())).collect(Collectors.groupingBy(AttributeLite::getScope, Collectors.toMap(AttributeLite::getKey, AttributeLite::getValue))).doOnNext(scopeMap -> requestMap.forEach((scope, keySet) -> keySet.forEach(key -> ((Map)scopeMap.putIfAbsent(scope, new HashMap())).putIfAbsent(key, null))));
        return (Map)DonReactive.block((Mono)monoAttributesMap);
    }

    public List<RelationLite> retrieveRelations(RelationsProxyRequest request, JwtSecurityUser user) {
        if (EntityId.NULL_UUID.equals(request.getEntityId())) {
            return Collections.emptyList();
        }
        String jwtToken = this.authenticationService.getToken(user);
        Set<Direction> directionSet = request.getDirection() == null ? Set.of(Direction.TO, Direction.FROM) : Set.of(request.getDirection());
        Mono relationsMono = Flux.fromIterable(directionSet).flatMap(direction -> this.getRelations(request, jwtToken, direction)).filter(relation -> SUPPORTED_ENTITY_TYPES.contains(relation.getEntityType())).filter(relation -> request.getTargetEntityType() == null || relation.getEntityType() == request.getTargetEntityType()).collectList().flatMap(list -> {
            HashSet deviceIds = new HashSet();
            HashSet assertIds = new HashSet();
            list.forEach(relation -> {
                switch (1.$SwitchMap$org$thingsboard$server$common$data$EntityType[relation.getEntityType().ordinal()]) {
                    case 1: {
                        deviceIds.add(relation.getEntityId());
                        break;
                    }
                    case 2: {
                        assertIds.add(relation.getEntityId());
                    }
                }
            });
            Mono devices = deviceIds.isEmpty() ? Mono.just(Collections.emptyList()) : this.tbRestDataSource.loadDevicesByIdsAsync(null, deviceIds, jwtToken);
            Mono assets = assertIds.isEmpty() ? Mono.just(Collections.emptyList()) : this.tbRestDataSource.loadAssetsByIdsAsync(null, assertIds, jwtToken);
            Mono deviceSourceMap = devices.flatMapIterable(Function.identity()).collect(Collectors.toMap(IdBased::getUuidId, Device::getType));
            Mono assetSourceMap = assets.flatMapIterable(Function.identity()).collect(Collectors.toMap(IdBased::getUuidId, Asset::getType));
            return Mono.zip((Mono)deviceSourceMap, (Mono)assetSourceMap).map(pair -> list.stream().peek(relation -> {
                Map sourceMap = switch (1.$SwitchMap$org$thingsboard$server$common$data$EntityType[relation.getEntityType().ordinal()]) {
                    case 1 -> (Map)pair.getT1();
                    case 2 -> (Map)pair.getT2();
                    default -> Collections.emptyMap();
                };
                relation.setEntityProfileName((String)sourceMap.get(relation.getEntityId()));
            }).filter(relation -> request.getTargetEntityProfileName() == null || request.getTargetEntityProfileName().equals(relation.getEntityProfileName())).toList());
        });
        try {
            return (List)DonReactive.block((Mono)relationsMono);
        }
        catch (RuntimeException e) {
            log.error("ERROR", (Throwable)e);
            throw e;
        }
    }

    private Flux<RelationLite> getRelations(RelationsProxyRequest request, String jwtToken, Direction direction) {
        return this.tbRestDataSource.findRelations(request.getEntityId(), request.getEntityType().name(), jwtToken, request.getRelationType(), direction).map(entityRelation -> {
            EntityId targetEntity = direction == Direction.TO ? entityRelation.getFrom() : entityRelation.getTo();
            return RelationLite.builder().relationType(entityRelation.getType()).entityId(targetEntity.getId()).entityType(targetEntity.getEntityType()).direction(direction).build();
        });
    }

    private Flux<AttributeLite> getAttributes(String scope, List<AttributeRequest> requests, String entityType, String jwtToken, UUID itemId) {
        String keys = requests.stream().filter(request -> request.getScope().equals(scope)).map(AttributeRequest::getKey).collect(Collectors.joining(","));
        return this.tbRestDataSource.loadAttribute(null, entityType, itemId, scope, keys, jwtToken).map(attributeData -> AttributeLite.builder().key(attributeData.getKey()).value(attributeData.getValue()).scope(scope).build());
    }
}

