/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.calculation;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.dao.TimeStampUUIDGenerator;
import org.thingsboard.trendz.dao.calculation.CalculationFieldDao;
import org.thingsboard.trendz.dao.calculation.CalculationFieldTaskDataDao;
import org.thingsboard.trendz.dao.metric.MetricDefinitionDao;
import org.thingsboard.trendz.domain.definition.calculation.CalculationField;
import org.thingsboard.trendz.domain.definition.calculation.CalculationFieldFilteringField;
import org.thingsboard.trendz.domain.definition.calculation.CalculationFieldLite;
import org.thingsboard.trendz.domain.definition.calculation.CalculationFieldSortingField;
import org.thingsboard.trendz.domain.definition.calculation.CalculationFieldTaskData;
import org.thingsboard.trendz.domain.definition.entity.BusinessEntity;
import org.thingsboard.trendz.domain.definition.entity.field.BusinessEntityField;
import org.thingsboard.trendz.domain.definition.entity.field.BusinessEntityFieldQuery;
import org.thingsboard.trendz.domain.definition.entity.field.FieldQueryType;
import org.thingsboard.trendz.exception.TrendzException;
import org.thingsboard.trendz.exception.calculation.CalculationFieldNotFoundException;
import org.thingsboard.trendz.exception.calculation.CalculationFieldTaskDataNotFound;
import org.thingsboard.trendz.exception.calculation.TrendzCalculationFieldException;
import org.thingsboard.trendz.exception.service.definition.BusinessEntityNotFoundException;
import org.thingsboard.trendz.exception.task.TaskNotFoundException;
import org.thingsboard.trendz.exception.view.TrendzViewException;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.definition.BusinessEntityClient;
import org.thingsboard.trendz.service.definition.BusinessEntityService;
import org.thingsboard.trendz.service.definition.ChangeEntityValidationInfo;
import org.thingsboard.trendz.service.provider.TbCustomerRelationService;
import org.thingsboard.trendz.service.task.TaskJob;
import org.thingsboard.trendz.service.task.TaskManagementService;
import org.thingsboard.trendz.service.task.TaskService;
import org.thingsboard.trendz.service.task.job.SaveCalculationFieldToTbJob;
import org.thingsboard.trendz.service.task.job.TestCalculationFieldJob;
import org.thingsboard.trendz.service.task.model.Task;
import org.thingsboard.trendz.service.task.model.TaskConfig;
import org.thingsboard.trendz.service.task.model.TaskReference;
import org.thingsboard.trendz.service.task.model.TaskReferencedEntityType;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class CalculationFieldService {
    private static final Logger log = LoggerFactory.getLogger(CalculationFieldService.class);
    public static final String CALCULATION_FIELD_KEY_PREFIX = "_ECD_";
    private final CalculationFieldDao calculationFieldDao;
    private final MetricDefinitionDao metricDefinitionDao;
    private final BusinessEntityService businessEntityService;
    private final BusinessEntityClient businessEntityClient;
    private final TaskService taskService;
    private final TaskManagementService taskManagementService;
    private final CalculationFieldTaskDataDao calculationFieldTaskDataDao;
    private final TbCustomerRelationService relationService;

    @Autowired
    public CalculationFieldService(CalculationFieldDao calculationFieldDao, MetricDefinitionDao metricDefinitionDao, BusinessEntityService businessEntityService, BusinessEntityClient businessEntityClient, TaskService taskService, TaskManagementService taskManagementService, CalculationFieldTaskDataDao calculationFieldTaskDataDao, TbCustomerRelationService relationService) {
        this.calculationFieldDao = calculationFieldDao;
        this.metricDefinitionDao = metricDefinitionDao;
        this.businessEntityService = businessEntityService;
        this.businessEntityClient = businessEntityClient;
        this.taskService = taskService;
        this.taskManagementService = taskManagementService;
        this.calculationFieldTaskDataDao = calculationFieldTaskDataDao;
        this.relationService = relationService;
    }

    public Page<CalculationFieldLite> getAllLite(JwtSecurityUser user, int page, int pageSize, List<CalculationFieldFilteringField> filteringFields, List<CalculationFieldSortingField> sortingFields) {
        return this.calculationFieldDao.getAllLite(user, page, pageSize, filteringFields, sortingFields);
    }

    public List<CalculationField> getAll(JwtSecurityUser user) {
        return this.calculationFieldDao.getAll(user);
    }

    public Optional<CalculationField> findById(JwtSecurityUser user, UUID id) {
        return this.findById(user, id, false);
    }

    public Optional<CalculationField> findById(JwtSecurityUser user, UUID id, boolean insecure) {
        return this.calculationFieldDao.findById(user, id, insecure);
    }

    public Optional<CalculationField> findByName(JwtSecurityUser user, String name) {
        return this.calculationFieldDao.findByName(user, name);
    }

    public CalculationField save(JwtSecurityUser user, CalculationField field) {
        field.validateField();
        long now = System.currentTimeMillis();
        if (field.getId() == null) {
            if (!CalculationField.checkUserOwnership((CalculationField)field, (JwtSecurityUser)user)) {
                throw new TrendzCalculationFieldException("You can not save calculation field assigned to another user.");
            }
            boolean exists = this.calculationFieldDao.existsWithName(user, field.getName());
            if (exists) {
                throw new TrendzCalculationFieldException("The name of calculation field is already used: " + field.getName());
            }
            BusinessEntityField associatedEntityField = this.updateAssociatedEntityField(user, field);
            field.setId(TimeStampUUIDGenerator.generateId());
            field.setEnabled(false);
            field.setCreationTime(now);
            field.setAssociatedEntityFieldId(associatedEntityField.getId());
            CalculationFieldTaskData taskData = CalculationFieldTaskData.getDefault((UUID)field.getId());
            this.calculationFieldTaskDataDao.save(taskData);
        } else {
            boolean exists;
            CalculationField prevField = (CalculationField)this.findById(user, field.getId()).orElseThrow(() -> new CalculationFieldNotFoundException(field.getId()));
            if (!prevField.getName().equals(field.getName()) && (exists = this.calculationFieldDao.existsWithName(user, field.getName()))) {
                throw new TrendzCalculationFieldException("The name of calculation field is already used: " + field.getName());
            }
            if (!CalculationField.checkSameOwnership((CalculationField)field, (CalculationField)prevField)) {
                throw new TrendzCalculationFieldException("You can not change ownership of calculation field.");
            }
            if (prevField.isEnabled() != field.isEnabled()) {
                throw new TrendzCalculationFieldException("You can not change enabling of calculation field directly.");
            }
            this.checkOwnershipChange(user, prevField, field);
            this.updateAssociatedEntityField(user, field);
        }
        this.createTestTasks(user, field);
        this.createReprocessTasks(user, field);
        this.createRefreshTasks(user, field);
        field.setUpdateTime(now);
        CalculationField saved = this.calculationFieldDao.save(field);
        this.metricDefinitionDao.makeMetricDefinitionsOutdated(field, user);
        log.info("The calculation field was saved, name = {}, id = {}", (Object)saved.getName(), (Object)saved.getId());
        return saved;
    }

    public boolean delete(JwtSecurityUser user, UUID id) {
        CalculationField calculationField = (CalculationField)this.findById(user, id).orElseThrow(() -> new CalculationFieldNotFoundException(id));
        this.businessEntityClient.deleteBusinessEntityFieldById(user, calculationField.getBusinessEntityId(), calculationField.getAssociatedEntityFieldId());
        this.removeTasks(user, calculationField);
        this.metricDefinitionDao.findMetricDefinitionCalculationFieldId(calculationField.getId(), user).ifPresent(metricDefinition -> {
            metricDefinition.setCalculationFieldId(null);
            this.metricDefinitionDao.save(metricDefinition);
        });
        this.calculationFieldDao.delete(user, id);
        this.calculationFieldTaskDataDao.delete(id);
        return true;
    }

    public boolean rename(JwtSecurityUser user, UUID id, String newName) {
        CalculationField calculationField = (CalculationField)this.findById(user, id).orElseThrow(() -> new CalculationFieldNotFoundException(id));
        boolean exists = this.calculationFieldDao.existsWithName(user, newName);
        if (exists) {
            throw new TrendzCalculationFieldException("The name of calculation field is already used: " + newName);
        }
        if (!CalculationField.checkUserOwnership((CalculationField)calculationField, (JwtSecurityUser)user)) {
            throw new TrendzViewException("You can rename only your calculation field");
        }
        this.calculationFieldDao.rename(newName, user, id);
        this.businessEntityClient.renameBusinessEntityFieldById(user, calculationField.getBusinessEntityId(), calculationField.getAssociatedEntityFieldId(), newName);
        calculationField.setName(newName);
        this.createTestTasks(user, calculationField);
        return true;
    }

    public CalculationFieldTaskData getTaskData(JwtSecurityUser user, UUID id) {
        CalculationFieldTaskData taskData = (CalculationFieldTaskData)this.calculationFieldTaskDataDao.findById(id).orElseThrow(() -> new CalculationFieldTaskDataNotFound(id));
        TaskReference reference = new TaskReference(TaskReferencedEntityType.CALCULATION_FIELD_REFRESH, id.toString());
        long schedulingTime = (Long)this.taskService.getTaskSchedulingTime(user, reference).orElseThrow(() -> new TaskNotFoundException(id));
        taskData.setSchedulingTime(schedulingTime);
        return taskData;
    }

    public CalculationFieldTaskData saveTaskData(CalculationFieldTaskData data) {
        return this.calculationFieldTaskDataDao.save(data);
    }

    public void updateEnabling(JwtSecurityUser user, UUID id, boolean enabled) {
        this.calculationFieldDao.updateEnabling(user, id, enabled);
    }

    public Optional<CalculationField> findFieldByEntityFieldId(UUID entityFieldId, JwtSecurityUser user) {
        return this.findFieldByEntityFieldId(entityFieldId, user, false);
    }

    public Optional<CalculationField> findFieldByEntityFieldId(UUID entityFieldId, JwtSecurityUser user, boolean insecure) {
        return this.calculationFieldDao.findByEntityFieldId(entityFieldId, user, insecure);
    }

    public ChangeEntityValidationInfo findDependedEntities(JwtSecurityUser user, UUID fieldId) {
        CalculationField field = (CalculationField)this.findById(user, fieldId).orElseThrow(() -> new CalculationFieldNotFoundException(fieldId));
        Set subCustomers = this.relationService.getAllSubCustomerIds(user);
        return this.calculationFieldDao.findDependedEntities(user, fieldId, subCustomers);
    }

    private void checkOwnershipChange(JwtSecurityUser user, CalculationField prevField, CalculationField field) {
        UUID prevEntityId = prevField.getBusinessEntityId();
        UUID nextEntityId = field.getBusinessEntityId();
        UUID entityFieldId = field.getAssociatedEntityFieldId();
        if (!prevEntityId.equals(nextEntityId)) {
            BusinessEntity prevEntity = (BusinessEntity)this.businessEntityService.findEntityById(user, prevEntityId).orElseThrow(() -> new BusinessEntityNotFoundException(prevEntityId, user.getTenantId()));
            BusinessEntity nextEntity = (BusinessEntity)this.businessEntityService.findEntityById(user, nextEntityId).orElseThrow(() -> new BusinessEntityNotFoundException(nextEntityId, user.getTenantId()));
            BusinessEntityField entityField = prevEntity.getFields().stream().filter(i -> i.getId().equals(field.getAssociatedEntityFieldId())).findAny().orElse(null);
            if (entityField != null) {
                prevEntity.getFields().removeIf(i -> i.getId().equals(entityFieldId));
                nextEntity.getFields().add(entityField);
                this.businessEntityService.saveEntity(user, nextEntity);
                this.businessEntityService.saveEntity(user, prevEntity);
            }
        }
    }

    private BusinessEntityField updateAssociatedEntityField(JwtSecurityUser user, CalculationField calculationField) {
        String queryKey = CalculationFieldService.createTbKey((String)calculationField.getTbTelemetryKey());
        BusinessEntity entity = (BusinessEntity)this.businessEntityService.findEntityById(user, calculationField.getBusinessEntityId()).orElseThrow(() -> new BusinessEntityNotFoundException(calculationField.getBusinessEntityId(), user.getTenantId()));
        List<BusinessEntityField> matchingFields = entity.getFields().stream().filter(i -> i.getId().equals(calculationField.getAssociatedEntityFieldId())).toList();
        if (matchingFields.size() > 1) {
            String badEntityFieldNameString = matchingFields.stream().map(BusinessEntityField::getName).collect(Collectors.joining(", "));
            throw new TrendzException("There are several business entities wired to the calculation field - you must to resolve inconsistency: %s".formatted(badEntityFieldNameString));
        }
        if (matchingFields.size() == 1) {
            BusinessEntityField matchingField = matchingFields.iterator().next();
            List<BusinessEntityField> ambiguousFields = entity.getFields().stream().filter(i -> !i.getId().equals(matchingField.getId())).filter(field -> queryKey.equals(field.getQuery().getKey())).toList();
            if (!ambiguousFields.isEmpty()) {
                throw new TrendzException("Telemetry with key [%s] already exist in TB, chose different name to avoid data override".formatted(queryKey));
            }
            boolean result = false;
            result |= !matchingField.getName().equals(calculationField.getName());
            result |= !matchingField.getQuery().getKey().equals(CalculationFieldService.createTbKey((String)calculationField.getTbTelemetryKey()));
            if (result |= !matchingField.getBusinessEntityId().equals(calculationField.getBusinessEntityId())) {
                matchingField.setName(calculationField.getName());
                matchingField.getQuery().setKey(CalculationFieldService.createTbKey((String)calculationField.getTbTelemetryKey()));
                this.businessEntityService.saveEntity(user, entity);
            }
            return matchingField;
        }
        List<BusinessEntityField> ambiguousFields = entity.getFields().stream().filter(field -> queryKey.equals(field.getQuery().getKey())).toList();
        if (!ambiguousFields.isEmpty()) {
            throw new TrendzException("Telemetry with key [%s] already exist in TB, chose different name to avoid data override".formatted(queryKey));
        }
        BusinessEntityField associatedEntityField = BusinessEntityField.builder().id(TimeStampUUIDGenerator.generateId()).businessEntityId(calculationField.getBusinessEntityId()).name(calculationField.getName()).description("Calculation field created by Trendz.").hidden(false).type(calculationField.getReturnDataType()).query(CalculationFieldService.createTbQuery((String)queryKey)).build();
        entity.getFields().add(associatedEntityField);
        BusinessEntity savedEntity = this.businessEntityService.saveEntity(user, entity);
        calculationField.setAssociatedEntityFieldId(associatedEntityField.getId());
        return associatedEntityField;
    }

    private void createTestTasks(JwtSecurityUser user, CalculationField field) {
        TaskReference reference = new TaskReference(TaskReferencedEntityType.CALCULATION_FIELD_TEST, field.getId().toString());
        TestCalculationFieldJob taskJob = new TestCalculationFieldJob();
        String taskName = "Calculation Field, test: " + field.getName();
        this.taskManagementService.createOrUpdateTask(user, reference, taskName, (TaskJob)taskJob);
    }

    private void createReprocessTasks(JwtSecurityUser user, CalculationField field) {
        TaskReference reference = new TaskReference(TaskReferencedEntityType.CALCULATION_FIELD_REPROCESS, field.getId().toString());
        SaveCalculationFieldToTbJob taskJob = SaveCalculationFieldToTbJob.builder().calculationId(field.getId()).reprocess(true).executionStartTs(0L).executionEndTs(0L).tzName("UTC").filterItems(Collections.emptySet()).build();
        String taskName = "Calculation Field, reprocess: " + field.getName();
        this.taskManagementService.createOrUpdateTask(user, reference, taskName, (TaskJob)taskJob);
    }

    private void createRefreshTasks(JwtSecurityUser user, CalculationField field) {
        TaskReference reference = new TaskReference(TaskReferencedEntityType.CALCULATION_FIELD_REFRESH, field.getId().toString());
        SaveCalculationFieldToTbJob taskJob = SaveCalculationFieldToTbJob.builder().calculationId(field.getId()).reprocess(false).executionStartTs(0L).executionEndTs(0L).tzName("UTC").filterItems(Collections.emptySet()).build();
        String taskName = "Calculation Field, refresh: " + field.getName();
        Consumer<TaskConfig> doNothingConsumer = taskConfig -> {};
        BiConsumer<Task, TaskConfig> doNothingBiConsumer = (task, taskConfig) -> {};
        Consumer<TaskConfig> onCreate = taskConfig -> taskConfig.setEnabled(Boolean.valueOf(false));
        this.taskManagementService.createOrUpdateTask(user, reference, taskName, (TaskJob)taskJob, doNothingConsumer, doNothingBiConsumer, onCreate);
    }

    private void removeTasks(JwtSecurityUser user, CalculationField field) {
        Stream.of(TaskReferencedEntityType.CALCULATION_FIELD_TEST, TaskReferencedEntityType.CALCULATION_FIELD_REPROCESS, TaskReferencedEntityType.CALCULATION_FIELD_REFRESH).forEach(entityType -> this.taskManagementService.deleteByTaskReference(user, new TaskReference(entityType, field.getId().toString())));
    }

    public static String createTbKey(String label) {
        return "_ECD_" + label;
    }

    public static BusinessEntityFieldQuery createTbQuery(String tbKey) {
        return new BusinessEntityFieldQuery(FieldQueryType.CALCULATED, tbKey, null);
    }
}

