/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.cache;

import com.google.common.collect.Sets;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.dao.TimeStampUUIDGenerator;
import org.thingsboard.trendz.domain.base.TimeRange;
import org.thingsboard.trendz.domain.definition.entity.BusinessEntity;
import org.thingsboard.trendz.domain.definition.entity.BusinessEntityType;
import org.thingsboard.trendz.domain.definition.entity.field.BusinessEntityField;
import org.thingsboard.trendz.domain.definition.entity.field.FieldQueryType;
import org.thingsboard.trendz.domain.definition.entity.field.FieldType;
import org.thingsboard.trendz.domain.definition.view.config.DateAggregationType;
import org.thingsboard.trendz.domain.definition.view.config.DatePickerConfig;
import org.thingsboard.trendz.domain.definition.view.config.ViewConfig;
import org.thingsboard.trendz.domain.definition.view.config.ViewField;
import org.thingsboard.trendz.domain.measurement.MeasurementReport;
import org.thingsboard.trendz.domain.runtime.DataCell;
import org.thingsboard.trendz.domain.runtime.DataRow;
import org.thingsboard.trendz.domain.runtime.ViewReport;
import org.thingsboard.trendz.exception.BadConfiguredTaskException;
import org.thingsboard.trendz.exception.TrendzException;
import org.thingsboard.trendz.exception.service.definition.BusinessEntityNotFoundException;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.calculation.CalculationFieldService;
import org.thingsboard.trendz.service.definition.BusinessEntityService;
import org.thingsboard.trendz.service.definition.TbDataEntry;
import org.thingsboard.trendz.service.provider.TbRestDataSource;
import org.thingsboard.trendz.service.script.ScriptFieldPreprocessor;
import org.thingsboard.trendz.service.view.ViewBuildingResult;
import org.thingsboard.trendz.service.view.ViewBuildingService;
import org.thingsboard.trendz.tools.DonReactive;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class SavingCalculatedTelemetryService {
    private static final Logger log = LoggerFactory.getLogger(SavingCalculatedTelemetryService.class);
    private final ViewBuildingService viewBuildingService;
    private final ScriptFieldPreprocessor scriptFieldPreprocessor;
    private final BusinessEntityService businessEntityService;
    private final TbRestDataSource tbRestDataSource;

    @Autowired
    public SavingCalculatedTelemetryService(ViewBuildingService viewBuildingService, ScriptFieldPreprocessor scriptFieldPreprocessor, BusinessEntityService businessEntityService, TbRestDataSource tbRestDataSource) {
        this.viewBuildingService = viewBuildingService;
        this.scriptFieldPreprocessor = scriptFieldPreprocessor;
        this.businessEntityService = businessEntityService;
        this.tbRestDataSource = tbRestDataSource;
    }

    public void saveTelemetryToTb(String jwtToken, JwtSecurityUser user, ViewConfig viewConfig, TimeRange timeRange, boolean createNewField) {
        ViewReport viewReport;
        log.info("Start telemetry save job for user: {} viewId: {} viewName:{} startTs: {} endTs: {}", new Object[]{user, viewConfig.getId(), viewConfig.getName(), timeRange.getStartTs(), timeRange.getEndTs()});
        DatePickerConfig datePicker = viewConfig.getDatePickerConfig();
        datePicker.setStartTs(timeRange.getStartTs());
        datePicker.setEndTs(timeRange.getEndTs());
        ZoneId zoneId = ZoneId.of(viewConfig.getTzName());
        UUID selectedBusinessEntityId = viewConfig.getRowClickEntityId();
        BusinessEntity selectedBusinessEntity = (BusinessEntity)this.businessEntityService.findEntityById(user, selectedBusinessEntityId).orElseThrow(() -> new BusinessEntityNotFoundException(selectedBusinessEntityId, user.getTenantId()));
        List allFields = viewConfig.getAllFields();
        ViewField dateField = SavingCalculatedTelemetryService.getDateField((List)allFields);
        List necessaryDataFields = allFields.stream().filter(viewField -> !viewField.isVirtualDateField()).filter(viewField -> !viewField.isHidden()).filter(viewField -> {
            if (viewField.isStateField() || viewField.isCalculatedField()) {
                return true;
            }
            if (viewField.isAnomalyField()) {
                return true;
            }
            BusinessEntityField bef = this.businessEntityService.findEntityFieldById(user, viewField.getEntityFieldId());
            return !Sets.newHashSet((Object[])new FieldQueryType[]{FieldQueryType.ENTITY_ID, FieldQueryType.ENTITY_NAME}).contains(bef.getQuery().getQueryType());
        }).collect(Collectors.toList());
        try {
            viewReport = (ViewReport)this.viewBuildingService.buildView(viewConfig, user, new MeasurementReport()).map(ViewBuildingResult::getViewReport).toFuture().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
        List dataRows = viewReport.getRows();
        if (dataRows.isEmpty()) {
            log.info("The report returned empty data list therefore the job finishes immediately.");
            return;
        }
        boolean atLeastOneDateValueExist = dataRows.stream().anyMatch(dataRow -> dataRow.findCellByFieldId(dateField.getId()) != null);
        if (!atLeastOneDateValueExist) {
            log.info("The report returned data without date (no telemetry) therefore the job finishes immediately.");
            return;
        }
        Map itemIdToDataMap = this.getItemIdToDataMap(dataRows, dateField, zoneId, necessaryDataFields);
        boolean noData = itemIdToDataMap.values().stream().allMatch(List::isEmpty);
        if (noData) {
            log.info("Suddenly, prepared data list is empty (but report is not), so data sending is canceled.");
            return;
        }
        BusinessEntityType entityType = selectedBusinessEntity.getQuery().getEntityType();
        ArrayList<Mono> sendTelemetryRequests = new ArrayList<Mono>();
        for (UUID itemId : itemIdToDataMap.keySet()) {
            List dataEntries = (List)itemIdToDataMap.get(itemId);
            if (dataEntries.isEmpty()) continue;
            Mono requestMono = this.tbRestDataSource.sendTelemetryDirectly(null, entityType.name(), itemId, jwtToken, dataEntries);
            sendTelemetryRequests.add(requestMono);
        }
        DonReactive.block((Mono)Flux.merge(sendTelemetryRequests).collectList());
        if (createNewField) {
            this.createBusinessEntityFieldByGivenData(selectedBusinessEntity, user, necessaryDataFields);
        }
    }

    public void validateViewConfig(JwtSecurityUser user, ViewConfig viewConfig) {
        if (viewConfig.getRowClickEntityId() == null) {
            throw new BadConfiguredTaskException("There is no selected business entity by row click");
        }
        List allFields = viewConfig.getAllFields();
        List<ViewField> dateFieldList = allFields.stream().filter(ViewField::isVirtualDateField).toList();
        if (dateFieldList.size() != 1) {
            throw new BadConfiguredTaskException("The view config must have only (and at least) one date field.");
        }
        ViewField dateField = dateFieldList.iterator().next();
        if (dateField.getDateGrouping() == DateAggregationType.RAW || dateField.getDateGrouping() != DateAggregationType.getFullType((DateAggregationType)dateField.getDateGrouping())) {
            throw new BadConfiguredTaskException("The date field must have full type.");
        }
        UUID selectedBusinessEntityId = viewConfig.getRowClickEntityId();
        BusinessEntity selectedBusinessEntity = (BusinessEntity)this.businessEntityService.findEntityById(user, selectedBusinessEntityId).orElseThrow(() -> new BusinessEntityNotFoundException(selectedBusinessEntityId, user.getTenantId()));
        List<ViewField> scriptFields = allFields.stream().filter(viewField -> viewField.isStateField() || viewField.isCalculatedField()).toList();
        scriptFields.forEach(viewField -> {
            this.scriptFieldPreprocessor.process(viewField, user);
            if (viewField.isCalculatedField()) {
                viewField.setBusinessEntityId(selectedBusinessEntityId);
            }
        });
        for (ViewField scriptField : scriptFields) {
            if (selectedBusinessEntityId.equals(scriptField.getBusinessEntityId())) continue;
            throw new BadConfiguredTaskException("Script fields (calculated or state) must refer to selected business entity: " + selectedBusinessEntity.getName());
        }
        List<UUID> neededUsualFieldIds = selectedBusinessEntity.getFields().stream().filter(bef -> Sets.newHashSet((Object[])new FieldQueryType[]{FieldQueryType.ENTITY_ID, FieldQueryType.ENTITY_NAME}).contains(bef.getQuery().getQueryType())).map(BusinessEntityField::getId).toList();
        List<UUID> presentUsualFieldIds = allFields.stream().filter(vf -> !vf.isVirtualDateField() && !vf.isCalculatedField()).map(ViewField::getEntityFieldId).toList();
        boolean atLeastOne = false;
        for (UUID neededUsualFieldId : neededUsualFieldIds) {
            atLeastOne = atLeastOne || presentUsualFieldIds.contains(neededUsualFieldId);
        }
        if (!atLeastOne) {
            throw new BadConfiguredTaskException("The view config must have at least name or id field of selected business entity.");
        }
    }

    private static ViewField getDateField(List<ViewField> allFields) {
        return allFields.stream().filter(ViewField::isVirtualDateField).findAny().orElseThrow(IllegalStateException::new);
    }

    private Map<UUID, List<TbDataEntry>> getItemIdToDataMap(List<DataRow> dataRows, ViewField dateField, ZoneId zoneId, List<ViewField> necessaryDataFields) {
        dataRows.forEach(dataRow -> {
            if (dataRow.getEntityIds().size() != 1) {
                throw new TrendzException("Expected 1 item when uploading to TB");
            }
        });
        HashMap<UUID, List<TbDataEntry>> itemIdToDataMap = new HashMap<UUID, List<TbDataEntry>>();
        for (DataRow dataRow2 : dataRows) {
            UUID itemId = ((DataRow.EntityIdAndName)dataRow2.getEntityIds().get(0)).entityId().getId();
            List itemData = itemIdToDataMap.computeIfAbsent(itemId, i -> new ArrayList());
            DataCell timeCell = dataRow2.findCellByFieldId(dateField.getId());
            if (timeCell == null || timeCell.getData() == null) continue;
            long ts = dateField.getDateGrouping().apply((String)timeCell.getData(), zoneId);
            HashMap<String, Object> valuesMap = new HashMap<String, Object>();
            for (ViewField dataField : necessaryDataFields) {
                DataCell dataCell = dataRow2.findCellByFieldId(dataField.getId());
                if (dataCell == null || dataCell.getData() == null) continue;
                valuesMap.put(CalculationFieldService.createTbKey((String)dataField.getLabel()), dataCell.getData());
            }
            itemData.add(new TbDataEntry(ts, valuesMap));
            itemData.sort(Comparator.comparing(TbDataEntry::getTs));
        }
        return itemIdToDataMap;
    }

    private void createBusinessEntityFieldByGivenData(BusinessEntity selectedBusinessEntity, JwtSecurityUser user, List<ViewField> necessaryDataFields) {
        for (ViewField necessaryDataField : necessaryDataFields) {
            String name = necessaryDataField.getLabel();
            String tbKey = CalculationFieldService.createTbKey((String)necessaryDataField.getLabel());
            boolean alreadyExists = selectedBusinessEntity.getFields().stream().anyMatch(businessEntityField -> businessEntityField.getName().equals(name));
            if (alreadyExists) continue;
            BusinessEntityField newEntityField = new BusinessEntityField();
            newEntityField.setId(TimeStampUUIDGenerator.generateId());
            newEntityField.setBusinessEntityId(selectedBusinessEntity.getId());
            newEntityField.setName(name);
            newEntityField.setType(FieldType.NUMERIC);
            newEntityField.setQuery(CalculationFieldService.createTbQuery((String)tbKey));
            selectedBusinessEntity.getFields().add(newEntityField);
            this.businessEntityService.saveEntity(user, selectedBusinessEntity);
        }
    }
}

