/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.assistance.view;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.trendz.domain.assistance.ErrorMetadata;
import org.thingsboard.trendz.domain.assistance.agent.AgentResponseStatus;
import org.thingsboard.trendz.domain.assistance.agent.AgentResult;
import org.thingsboard.trendz.domain.assistance.agent.AiAgentType;
import org.thingsboard.trendz.domain.assistance.agent.lite.LiteViewConfig;
import org.thingsboard.trendz.domain.assistance.agent.lite.LiteViewType;
import org.thingsboard.trendz.domain.definition.entity.BusinessEntity;
import org.thingsboard.trendz.domain.definition.view.config.CacheSettings;
import org.thingsboard.trendz.domain.definition.view.config.DateAggregationType;
import org.thingsboard.trendz.domain.definition.view.config.DatePickerConfig;
import org.thingsboard.trendz.domain.definition.view.config.RuntimeFilterField;
import org.thingsboard.trendz.domain.definition.view.config.ViewConfig;
import org.thingsboard.trendz.domain.definition.view.config.ViewField;
import org.thingsboard.trendz.domain.definition.view.config.ViewType;
import org.thingsboard.trendz.exception.assistance.AiAgentErrorException;
import org.thingsboard.trendz.service.assistance.agent.businessanalytic.BusinessAnalystExpertAgent;
import org.thingsboard.trendz.service.assistance.agent.businessanalytic.domain.BusinessAnalystExpertResult;
import org.thingsboard.trendz.service.assistance.agent.dategrouper.DateGrouperExpertAgent;
import org.thingsboard.trendz.service.assistance.agent.dategrouper.domain.DateGrouperExpertResult;
import org.thingsboard.trendz.service.assistance.agent.datepicker.DatePickerExpertAgent;
import org.thingsboard.trendz.service.assistance.agent.datepicker.domain.DatePickerExpertResult;
import org.thingsboard.trendz.service.assistance.agent.errordescriber.ErrorDescriberExpertAgent;
import org.thingsboard.trendz.service.assistance.agent.errordescriber.domain.ErrorDescriberExpertResult;
import org.thingsboard.trendz.service.assistance.agent.filter.FilterExpertAgent;
import org.thingsboard.trendz.service.assistance.agent.filter.domain.FilterExpertResult;
import org.thingsboard.trendz.service.assistance.agent.groupfinder.GroupFinderExpertAgent;
import org.thingsboard.trendz.service.assistance.agent.groupfinder.domain.GroupFinderExpertResult;
import org.thingsboard.trendz.service.assistance.agent.memorymanager.MemoryManagerExpertAgent;
import org.thingsboard.trendz.service.assistance.agent.memorymanager.domain.MemoryManagerExpertResult;
import org.thingsboard.trendz.service.assistance.agent.queryanalyzer.QueryAnalyzerExpertAgent;
import org.thingsboard.trendz.service.assistance.agent.queryanalyzer.domain.QueryAnalyzerExpertResult;
import org.thingsboard.trendz.service.assistance.agent.resultanalyzer.ResultAnalyzerExpertAgent;
import org.thingsboard.trendz.service.assistance.agent.resultanalyzer.domain.ResultAnalyzerExpertResult;
import org.thingsboard.trendz.service.assistance.agent.settings.GeneralViewSettingsExpertAgent;
import org.thingsboard.trendz.service.assistance.agent.settings.domain.GeneralViewSettingsExpertResult;
import org.thingsboard.trendz.service.assistance.agent.simpleoutput.SimpleOutputExpertAgent;
import org.thingsboard.trendz.service.assistance.agent.simpleoutput.domain.SimpleOutputExpertResult;
import org.thingsboard.trendz.service.assistance.agent.state.StateManagerExpertAgent;
import org.thingsboard.trendz.service.assistance.agent.state.domain.StateManagerExpertResult;
import org.thingsboard.trendz.service.assistance.agent.topicrouter.TopicRouterExpertAgent;
import org.thingsboard.trendz.service.assistance.agent.topicrouter.domain.TopicRouterExpertResult;
import org.thingsboard.trendz.service.assistance.agent.topologymapper.TopologyMapperExpertAgent;
import org.thingsboard.trendz.service.assistance.agent.topologymapper.domain.TopologyMapperExpertResult;
import org.thingsboard.trendz.service.assistance.agent.view.ViewExpertAgent;
import org.thingsboard.trendz.service.assistance.agent.view.domain.ViewExpertResult;
import org.thingsboard.trendz.service.assistance.domain.ViewAssistanceContext;
import org.thingsboard.trendz.service.assistance.domain.ViewAssistanceResponse;
import org.thingsboard.trendz.service.assistance.domain.ViewAssistanceState;
import org.thingsboard.trendz.service.assistance.view.ViewAssistanceSupervisor;
import org.thingsboard.trendz.service.assistance.view.ViewAssistanceSupervisorImpl;
import org.thingsboard.trendz.service.assistance.view.ViewMapper;
import org.thingsboard.trendz.service.executor.ExecutorManagementService;
import org.thingsboard.trendz.service.executor.ExecutorName;

@Service
public class ViewAssistanceSupervisorImpl
implements ViewAssistanceSupervisor {
    private static final Logger log = LoggerFactory.getLogger(ViewAssistanceSupervisorImpl.class);
    private final ExecutorService executorService;
    private final MemoryManagerExpertAgent memoryManagerExpertAgent;
    private final BusinessAnalystExpertAgent businessAnalystExpertAgent;
    private final TopicRouterExpertAgent topicRouterExpertAgent;
    private final StateManagerExpertAgent stateManagerExpertAgent;
    private final ErrorDescriberExpertAgent errorDescriberExpertAgent;
    private final ResultAnalyzerExpertAgent resultAnalyzerExpertAgent;
    private final SimpleOutputExpertAgent simpleOutputExpertAgent;
    private final GroupFinderExpertAgent groupFinderExpertAgent;
    private final QueryAnalyzerExpertAgent queryAnalyzerExpertAgent;
    private final QueryAnalyzerExpertAgent filertQueryAnalyzerExpertAgent;
    private final TopologyMapperExpertAgent topologyMapperExpertAgent;
    private final FilterExpertAgent filterExpertAgent;
    private final DatePickerExpertAgent datePickerExpertAgent;
    private final DateGrouperExpertAgent dateGrouperExpertAgent;
    private final GeneralViewSettingsExpertAgent generalViewSettingsExpertAgent;
    private final Map<AiAgentType, ViewExpertAgent> viewExpertAgentsMap;
    private final ViewMapper viewMapper;

    @Autowired
    public ViewAssistanceSupervisorImpl(MemoryManagerExpertAgent memoryManagerExpertAgent, TopicRouterExpertAgent topicRouterExpertAgent, BusinessAnalystExpertAgent businessAnalystExpertAgent, StateManagerExpertAgent stateManagerExpertAgent, ErrorDescriberExpertAgent errorDescriberExpertAgent, ResultAnalyzerExpertAgent resultAnalyzerExpertAgent, GroupFinderExpertAgent groupFinderExpertAgent, @Qualifier(value="QUERY_ANALYZER_EXPERT_AGENT") QueryAnalyzerExpertAgent queryAnalyzerExpertAgent, @Qualifier(value="FILTER_QUERY_ANALYZER_EXPERT_AGENT") QueryAnalyzerExpertAgent filertQueryAnalyzerExpertAgent, TopologyMapperExpertAgent topologyMapperExpertAgent, FilterExpertAgent filterExpertAgent, DatePickerExpertAgent datePickerExpertAgent, DateGrouperExpertAgent dateGrouperExpertAgent, GeneralViewSettingsExpertAgent generalViewSettingsExpertAgent, List<ViewExpertAgent> viewExpertAgents, ViewMapper viewMapper, ExecutorManagementService executorManagementService, SimpleOutputExpertAgent simpleOutputExpertAgent) {
        this.businessAnalystExpertAgent = businessAnalystExpertAgent;
        this.topicRouterExpertAgent = topicRouterExpertAgent;
        this.stateManagerExpertAgent = stateManagerExpertAgent;
        this.errorDescriberExpertAgent = errorDescriberExpertAgent;
        this.resultAnalyzerExpertAgent = resultAnalyzerExpertAgent;
        this.memoryManagerExpertAgent = memoryManagerExpertAgent;
        this.groupFinderExpertAgent = groupFinderExpertAgent;
        this.queryAnalyzerExpertAgent = queryAnalyzerExpertAgent;
        this.filertQueryAnalyzerExpertAgent = filertQueryAnalyzerExpertAgent;
        this.topologyMapperExpertAgent = topologyMapperExpertAgent;
        this.filterExpertAgent = filterExpertAgent;
        this.datePickerExpertAgent = datePickerExpertAgent;
        this.dateGrouperExpertAgent = dateGrouperExpertAgent;
        this.generalViewSettingsExpertAgent = generalViewSettingsExpertAgent;
        this.viewExpertAgentsMap = viewExpertAgents.stream().collect(Collectors.toMap(ViewExpertAgent::getAgentType, Function.identity()));
        this.viewMapper = viewMapper;
        this.executorService = executorManagementService.getExecutorByName(ExecutorName.AI_PROCESSOR);
        this.simpleOutputExpertAgent = simpleOutputExpertAgent;
    }

    public ViewAssistanceResponse processRequest(ViewAssistanceContext context) throws ExecutionException, InterruptedException {
        MemoryManagerExpertResult memoryManagerExpertResult = this.processInputAgent(context);
        TopicRouterExpertResult topicRouterExpertResult = this.processTopicRouterAgent(context);
        return switch (1.$SwitchMap$org$thingsboard$trendz$domain$assistance$agent$AssistantRequestCategory[topicRouterExpertResult.getMainCategory().ordinal()]) {
            default -> throw new IncompatibleClassChangeError();
            case 1 -> this.buildView(context, memoryManagerExpertResult);
            case 2, 3, 4, 5 -> throw new IllegalStateException("This exception should not be happened");
            case 6 -> {
                SimpleOutputExpertResult simpleOutput = this.simpleOutputExpertAgent.processUserQuestion(context);
                yield ViewAssistanceResponse.builder().generatedViewConfig(simpleOutput.getViewConfig()).errorMetadata(ErrorMetadata.builder().failedAgent(AiAgentType.SIMPLE_OUTPUT_EXPERT).comment(simpleOutput.getResponse()).build()).build();
            }
        };
    }

    private ViewAssistanceResponse buildView(ViewAssistanceContext context, MemoryManagerExpertResult memoryManagerExpertResult) throws ExecutionException, InterruptedException {
        StateManagerExpertResult stateManager = this.processStateManagerAgent(context, memoryManagerExpertResult);
        if (!(stateManager.isViewTypeChanged() || stateManager.isViewFieldsChanged() || stateManager.isFiltersChanged() || stateManager.isDateGroupingsChanged() || stateManager.isDatePickerChanged())) {
            SimpleOutputExpertResult simpleOutput = this.simpleOutputExpertAgent.processUserQuestion(context);
            return ViewAssistanceResponse.builder().generatedViewConfig(simpleOutput.getViewConfig()).errorMetadata(ErrorMetadata.builder().failedAgent(AiAgentType.SIMPLE_OUTPUT_EXPERT).comment(simpleOutput.getResponse()).build()).build();
        }
        BusinessAnalystExpertResult businessAnalyst = this.processBusinessAnalyticAgent(context);
        context.setQuestion(businessAnalyst.getTask());
        Future groupFinderExpertResult = this.processGroupFinderAgent(context);
        Future analyzerExpertResult = this.processQueryAnalyzerAgent(context);
        Future filterAnalyzerExpertResult = this.processFilterQueryAnalyzerAgent(context);
        Future topologyMapperExpertResult = this.processTopologyMapperAgent(context, groupFinderExpertResult, analyzerExpertResult, filterAnalyzerExpertResult);
        Future filterExpertResult = this.processFilterExpertAgent(context, groupFinderExpertResult, topologyMapperExpertResult);
        Future generalViewSettingsExpertResult = this.processGeneralViewSettingsAgent(context, analyzerExpertResult);
        Future datePickerExpertResult = this.processDatePickerAgent(context);
        Future dateGrouperExpertResult = this.processDateGrouperAgent(context, generalViewSettingsExpertResult);
        ViewExpertResult viewExpertResult = this.processViewAgent(context, topologyMapperExpertResult, dateGrouperExpertResult, generalViewSettingsExpertResult);
        GroupFinderExpertResult groupFinder = (GroupFinderExpertResult)this.retrieveAgentResult(groupFinderExpertResult, AiAgentType.GROUP_FINDER_EXPERT, context);
        FilterExpertResult filter = (FilterExpertResult)this.retrieveAgentResult(filterExpertResult, AiAgentType.FILTER_EXPERT, context);
        DatePickerExpertResult datePicker = (DatePickerExpertResult)this.retrieveAgentResult(datePickerExpertResult, AiAgentType.DATE_PICKER_EXPERT, context);
        GeneralViewSettingsExpertResult generalViewSettings = (GeneralViewSettingsExpertResult)this.retrieveAgentResult(generalViewSettingsExpertResult, AiAgentType.GENERAL_VIEW_SETTINGS_EXPERT, context);
        ViewConfig viewConfig = this.generateViewConfig(groupFinder.getAvailableTopology(), filter.getViewFields(), filter.getRuntimeFilterFields(), viewExpertResult.getLiteViewConfig(), datePicker.getDatePickerConfig(), generalViewSettings.getViewName(), context.getZoneId().getId());
        ResultAnalyzerExpertResult resultAnalyzer = this.resultAnalyzerExpertAgent.processUserQuestion(context, viewConfig);
        context.getProgressContent().complete();
        return ViewAssistanceResponse.builder().generatedViewConfig(viewConfig).errorMetadata(ErrorMetadata.builder().failedAgent(AiAgentType.RESULT_ANALYZER_EXPERT).comment(resultAnalyzer.getResponse()).build()).build();
    }

    private MemoryManagerExpertResult processInputAgent(ViewAssistanceContext context) {
        MemoryManagerExpertResult memoryManagerExpertResult = (MemoryManagerExpertResult)this.processAgent(arg_0 -> ((MemoryManagerExpertAgent)this.memoryManagerExpertAgent).processUserQuestion(arg_0), AiAgentType.MEMORY_MANAGER_EXPERT, context);
        context.setQuestion(memoryManagerExpertResult.getGeneralQuestion());
        return memoryManagerExpertResult;
    }

    private TopicRouterExpertResult processTopicRouterAgent(ViewAssistanceContext context) {
        return (TopicRouterExpertResult)this.processAgent(arg_0 -> ((TopicRouterExpertAgent)this.topicRouterExpertAgent).defineCategory(arg_0), AiAgentType.TOPIC_ROUTER_EXPERT, context);
    }

    private StateManagerExpertResult processStateManagerAgent(ViewAssistanceContext context, MemoryManagerExpertResult memoryManagerExpertResult) {
        return (StateManagerExpertResult)this.processAgent(() -> this.stateManagerExpertAgent.analyzeCache(context, memoryManagerExpertResult.getPreviousQuestion(), memoryManagerExpertResult.getSpecification()), AiAgentType.STATE_MANAGER_EXPERT, context);
    }

    private BusinessAnalystExpertResult processBusinessAnalyticAgent(ViewAssistanceContext context) {
        return (BusinessAnalystExpertResult)this.processAgent(arg_0 -> ((BusinessAnalystExpertAgent)this.businessAnalystExpertAgent).prepareQuestion(arg_0), AiAgentType.BUSINESS_ANALYTIC_EXPERT, context);
    }

    private Future<GroupFinderExpertResult> processGroupFinderAgent(ViewAssistanceContext context) {
        return this.processAgentAsync(arg_0 -> ((GroupFinderExpertAgent)this.groupFinderExpertAgent).findGroup(arg_0), AiAgentType.GROUP_FINDER_EXPERT, context);
    }

    private Future<QueryAnalyzerExpertResult> processQueryAnalyzerAgent(ViewAssistanceContext context) {
        return this.processAgentAsync(arg_0 -> ((QueryAnalyzerExpertAgent)this.queryAnalyzerExpertAgent).analyze(arg_0), AiAgentType.QUERY_ANALYZER_EXPERT, context);
    }

    private Future<QueryAnalyzerExpertResult> processFilterQueryAnalyzerAgent(ViewAssistanceContext context) {
        return this.processAgentAsync(arg_0 -> ((QueryAnalyzerExpertAgent)this.filertQueryAnalyzerExpertAgent).analyze(arg_0), AiAgentType.FILTER_QUERY_ANALYZER_EXPERT, context);
    }

    private Future<TopologyMapperExpertResult> processTopologyMapperAgent(ViewAssistanceContext context, Future<GroupFinderExpertResult> groupFinderExpertResultFuture, Future<QueryAnalyzerExpertResult> queryAnalyzerExpertResultFuture, Future<QueryAnalyzerExpertResult> filterQueryAnalyzerExpertResultFuture) throws ExecutionException, InterruptedException {
        GroupFinderExpertResult groupFinderExpertResult = (GroupFinderExpertResult)this.retrieveAgentResult(groupFinderExpertResultFuture, AiAgentType.GROUP_FINDER_EXPERT, context);
        QueryAnalyzerExpertResult queryAnalyzerExpertResult = (QueryAnalyzerExpertResult)this.retrieveAgentResult(queryAnalyzerExpertResultFuture, AiAgentType.QUERY_ANALYZER_EXPERT, context);
        QueryAnalyzerExpertResult filterQueryAnalyzerExpertResult = (QueryAnalyzerExpertResult)this.retrieveAgentResult(filterQueryAnalyzerExpertResultFuture, AiAgentType.FILTER_QUERY_ANALYZER_EXPERT, context);
        return this.processAgentAsync(() -> this.topologyMapperExpertAgent.mapTopology(context, groupFinderExpertResult.getAvailableTopology(), queryAnalyzerExpertResult.getFields().stream().toList(), filterQueryAnalyzerExpertResult.getFields().stream().toList()), AiAgentType.TOPOLOGY_MAPPER_EXPERT, context);
    }

    private Future<FilterExpertResult> processFilterExpertAgent(ViewAssistanceContext context, Future<GroupFinderExpertResult> groupFinderExpertFuture, Future<TopologyMapperExpertResult> topologyMapperExpertFuture) throws ExecutionException, InterruptedException {
        GroupFinderExpertResult groupFinderExpertResult = (GroupFinderExpertResult)this.retrieveAgentResult(groupFinderExpertFuture, AiAgentType.GROUP_FINDER_EXPERT, context);
        TopologyMapperExpertResult topologyMapperExpertResult = (TopologyMapperExpertResult)this.retrieveAgentResult(topologyMapperExpertFuture, AiAgentType.TOPOLOGY_MAPPER_EXPERT, context);
        return this.processAgentAsync(() -> this.filterExpertAgent.findAllFilters(context, topologyMapperExpertResult.getFieldsForFilters(), groupFinderExpertResult.getAvailableTopology()), AiAgentType.FILTER_EXPERT, context);
    }

    private Future<GeneralViewSettingsExpertResult> processGeneralViewSettingsAgent(ViewAssistanceContext context, Future<QueryAnalyzerExpertResult> queryAnalyzerExpertFuture) throws ExecutionException, InterruptedException {
        QueryAnalyzerExpertResult queryAnalyzerExpertResult = (QueryAnalyzerExpertResult)this.retrieveAgentResult(queryAnalyzerExpertFuture, AiAgentType.QUERY_ANALYZER_EXPERT, context);
        return this.processAgentAsync(() -> this.generalViewSettingsExpertAgent.generateViewSettings(context, queryAnalyzerExpertResult.getFields()), AiAgentType.GENERAL_VIEW_SETTINGS_EXPERT, context);
    }

    private Future<DatePickerExpertResult> processDatePickerAgent(ViewAssistanceContext context) {
        return this.processAgentAsync(arg_0 -> ((DatePickerExpertAgent)this.datePickerExpertAgent).generateDatePickerConfig(arg_0), AiAgentType.DATE_PICKER_EXPERT, context);
    }

    private Future<DateGrouperExpertResult> processDateGrouperAgent(ViewAssistanceContext context, Future<GeneralViewSettingsExpertResult> generalViewSettingsExpertFuture) throws ExecutionException, InterruptedException {
        GeneralViewSettingsExpertResult generalViewSettingsExpertResult = (GeneralViewSettingsExpertResult)this.retrieveAgentResult(generalViewSettingsExpertFuture, AiAgentType.GENERAL_VIEW_SETTINGS_EXPERT, context);
        return this.processAgentAsync(() -> this.dateGrouperExpertAgent.findDateGroupings(context, generalViewSettingsExpertResult.getLiteViewType()), AiAgentType.DATE_GROUPER_EXPERT, context);
    }

    private ViewExpertResult processViewAgent(ViewAssistanceContext context, Future<TopologyMapperExpertResult> topologyMapperExpertResultFuture, Future<DateGrouperExpertResult> dateGrouperExpertResultFuture, Future<GeneralViewSettingsExpertResult> generalViewSettingsExpertResultFuture) throws ExecutionException, InterruptedException {
        TopologyMapperExpertResult topologyMapperExpertResult = (TopologyMapperExpertResult)this.retrieveAgentResult(topologyMapperExpertResultFuture, AiAgentType.TOPOLOGY_MAPPER_EXPERT, context);
        DateGrouperExpertResult dateGrouperExpertResult = (DateGrouperExpertResult)this.retrieveAgentResult(dateGrouperExpertResultFuture, AiAgentType.DATE_GROUPER_EXPERT, context);
        GeneralViewSettingsExpertResult generalViewSettingsExpertResult = (GeneralViewSettingsExpertResult)this.retrieveAgentResult(generalViewSettingsExpertResultFuture, AiAgentType.GENERAL_VIEW_SETTINGS_EXPERT, context);
        ViewAssistanceState state = context.getViewAssistanceState();
        if (state.getView() != null) {
            return state.getView();
        }
        LiteViewType liteViewType = generalViewSettingsExpertResult.getLiteViewType();
        ViewExpertAgent viewExpertAgent = switch (1.$SwitchMap$org$thingsboard$trendz$domain$assistance$agent$lite$LiteViewType[liteViewType.ordinal()]) {
            default -> throw new IncompatibleClassChangeError();
            case 1, 2 -> (ViewExpertAgent)this.viewExpertAgentsMap.get(AiAgentType.CARD_VIEW_EXPERT);
            case 3 -> (ViewExpertAgent)this.viewExpertAgentsMap.get(AiAgentType.TABLE_VIEW_EXPERT);
            case 4 -> (ViewExpertAgent)this.viewExpertAgentsMap.get(AiAgentType.LINE_CHART_VIEW_EXPERT);
            case 5 -> (ViewExpertAgent)this.viewExpertAgentsMap.get(AiAgentType.BAR_CHART_VIEW_EXPERT);
            case 6 -> (ViewExpertAgent)this.viewExpertAgentsMap.get(AiAgentType.PIE_CHART_VIEW_EXPERT);
            case 7 -> (ViewExpertAgent)this.viewExpertAgentsMap.get(AiAgentType.HEATMAP_VIEW_EXPERT);
            case 8 -> (ViewExpertAgent)this.viewExpertAgentsMap.get(AiAgentType.HEATMAP_CALENDAR_VIEW_EXPERT);
            case 9 -> (ViewExpertAgent)this.viewExpertAgentsMap.get(AiAgentType.SCATTER_PLOT_VIEW_EXPERT);
        };
        ViewExpertResult view = (ViewExpertResult)this.processAgent(() -> viewExpertAgent.generateView(context, topologyMapperExpertResult.getFieldsForView(), dateGrouperExpertResult.getDateGroupingItems()), viewExpertAgent.getAgentType(), context);
        state.setView(view);
        return view;
    }

    private <T extends AgentResult> T processAgent(Function<ViewAssistanceContext, T> agent, AiAgentType agentType, ViewAssistanceContext context) {
        return (T)this.processAgent(() -> (AgentResult)agent.apply(context), agentType, context);
    }

    private <T extends AgentResult> T processAgent(Supplier<T> agent, AiAgentType agentType, ViewAssistanceContext context) {
        context.getProgressContent().updateContent(agentType);
        AgentResult result = (AgentResult)context.getStepBuilder().makeStep(agentType.name(), agent);
        if (AgentResponseStatus.ERROR.equals((Object)result.getStatus())) {
            this.clearState(agentType, context);
            ErrorMetadata errorMetadata = ErrorMetadata.builder().comment(result.getComment()).failedAgent(agentType).build();
            this.generateAnswerToUser(context, errorMetadata);
            throw new AiAgentErrorException(errorMetadata);
        }
        return (T)result;
    }

    private <T extends AgentResult> Future<T> processAgentAsync(Function<ViewAssistanceContext, T> agent, AiAgentType agentType, ViewAssistanceContext context) {
        return this.processAgentAsync(() -> (AgentResult)agent.apply(context), agentType, context);
    }

    private <T extends AgentResult> Future<T> processAgentAsync(Supplier<T> agent, AiAgentType agentType, ViewAssistanceContext context) {
        return this.executorService.submit(() -> {
            context.getProgressContent().updateContent(agentType);
            return (AgentResult)context.getStepBuilder().makeStep(agentType.name(), agent);
        });
    }

    private <T extends AgentResult> T retrieveAgentResult(Future<T> agentResultExecution, AiAgentType agentType, ViewAssistanceContext context) throws ExecutionException, InterruptedException {
        AgentResult agentResult = (AgentResult)agentResultExecution.get();
        if (AgentResponseStatus.ERROR.equals((Object)agentResult.getStatus())) {
            this.clearState(agentType, context);
            ErrorMetadata errorMetadata = ErrorMetadata.builder().comment(agentResult.getComment()).failedAgent(agentType).build();
            this.generateAnswerToUser(context, errorMetadata);
            throw new AiAgentErrorException(errorMetadata);
        }
        return (T)agentResult;
    }

    private void clearState(AiAgentType agentType, ViewAssistanceContext context) {
        ViewAssistanceState state = context.getViewAssistanceState();
        switch (1.$SwitchMap$org$thingsboard$trendz$domain$assistance$agent$AiAgentType[agentType.ordinal()]) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                state.setGroupFinder(null);
                state.setQueryAnalyzer(null);
                state.setTopologyMapper(null);
                state.setGeneralViewSettings(null);
                state.setDateGrouper(null);
                break;
            }
            case 9: {
                state.setTopologyMapper(null);
                state.setQueryAnalyzer(null);
                state.setFilterQueryAnalyzer(null);
                state.setView(null);
                state.setFilter(null);
                state.setGroupFinder(null);
                break;
            }
            case 10: {
                state.setTopologyMapper(null);
                state.setFilterQueryAnalyzer(null);
                state.setGroupFinder(null);
                break;
            }
            case 11: {
                state.setView(null);
                state.setGeneralViewSettings(null);
            }
        }
    }

    private void generateAnswerToUser(ViewAssistanceContext context, ErrorMetadata errorMetadata) {
        ErrorDescriberExpertResult errorDescriberExpertResult = (ErrorDescriberExpertResult)this.processAgent(() -> this.errorDescriberExpertAgent.generate(context, errorMetadata), AiAgentType.ERROR_DESCRIBER_EXPERT, context);
        errorMetadata.setComment(errorDescriberExpertResult.getQuestion());
    }

    private ViewConfig generateViewConfig(List<BusinessEntity> reducedTopology, List<ViewField> filters, List<RuntimeFilterField> runtimeFilterFields, LiteViewConfig liteViewConfig, DatePickerConfig datePickerConfig, String viewName, String tzName) {
        ViewConfig viewConfig = new ViewConfig();
        viewConfig.setCollectionId(EntityId.NULL_UUID);
        viewConfig.setName(viewName);
        viewConfig.setViewType(liteViewConfig.getViewType());
        viewConfig.setFavorite(false);
        viewConfig.setXAxis(this.viewMapper.mapLiteViewFieldListToViewFieldList(liteViewConfig.getXAxis(), reducedTopology));
        viewConfig.setYAxis(this.viewMapper.mapLiteViewFieldListToViewFieldList(liteViewConfig.getYAxis(), reducedTopology));
        viewConfig.setSeries(this.viewMapper.mapLiteViewFieldListToViewFieldList(liteViewConfig.getSeries(), reducedTopology));
        ArrayList<ViewField> hiddenFields = new ArrayList<ViewField>();
        hiddenFields.addAll(this.viewMapper.mapLiteViewFieldListToViewFieldList(liteViewConfig.getHiddenFields(), reducedTopology));
        hiddenFields.addAll(filters);
        viewConfig.setHiddenFields(hiddenFields);
        viewConfig.setRuntimeFilters(runtimeFilterFields);
        HashMap<String, Object> settings = liteViewConfig.getSettings() == null ? new HashMap<String, Object>() : new HashMap(liteViewConfig.getSettings());
        settings.putIfAbsent("barHorizontal", BooleanNode.getFalse());
        settings.putIfAbsent("rawDataLoading", BooleanNode.getTrue());
        settings.putIfAbsent("titleSize", IntNode.valueOf((int)14));
        viewConfig.setSettings((JsonNode)new ObjectNode(JsonNodeFactory.instance, settings));
        viewConfig.setDatePickerConfig(datePickerConfig);
        if (liteViewConfig.getViewType() == ViewType.HEATMAP_CALENDAR) {
            ViewField rawDateViewField = new ViewField();
            rawDateViewField.setId(UUID.randomUUID());
            rawDateViewField.setVirtualDateField(true);
            rawDateViewField.setDateGrouping(DateAggregationType.RAW);
            viewConfig.setXAxis(List.of(rawDateViewField));
        }
        viewConfig.setCacheSettings(CacheSettings.getDefaultSettings());
        viewConfig.setTzName(tzName);
        this.populateDatePicker(viewConfig);
        return viewConfig;
    }

    private void populateDatePicker(ViewConfig viewConfig) {
        List<ViewField> dateFields = viewConfig.getAllFields().stream().filter(ViewField::isVirtualDateField).toList();
        int differentCount = dateFields.stream().map(ViewField::getDateGrouping).collect(Collectors.toSet()).size();
        if (differentCount != 1) {
            return;
        }
        DateAggregationType dateAggregationType = dateFields.get(0).getDateGrouping();
        if (Set.of(DateAggregationType.RAW, DateAggregationType.MINUTE, DateAggregationType.HOUR, DateAggregationType.DAY, DateAggregationType.WEEK_OF_YEAR, DateAggregationType.WEEK_OF_MONTH, DateAggregationType.MONTH).contains(dateAggregationType)) {
            return;
        }
        DatePickerConfig datePickerConfig = viewConfig.getDatePickerConfig();
        datePickerConfig.setRangeBy(DateAggregationType.getPickerFromGrouping((DateAggregationType)dateAggregationType));
        dateFields.forEach(viewField -> viewField.setDateGrouping(DateAggregationType.RAW));
    }
}

