/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.assistance.token;

import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import opennlp.tools.tokenize.SimpleTokenizer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.dao.assistance.TokenUsageDao;
import org.thingsboard.trendz.domain.assistance.agent.AgentMetadata;
import org.thingsboard.trendz.domain.assistance.model.LlmName;
import org.thingsboard.trendz.domain.assistance.model.TokenUsageRecord;
import org.thingsboard.trendz.domain.chat.ChatType;
import org.thingsboard.trendz.exception.assistance.TokenLimitException;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.assistance.llm.LlmService;
import org.thingsboard.trendz.service.assistance.token.TokenUsageService;
import org.thingsboard.trendz.service.assistance.token.TokenUsageServiceImpl;
import org.thingsboard.trendz.service.assistance.token.properties.ModelPricingProperties;
import org.thingsboard.trendz.service.assistance.token.properties.ModelPricingProperty;
import org.thingsboard.trendz.service.assistance.token.properties.TokenLimitsProperties;
import org.thingsboard.trendz.subscription.LicenceService;
import org.thingsboard.trendz.subscription.SubscriptionType;
import org.thingsboard.trendz.tools.DateTimeUtils;

@Service
public class TokenUsageServiceImpl
implements TokenUsageService {
    private final boolean isCloud;
    private final LicenceService licenceService;
    private final LlmService llmService;
    private final TokenUsageDao tokenUsageDao;
    private final TokenLimitsProperties tokenLimitsProperties;
    private final ModelPricingProperties modelPricingProperties;

    @Autowired
    public TokenUsageServiceImpl(@Value(value="${deployment.cloud}") boolean isCloud, LicenceService licenceService, LlmService llmService, TokenUsageDao tokenUsageDao, TokenLimitsProperties tokenLimitsProperties, ModelPricingProperties modelPricingProperties) {
        this.isCloud = isCloud;
        this.licenceService = licenceService;
        this.llmService = llmService;
        this.tokenUsageDao = tokenUsageDao;
        this.tokenLimitsProperties = tokenLimitsProperties;
        this.modelPricingProperties = modelPricingProperties;
    }

    public void use(AgentMetadata agentMetadata, JwtSecurityUser user) {
        if (agentMetadata.getInputTokenUsage() == 0 && agentMetadata.getOutputTokenUsage() == 0) {
            return;
        }
        boolean isSystemModel = this.llmService.agentUsesSystemLlmConfig(user, agentMetadata.getAiAgentType());
        long startOfCurrentMonthTs = DateTimeUtils.extendedTruncateTo((ZonedDateTime)ZonedDateTime.now(), (ChronoUnit)ChronoUnit.MONTHS).toEpochSecond();
        TokenUsageRecord tokenUsageRecord = TokenUsageRecord.builder().tenantId(user.getTenantId()).inputUsed((long)agentMetadata.getInputTokenUsage()).outputUsed((long)agentMetadata.getOutputTokenUsage()).modelName(agentMetadata.getModelName()).startOfMonthTs(startOfCurrentMonthTs).isSystemModel(isSystemModel).build();
        this.tokenUsageDao.save(tokenUsageRecord);
    }

    public void checkTokenUsage(JwtSecurityUser user, ChatType chatType) {
        if (!this.isCloud) {
            return;
        }
        boolean isSystemModel = this.llmService.agentUsesSystemLlmConfig(user, chatType);
        if (!isSystemModel) {
            return;
        }
        long startOfCurrentMonth = DateTimeUtils.extendedTruncateTo((ZonedDateTime)ZonedDateTime.now(), (ChronoUnit)ChronoUnit.MONTHS).toEpochSecond();
        double tenantMoneyUsage = this.tokenUsageDao.findAllTokenUsageForCurrentMonthForTenant(user.getTenantId(), startOfCurrentMonth, true).stream().mapToDouble(arg_0 -> this.mapTokenUsageRecordToMoneyUsage(arg_0)).sum();
        double totalMoneyUsage = this.tokenUsageDao.findTotalTokenUsageForCurrentMonth(startOfCurrentMonth, true).stream().mapToDouble(arg_0 -> this.mapTokenUsageRecordToMoneyUsage(arg_0)).sum();
        SubscriptionType subscriptionType = this.licenceService.getSubscriptionType(user);
        double limit = switch (1.$SwitchMap$org$thingsboard$trendz$subscription$SubscriptionType[subscriptionType.ordinal()]) {
            case 1 -> this.tokenLimitsProperties.getMaker();
            case 2 -> this.tokenLimitsProperties.getWeekly();
            case 3 -> this.tokenLimitsProperties.getStartup();
            case 4 -> this.tokenLimitsProperties.getPrototype();
            case 5 -> this.tokenLimitsProperties.getBusiness();
            case 6 -> this.tokenLimitsProperties.getBusinessPlus();
            case 7 -> this.tokenLimitsProperties.getEnterprise();
            default -> throw new TokenLimitException("Unsupported subscription type: " + String.valueOf(subscriptionType));
        };
        if (tenantMoneyUsage >= limit) {
            throw new TokenLimitException("You have reached the token limit for 'AI Assistant' under your current subscription level for this month.");
        }
        if (totalMoneyUsage >= this.tokenLimitsProperties.getTotal()) {
            throw new TokenLimitException("You have reached the total token limit for 'AI Assistant'");
        }
    }

    public int estimateTokenCount(String text) {
        return SimpleTokenizer.INSTANCE.tokenize(text).length;
    }

    private double mapTokenUsageRecordToMoneyUsage(TokenUsageRecord tokenUsageRecord) {
        LlmName llmName = LlmName.fromUnsafe((String)tokenUsageRecord.getModelName());
        ModelPricingProperty modelPricingProperty = this.getModelPricingProperty(llmName);
        return modelPricingProperty.getInput() * (double)tokenUsageRecord.getInputUsed() / 1000000.0 + modelPricingProperty.getOutput() * (double)tokenUsageRecord.getOutputUsed() / 1000000.0;
    }

    private ModelPricingProperty getModelPricingProperty(LlmName llmName) {
        if (llmName == null) {
            return new ModelPricingProperty(0.0, 0.0);
        }
        return switch (1.$SwitchMap$org$thingsboard$trendz$domain$assistance$model$LlmName[llmName.ordinal()]) {
            default -> throw new IncompatibleClassChangeError();
            case 1 -> null;
            case 2 -> this.modelPricingProperties.getOpenAi().getGpt4o();
            case 3 -> this.modelPricingProperties.getOpenAi().getGpt4oMini();
            case 4 -> this.modelPricingProperties.getOpenAi().getO3Mini();
            case 5 -> this.modelPricingProperties.getOpenAi().getO4Mini();
            case 6 -> this.modelPricingProperties.getGoogle().getGemini_1_5_flash();
            case 7 -> this.modelPricingProperties.getGoogle().getGemini_1_5_pro();
            case 8 -> this.modelPricingProperties.getGoogle().getGemini_2_0_flash();
            case 9 -> this.modelPricingProperties.getGoogle().getGemini_2_5_flash();
            case 10 -> this.modelPricingProperties.getGoogle().getGemini_2_0_flash_lite();
            case 11 -> this.modelPricingProperties.getAmazonBedrock().getMeta_llama3_1_70b_instruct();
            case 12 -> this.modelPricingProperties.getAmazonBedrock().getMeta_llama3_2_90b_instruct();
            case 13 -> this.modelPricingProperties.getAmazonBedrock().getMeta_llama3_3_70b_instruct();
            case 14 -> this.modelPricingProperties.getAmazonBedrock().getAnthropic_claude_3_5_haiku();
            case 15 -> this.modelPricingProperties.getAmazonBedrock().getAnthropic_claude_3_5_sonnet();
            case 16 -> this.modelPricingProperties.getAmazonBedrock().getAnthropic_claude_3_7_sonnet();
            case 17 -> this.modelPricingProperties.getAmazonBedrock().getAmazonNovaLite();
            case 18 -> this.modelPricingProperties.getAmazonBedrock().getAmazonNovaPro();
            case 19 -> this.modelPricingProperties.getAmazonBedrock().getMistralLarge();
        };
    }
}

