/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.assistance.llm;

import dev.langchain4j.model.bedrock.BedrockChatModel;
import dev.langchain4j.model.chat.ChatModel;
import dev.langchain4j.model.chat.listener.ChatModelListener;
import dev.langchain4j.model.chat.request.ChatRequestParameters;
import dev.langchain4j.model.googleai.GeminiThinkingConfig;
import dev.langchain4j.model.googleai.GoogleAiGeminiChatModel;
import dev.langchain4j.model.openai.OpenAiChatModel;
import jakarta.transaction.Transactional;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.config.DefaultLlmModelConfiguration;
import org.thingsboard.trendz.dao.assistance.model.LlmConfigDao;
import org.thingsboard.trendz.dao.assistance.model.LlmSettingsDao;
import org.thingsboard.trendz.domain.assistance.agent.AiAgentType;
import org.thingsboard.trendz.domain.assistance.model.LlmConfig;
import org.thingsboard.trendz.domain.assistance.model.LlmConfigLite;
import org.thingsboard.trendz.domain.assistance.model.LlmName;
import org.thingsboard.trendz.domain.assistance.model.LlmProvider;
import org.thingsboard.trendz.domain.assistance.model.LlmSettings;
import org.thingsboard.trendz.domain.assistance.model.properties.AmazonBedrockLlmProviderProperties;
import org.thingsboard.trendz.domain.assistance.model.properties.CustomLlmProviderProperties;
import org.thingsboard.trendz.domain.assistance.model.properties.GoogleLlmProviderProperties;
import org.thingsboard.trendz.domain.assistance.model.properties.LlmProviderProperties;
import org.thingsboard.trendz.domain.assistance.model.properties.OpenAiLlmProviderProperties;
import org.thingsboard.trendz.domain.chat.ChatType;
import org.thingsboard.trendz.exception.assistance.IncorrectLlmConfiguration;
import org.thingsboard.trendz.exception.assistance.LlmConfigNotFoundException;
import org.thingsboard.trendz.exception.assistance.llm.LlmConfigNullIdException;
import org.thingsboard.trendz.exception.assistance.llm.NoLlmConfigsConfiguredException;
import org.thingsboard.trendz.exception.assistance.llm.SystemLlmConfigException;
import org.thingsboard.trendz.exception.chat.ChatException;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.assistance.llm.LlmService;
import org.thingsboard.trendz.service.assistance.token.properties.ApiProperties;
import org.thingsboard.trendz.tools.PaginationPage;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.bedrockruntime.BedrockRuntimeClient;
import software.amazon.awssdk.services.bedrockruntime.BedrockRuntimeClientBuilder;

@Service
@Transactional
public class LlmService {
    private static final Logger log = LoggerFactory.getLogger(LlmService.class);
    private final ChatModelListener chatModelListener;
    private final LlmConfigDao llmConfigDao;
    private final LlmSettingsDao llmSettingsDao;
    private final boolean systemLlmEnabled;
    private final UUID defaultModelId;
    private final Set<LlmConfig> systemLlmConfigs;
    private Consumer<JwtSecurityUser> evictFn;

    @Autowired
    public LlmService(Optional<DefaultLlmModelConfiguration> defaultLlmModelConfiguration, ApiProperties apiProperties, ChatModelListener chatModelListener, LlmConfigDao llmConfigDao, LlmSettingsDao llmSettingsDao) {
        this.chatModelListener = chatModelListener;
        this.llmConfigDao = llmConfigDao;
        this.llmSettingsDao = llmSettingsDao;
        if (defaultLlmModelConfiguration.isPresent()) {
            this.systemLlmEnabled = true;
            this.defaultModelId = defaultLlmModelConfiguration.get().getDefaultModelId();
            this.systemLlmConfigs = defaultLlmModelConfiguration.get().getLlmConfigs();
            for (LlmConfig config : defaultLlmModelConfiguration.get().getLlmConfigs()) {
                LlmProviderProperties llmProviderProperties = LlmProviderProperties.getProperties((ApiProperties)apiProperties, (LlmProvider)config.getLlmProvider());
                config.setLlmProviderProperties(llmProviderProperties);
                this.testLlmConfig(config);
                LlmConfig llmConfig = this.llmConfigDao.save(config);
            }
        } else {
            this.systemLlmEnabled = false;
            this.defaultModelId = null;
            this.systemLlmConfigs = Collections.emptySet();
        }
    }

    public PaginationPage<LlmConfigLite> findAll(JwtSecurityUser user, int page, int pageSize) {
        return this.llmConfigDao.findAllLiteByUser(user, page, pageSize);
    }

    public Optional<LlmConfig> findById(JwtSecurityUser user, UUID id) {
        if (id == null) {
            throw new LlmConfigNullIdException();
        }
        return this.llmConfigDao.findByUserAndId(user, id).map(llmConfig -> {
            if (llmConfig.isDefault()) {
                llmConfig.setLlmProviderProperties(null);
            }
            return llmConfig;
        });
    }

    public Set<LlmConfig> findByIdSet(JwtSecurityUser user, Set<UUID> idSet) {
        if (idSet == null) {
            throw new LlmConfigNullIdException();
        }
        if (idSet.isEmpty()) {
            return Collections.emptySet();
        }
        return this.llmConfigDao.findByUserAndIdSet(user, idSet);
    }

    public LlmConfig save(JwtSecurityUser user, LlmConfig llmConfig) {
        Set systemIds = this.systemLlmConfigs.stream().map(LlmConfig::getId).collect(Collectors.toSet());
        if (systemIds.contains(llmConfig.getId())) {
            throw new SystemLlmConfigException("System Llm config can not be changed");
        }
        long now = System.currentTimeMillis();
        UUID id = llmConfig.getId();
        if (id == null) {
            llmConfig.setId(UUID.randomUUID());
            llmConfig.setCreatedTs(now);
        } else {
            LlmConfig stored = (LlmConfig)this.llmConfigDao.findByUserAndId(user, id).orElseThrow(() -> new LlmConfigNotFoundException(id));
            llmConfig.setCreatedTs(stored.getCreatedTs());
        }
        llmConfig.setTenantId(user.getTenantId());
        llmConfig.setUpdatedTs(now);
        this.testLlmConfig(llmConfig);
        LlmConfig saved = this.llmConfigDao.save(llmConfig);
        if (this.evictFn != null) {
            this.evictFn.accept(user);
        }
        return saved;
    }

    public void delete(JwtSecurityUser user, UUID id) {
        LlmConfig stored = (LlmConfig)this.findById(user, id).orElseThrow(() -> new LlmConfigNotFoundException(id));
        if (stored.isDefault()) {
            throw new SystemLlmConfigException("Can not delete system LLM config");
        }
        LlmSettings llmSettings = this.findLlmSettings(user);
        if (id.equals(llmSettings.getDefaultLlmConfigId())) {
            llmSettings.setUseDefault(false);
        }
        this.saveLlmSettings(user, llmSettings);
        this.llmConfigDao.delete(id);
        if (this.evictFn != null) {
            this.evictFn.accept(user);
        }
    }

    public LlmSettings findLlmSettings(JwtSecurityUser user) {
        UUID tenantId = user.getTenantId();
        return this.llmSettingsDao.findByTenantId(tenantId).orElse(LlmSettings.getDefault((UUID)tenantId, (UUID)this.defaultModelId));
    }

    public LlmSettings saveLlmSettings(JwtSecurityUser user, LlmSettings llmSettings) {
        UUID defaultLlmConfigId = llmSettings.getDefaultLlmConfigId();
        Map chatTypeToLlmConfigMap = llmSettings.getChatTypeToLlmConfigMap();
        if (Objects.nonNull(defaultLlmConfigId)) {
            LlmConfig llmConfig = (LlmConfig)this.findById(user, defaultLlmConfigId).orElseThrow(() -> new LlmConfigNotFoundException(defaultLlmConfigId));
        }
        if (Objects.isNull(chatTypeToLlmConfigMap)) {
            throw new LlmConfigNullIdException();
        }
        for (Map.Entry entry : chatTypeToLlmConfigMap.entrySet()) {
            ChatType type = (ChatType)entry.getKey();
            UUID configId = (UUID)entry.getValue();
            if (Objects.isNull(type) || Objects.isNull(configId)) {
                throw new IllegalArgumentException("Agent type and LLM config id must not be null");
            }
            LlmConfig llmConfig = (LlmConfig)this.findById(user, configId).orElseThrow(() -> new LlmConfigNotFoundException(configId));
        }
        LlmSettings old = this.findLlmSettings(user);
        llmSettings.setId(old.getId());
        llmSettings.setTenantId(user.getTenantId());
        LlmSettings llmSettings2 = this.llmSettingsDao.save(llmSettings);
        if (this.evictFn != null) {
            this.evictFn.accept(user);
        }
        return llmSettings2;
    }

    public boolean agentUsesSystemLlmConfig(JwtSecurityUser user, AiAgentType aiAgentType) {
        return this.agentUsesSystemLlmConfig(user, aiAgentType.getChatType());
    }

    public boolean agentUsesSystemLlmConfig(JwtSecurityUser user, ChatType type) {
        if (this.systemLlmEnabled) {
            UUID configId;
            LlmSettings llmSettings = this.findLlmSettings(user);
            if (llmSettings.isUseDefault()) {
                configId = llmSettings.getDefaultLlmConfigId();
            } else {
                Map chatTypeMap = llmSettings.getChatTypeToLlmConfigMap();
                configId = (UUID)chatTypeMap.get(type);
            }
            if (configId == null) {
                throw new NoLlmConfigsConfiguredException();
            }
            LlmConfig config = (LlmConfig)this.findById(user, configId).orElseThrow(() -> new LlmConfigNotFoundException(configId));
            return config.isDefault();
        }
        return false;
    }

    public ChatModel createChatModelByConfig(LlmConfig llmConfig) {
        return switch (1.$SwitchMap$org$thingsboard$trendz$domain$assistance$model$LlmProvider[llmConfig.getLlmProvider().ordinal()]) {
            default -> throw new IncompatibleClassChangeError();
            case 1 -> {
                CustomLlmProviderProperties customLlmProperties = (CustomLlmProviderProperties)llmConfig.getLlmProviderProperties();
                yield OpenAiChatModel.builder().baseUrl(customLlmProperties.getBaseUrl()).apiKey(customLlmProperties.getApiKey()).modelName(customLlmProperties.getModelName()).listeners(List.of(this.chatModelListener)).build();
            }
            case 2 -> {
                OpenAiLlmProviderProperties openAiLlmProperties = (OpenAiLlmProviderProperties)llmConfig.getLlmProviderProperties();
                OpenAiChatModel.OpenAiChatModelBuilder builder = llmConfig.getLlmName() == LlmName.O3_MINI || llmConfig.getLlmName() == LlmName.O4_MINI ? OpenAiChatModel.builder() : OpenAiChatModel.builder().temperature(Double.valueOf(llmConfig.getTemperature())).topP(Double.valueOf(llmConfig.getTopP()));
                yield builder.apiKey(openAiLlmProperties.getApiKey()).modelName(llmConfig.getLlmName().getModelName()).listeners(List.of(this.chatModelListener)).build();
            }
            case 3 -> {
                GoogleLlmProviderProperties googleLlmProperties = (GoogleLlmProviderProperties)llmConfig.getLlmProviderProperties();
                GoogleAiGeminiChatModel.GoogleAiGeminiChatModelBuilder builder = GoogleAiGeminiChatModel.builder();
                if (llmConfig.getLlmName() == LlmName.GEMINI_2_5_FLASH) {
                    builder.thinkingConfig(GeminiThinkingConfig.builder().includeThoughts(Boolean.valueOf(false)).thinkingBudget(Integer.valueOf(0)).build());
                }
                yield builder.apiKey(googleLlmProperties.getApiKey()).modelName(llmConfig.getLlmName().getModelName()).temperature(Double.valueOf(llmConfig.getTemperature())).topP(Double.valueOf(llmConfig.getTopP())).listeners(List.of(this.chatModelListener)).build();
            }
            case 4 -> {
                AmazonBedrockLlmProviderProperties amazonBedrockLlmProperties = (AmazonBedrockLlmProviderProperties)llmConfig.getLlmProviderProperties();
                BedrockRuntimeClient bedrockRuntimeClient = (BedrockRuntimeClient)((BedrockRuntimeClientBuilder)((BedrockRuntimeClientBuilder)((BedrockRuntimeClientBuilder)BedrockRuntimeClient.builder().region(Region.of((String)amazonBedrockLlmProperties.getRegion()))).credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)AwsBasicCredentials.create((String)amazonBedrockLlmProperties.getAccessKey(), (String)amazonBedrockLlmProperties.getSecretKey())))).overrideConfiguration(config -> config.apiCallTimeout(Duration.ofMinutes(1L)))).build();
                yield ((BedrockChatModel.Builder)((BedrockChatModel.Builder)((BedrockChatModel.Builder)BedrockChatModel.builder().client(bedrockRuntimeClient).modelId(llmConfig.getLlmName().getModelName())).maxRetries(Integer.valueOf(1)).timeout(Duration.of(5L, ChronoUnit.MINUTES))).defaultRequestParameters(ChatRequestParameters.builder().temperature(Double.valueOf(llmConfig.getTemperature())).topP(Double.valueOf(llmConfig.getTopP())).build())).build();
            }
        };
    }

    public void testLlmConfig(LlmConfig llmConfig) {
        try {
            ChatModel chatModel = this.createChatModelByConfig(llmConfig);
            chatModel.chat("Reply as: \"Model has been connected\"");
        }
        catch (RuntimeException e) {
            throw new IncorrectLlmConfiguration(e);
        }
    }

    public void insertEvictFunction(Consumer<JwtSecurityUser> evictFn) {
        this.evictFn = evictFn;
    }

    public void validateChatTypeForUser(JwtSecurityUser user, ChatType chatType) {
        LlmSettings llmSettings = this.findLlmSettings(user);
        if (!llmSettings.getChatTypeToLlmConfigMap().containsKey(chatType) && !llmSettings.isUseDefault()) {
            throw new ChatException("AI model was not selected for the next feature: " + chatType.name() + ". Please contact your service provider to enable this feature.");
        }
    }
}

