/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.assistance.agent.view;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.domain.assistance.agent.AiAgentType;
import org.thingsboard.trendz.domain.assistance.agent.lite.LiteDataField;
import org.thingsboard.trendz.domain.assistance.agent.lite.LiteDateGroupingItem;
import org.thingsboard.trendz.domain.assistance.agent.lite.LiteViewConfig;
import org.thingsboard.trendz.domain.assistance.agent.lite.viewconfig.LiteTableViewConfig;
import org.thingsboard.trendz.domain.definition.view.config.ViewType;
import org.thingsboard.trendz.service.assistance.agent.AgentService;
import org.thingsboard.trendz.service.assistance.agent.view.ViewExpertAgent;
import org.thingsboard.trendz.service.assistance.agent.view.domain.ViewExpertRequest;
import org.thingsboard.trendz.service.assistance.agent.view.domain.ViewExpertResult;
import org.thingsboard.trendz.service.assistance.domain.ViewAssistanceContext;

@Service
public class TableViewExpertAgent
implements ViewExpertAgent {
    private final AgentService agentService;

    @Autowired
    public TableViewExpertAgent(AgentService agentService) {
        this.agentService = agentService;
    }

    public AiAgentType getAgentType() {
        return AiAgentType.TABLE_VIEW_EXPERT;
    }

    public ViewExpertResult generateView(ViewAssistanceContext context, Set<LiteDataField> dataFields, Set<LiteDateGroupingItem> dateGroupingItems) {
        ViewExpertRequest viewExpertRequest = ViewExpertRequest.builder().userQuestion(context.getQuestion()).myPreviousResponseWas(this.agentService.preparePreviousAnswerInfo(context, this.getAgentType())).liteDataFields(dataFields).dateGroupingItems(dateGroupingItems).build();
        LiteTableViewConfig liteTableViewConfig = (LiteTableViewConfig)this.agentService.processAiRequest(context.getUser(), context.getAgentMetadataContainer(), (Object)viewExpertRequest, this.getAgentType());
        LiteViewConfig liteViewConfig = this.mapLiteSimpleTableViewConfigToLiteViewConfig(liteTableViewConfig);
        return ((ViewExpertResult.ViewExpertResultBuilder)((ViewExpertResult.ViewExpertResultBuilder)ViewExpertResult.builder().liteViewConfig(liteViewConfig).comment(liteTableViewConfig.get_comment())).status(liteTableViewConfig.get_status())).build();
    }

    private LiteViewConfig mapLiteSimpleTableViewConfigToLiteViewConfig(LiteTableViewConfig liteTableViewConfig) {
        if (liteTableViewConfig.getDynamicValue() != null && liteTableViewConfig.getDynamicColumn() != null) {
            return LiteViewConfig.builder().xAxis(liteTableViewConfig.getColumns()).yAxis(List.of(liteTableViewConfig.getDynamicValue())).series(List.of(liteTableViewConfig.getDynamicColumn())).viewType(ViewType.TABLE).build();
        }
        return LiteViewConfig.builder().xAxis(liteTableViewConfig.getColumns()).yAxis(Collections.emptyList()).series(Collections.emptyList()).viewType(ViewType.TABLE).build();
    }
}

