/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.assistance.agent.view;

import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.domain.assistance.agent.AiAgentType;
import org.thingsboard.trendz.domain.assistance.agent.lite.LiteDataField;
import org.thingsboard.trendz.domain.assistance.agent.lite.LiteDateGroupingItem;
import org.thingsboard.trendz.domain.assistance.agent.lite.LiteViewConfig;
import org.thingsboard.trendz.domain.assistance.agent.lite.LiteViewField;
import org.thingsboard.trendz.domain.assistance.agent.lite.LiteViewFieldType;
import org.thingsboard.trendz.domain.assistance.agent.lite.viewconfig.LiteScatterPlotViewConfig;
import org.thingsboard.trendz.domain.definition.view.config.ViewType;
import org.thingsboard.trendz.service.assistance.agent.AgentService;
import org.thingsboard.trendz.service.assistance.agent.view.ViewExpertAgent;
import org.thingsboard.trendz.service.assistance.agent.view.domain.ViewExpertRequest;
import org.thingsboard.trendz.service.assistance.agent.view.domain.ViewExpertResult;
import org.thingsboard.trendz.service.assistance.domain.ViewAssistanceContext;

@Service
public class ScatterPlotViewExpertAgent
implements ViewExpertAgent {
    private final AgentService agentService;

    @Autowired
    public ScatterPlotViewExpertAgent(AgentService agentService) {
        this.agentService = agentService;
    }

    public AiAgentType getAgentType() {
        return AiAgentType.SCATTER_PLOT_VIEW_EXPERT;
    }

    public ViewExpertResult generateView(ViewAssistanceContext context, Set<LiteDataField> dataFields, Set<LiteDateGroupingItem> dateGroupingItems) {
        ViewExpertRequest viewExpertRequest = ViewExpertRequest.builder().userQuestion(context.getQuestion()).myPreviousResponseWas(this.agentService.preparePreviousAnswerInfo(context, this.getAgentType())).liteDataFields(dataFields).dateGroupingItems(dateGroupingItems).build();
        LiteScatterPlotViewConfig config = (LiteScatterPlotViewConfig)this.agentService.processAiRequest(context.getUser(), context.getAgentMetadataContainer(), (Object)viewExpertRequest, AiAgentType.SCATTER_PLOT_VIEW_EXPERT);
        LiteViewConfig liteViewConfig = this.makeConfig(config);
        return ((ViewExpertResult.ViewExpertResultBuilder)((ViewExpertResult.ViewExpertResultBuilder)ViewExpertResult.builder().liteViewConfig(liteViewConfig).comment(config.get_comment())).status(config.get_status())).build();
    }

    private LiteViewConfig makeConfig(LiteScatterPlotViewConfig config) {
        return LiteViewConfig.builder().xAxis(List.of(config.getXValue())).yAxis(List.of(config.getYValue())).series(config.getGroupings()).hiddenFields(List.of(LiteViewField.builder()._type(LiteViewFieldType.DATE_TIME).groupingItem(config.getGroupingItem()).build())).viewType(ViewType.SCATTER_PLOT).build();
    }
}

