/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.assistance.agent.view;

import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.domain.assistance.agent.AiAgentType;
import org.thingsboard.trendz.domain.assistance.agent.lite.LiteDataField;
import org.thingsboard.trendz.domain.assistance.agent.lite.LiteDateGroupingItem;
import org.thingsboard.trendz.domain.assistance.agent.lite.LiteViewConfig;
import org.thingsboard.trendz.domain.assistance.agent.lite.LiteViewFieldType;
import org.thingsboard.trendz.domain.assistance.agent.lite.viewconfig.LiteLineChartViewConfig;
import org.thingsboard.trendz.domain.definition.view.config.ViewType;
import org.thingsboard.trendz.service.assistance.agent.AgentService;
import org.thingsboard.trendz.service.assistance.agent.view.ViewExpertAgent;
import org.thingsboard.trendz.service.assistance.agent.view.domain.ViewExpertRequest;
import org.thingsboard.trendz.service.assistance.agent.view.domain.ViewExpertResult;
import org.thingsboard.trendz.service.assistance.domain.ViewAssistanceContext;

@Service
public class LineChartViewExpertAgent
implements ViewExpertAgent {
    private static final Logger log = LoggerFactory.getLogger(LineChartViewExpertAgent.class);
    private final AgentService agentService;

    @Autowired
    public LineChartViewExpertAgent(AgentService agentService) {
        this.agentService = agentService;
    }

    public AiAgentType getAgentType() {
        return AiAgentType.LINE_CHART_VIEW_EXPERT;
    }

    public ViewExpertResult generateView(ViewAssistanceContext context, Set<LiteDataField> dataFields, Set<LiteDateGroupingItem> dateGroupingItems) {
        ViewExpertRequest viewExpertRequest = ViewExpertRequest.builder().userQuestion(context.getQuestion()).myPreviousResponseWas(this.agentService.preparePreviousAnswerInfo(context, this.getAgentType())).liteDataFields(dataFields).dateGroupingItems(dateGroupingItems).build();
        LiteLineChartViewConfig liteLineChartViewConfig = (LiteLineChartViewConfig)this.agentService.processAiRequest(context.getUser(), context.getAgentMetadataContainer(), (Object)viewExpertRequest, AiAgentType.LINE_CHART_VIEW_EXPERT);
        LiteViewConfig liteViewConfig = this.mapLiteLineChartViewConfigToLiteViewConfig(liteLineChartViewConfig);
        return ((ViewExpertResult.ViewExpertResultBuilder)((ViewExpertResult.ViewExpertResultBuilder)ViewExpertResult.builder().liteViewConfig(liteViewConfig).comment(liteLineChartViewConfig.get_comment())).status(liteLineChartViewConfig.get_status())).build();
    }

    private LiteViewConfig mapLiteLineChartViewConfigToLiteViewConfig(LiteLineChartViewConfig liteLineChartViewConfig) {
        if (liteLineChartViewConfig.getX().get_type() != LiteViewFieldType.DATE_TIME) {
            throw new RuntimeException("");
        }
        return LiteViewConfig.builder().xAxis(List.of(liteLineChartViewConfig.getX())).yAxis(liteLineChartViewConfig.getYAxis()).series(liteLineChartViewConfig.getGroupBy()).viewType(ViewType.LINE).build();
    }
}

