/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.assistance.agent.view;

import com.fasterxml.jackson.databind.node.BooleanNode;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.domain.assistance.agent.AiAgentType;
import org.thingsboard.trendz.domain.assistance.agent.lite.LiteDataField;
import org.thingsboard.trendz.domain.assistance.agent.lite.LiteDateGroupingItem;
import org.thingsboard.trendz.domain.assistance.agent.lite.LiteViewConfig;
import org.thingsboard.trendz.domain.assistance.agent.lite.viewconfig.LiteBarChartViewConfig;
import org.thingsboard.trendz.domain.definition.view.config.ViewType;
import org.thingsboard.trendz.service.assistance.agent.AgentService;
import org.thingsboard.trendz.service.assistance.agent.view.ViewExpertAgent;
import org.thingsboard.trendz.service.assistance.agent.view.domain.ViewExpertRequest;
import org.thingsboard.trendz.service.assistance.agent.view.domain.ViewExpertResult;
import org.thingsboard.trendz.service.assistance.domain.ViewAssistanceContext;

@Service
public class BarChartViewExpertAgent
implements ViewExpertAgent {
    private static final Logger log = LoggerFactory.getLogger(BarChartViewExpertAgent.class);
    private final AgentService agentService;

    @Autowired
    public BarChartViewExpertAgent(AgentService agentService) {
        this.agentService = agentService;
    }

    public AiAgentType getAgentType() {
        return AiAgentType.BAR_CHART_VIEW_EXPERT;
    }

    public ViewExpertResult generateView(ViewAssistanceContext context, Set<LiteDataField> dataFields, Set<LiteDateGroupingItem> dateGroupingItems) {
        ViewExpertRequest viewExpertRequest = ViewExpertRequest.builder().userQuestion(context.getQuestion()).myPreviousResponseWas(this.agentService.preparePreviousAnswerInfo(context, this.getAgentType())).liteDataFields(dataFields).dateGroupingItems(dateGroupingItems).build();
        LiteBarChartViewConfig liteBarChartViewConfig = (LiteBarChartViewConfig)this.agentService.processAiRequest(context.getUser(), context.getAgentMetadataContainer(), (Object)viewExpertRequest, AiAgentType.BAR_CHART_VIEW_EXPERT);
        Map<String, BooleanNode> settings = Map.of("barHorizontal", BooleanNode.valueOf((boolean)liteBarChartViewConfig.isHorizontalBarChart()), "barStacked", BooleanNode.valueOf((boolean)liteBarChartViewConfig.isStackedBarChart()));
        LiteViewConfig liteViewConfig = LiteViewConfig.builder().xAxis(liteBarChartViewConfig.getXAxis()).yAxis(liteBarChartViewConfig.getYAxis()).series(liteBarChartViewConfig.getGroupBy()).settings(settings).viewType(ViewType.BAR).build();
        return ((ViewExpertResult.ViewExpertResultBuilder)((ViewExpertResult.ViewExpertResultBuilder)ViewExpertResult.builder().liteViewConfig(liteViewConfig).comment(liteBarChartViewConfig.get_comment())).status(liteBarChartViewConfig.get_status())).build();
    }
}

