/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.assistance.agent.topicrouter;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.domain.assistance.agent.AgentResponseStatus;
import org.thingsboard.trendz.domain.assistance.agent.AiAgentType;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.assistance.agent.AgentService;
import org.thingsboard.trendz.service.assistance.agent.topicrouter.TopicRouterExpertAgent;
import org.thingsboard.trendz.service.assistance.agent.topicrouter.TopicRouterExpertAgentImpl;
import org.thingsboard.trendz.service.assistance.agent.topicrouter.domain.TopicRouterExpertRequest;
import org.thingsboard.trendz.service.assistance.agent.topicrouter.domain.TopicRouterExpertResponse;
import org.thingsboard.trendz.service.assistance.agent.topicrouter.domain.TopicRouterExpertResult;
import org.thingsboard.trendz.service.assistance.domain.ViewAssistanceContext;
import org.thingsboard.trendz.service.customize.CustomizationService;

@Service
public class TopicRouterExpertAgentImpl
implements TopicRouterExpertAgent {
    private final AgentService agentService;
    private final CustomizationService customizationService;

    @Autowired
    public TopicRouterExpertAgentImpl(AgentService agentService, CustomizationService customizationService) {
        this.agentService = agentService;
        this.customizationService = customizationService;
    }

    public TopicRouterExpertResult defineCategory(ViewAssistanceContext context) {
        TopicRouterExpertRequest topicRouterExpertRequest = new TopicRouterExpertRequest(context.getQuestion());
        TopicRouterExpertResponse topicRouterExpertResponse = (TopicRouterExpertResponse)this.agentService.processAiRequest(context.getUser(), context.getAgentMetadataContainer(), (Object)topicRouterExpertRequest, AiAgentType.TOPIC_ROUTER_EXPERT);
        AgentResponseStatus status = switch (1.$SwitchMap$org$thingsboard$trendz$domain$assistance$agent$AssistantRequestCategory[topicRouterExpertResponse.getMainCategory().ordinal()]) {
            default -> throw new IncompatibleClassChangeError();
            case 1, 2 -> AgentResponseStatus.SUCCESS;
            case 3, 4, 5, 6 -> AgentResponseStatus.ERROR;
        };
        String comment = this.extractComment(topicRouterExpertResponse, context.getUser(), context.getDomain());
        return ((TopicRouterExpertResult.TopicRouterExpertResultBuilder)((TopicRouterExpertResult.TopicRouterExpertResultBuilder)TopicRouterExpertResult.builder().mainCategory(topicRouterExpertResponse.getMainCategory()).comment(comment)).status(status)).build();
    }

    private String extractComment(TopicRouterExpertResponse topicRouterExpertResponse, JwtSecurityUser jwtSecurityUser, String domain) {
        String topicComment = switch (1.$SwitchMap$org$thingsboard$trendz$domain$assistance$agent$AssistantRequestCategory[topicRouterExpertResponse.getMainCategory().ordinal()]) {
            default -> throw new IncompatibleClassChangeError();
            case 1 -> "I can do it.";
            case 3 -> "I cannot build calculation fields in the current release.";
            case 4 -> "I cannot build predictions in the current release.";
            case 5 -> "I cannot build anomalies in the current release.";
            case 6 -> {
                boolean isEnabledHelpUserMode = this.customizationService.getCustomViewSettings(domain, jwtSecurityUser).isHelpModeEnabled();
                String helpMessage = isEnabledHelpUserMode ? "please contact our development team throw email 'ikheroim@thingsboard.io'" : "please contact admin of your platform";
                yield "I cannot answer on support questions in the current release, " + helpMessage;
            }
            case 2 -> "I can do it";
        };
        return "%s\n%s".formatted(topicRouterExpertResponse.get_comment(), topicComment);
    }
}

