/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.assistance.agent.queryanalyzer.impl;

import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.domain.assistance.agent.AgentResponseStatus;
import org.thingsboard.trendz.domain.assistance.agent.AiAgentType;
import org.thingsboard.trendz.domain.definition.view.FieldAggregation;
import org.thingsboard.trendz.service.assistance.agent.AgentService;
import org.thingsboard.trendz.service.assistance.agent.queryanalyzer.QueryAnalyzerExpertAgentBase;
import org.thingsboard.trendz.service.assistance.agent.queryanalyzer.domain.QueryAnalyzerExpertResult;
import org.thingsboard.trendz.service.assistance.domain.ViewAssistanceContext;
import org.thingsboard.trendz.service.assistance.domain.ViewAssistanceState;

@Service
@Qualifier(value="FILTER_QUERY_ANALYZER_EXPERT_AGENT")
public class FilterQueryAnalyzerExpertAgentImpl
extends QueryAnalyzerExpertAgentBase {
    @Autowired
    public FilterQueryAnalyzerExpertAgentImpl(AgentService agentService) {
        super(agentService);
    }

    public QueryAnalyzerExpertResult analyze(ViewAssistanceContext context) {
        ViewAssistanceState state = context.getViewAssistanceState();
        if (state.getFilterQueryAnalyzer() == null) {
            state.setFilterQueryAnalyzer(this.process(context));
        }
        return state.getFilterQueryAnalyzer();
    }

    private QueryAnalyzerExpertResult process(ViewAssistanceContext context) {
        QueryAnalyzerExpertResult queryAnalyzerExpertResult = super.analyze(context);
        Set forbiddenFilters = queryAnalyzerExpertResult.getFields().stream().filter(dataField -> !Set.of(FieldAggregation.UNIQ, FieldAggregation.NONE).contains(dataField.getAggregation())).map(dataField -> "%s/%s (%s)".formatted(dataField.getX_businessEntityName(), dataField.getField().getName(), dataField.getAggregation())).collect(Collectors.toSet());
        if (forbiddenFilters.isEmpty()) {
            return queryAnalyzerExpertResult;
        }
        return ((QueryAnalyzerExpertResult.QueryAnalyzerExpertResultBuilder)((QueryAnalyzerExpertResult.QueryAnalyzerExpertResultBuilder)QueryAnalyzerExpertResult.builder().comment("Aggregation in filters are forbidden. Aggregation was found for: " + String.valueOf(forbiddenFilters))).status(AgentResponseStatus.ERROR)).build();
    }

    public AiAgentType getAgentType() {
        return AiAgentType.FILTER_QUERY_ANALYZER_EXPERT;
    }
}

