/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.assistance.agent.errordescriber;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.domain.assistance.ErrorMetadata;
import org.thingsboard.trendz.domain.assistance.agent.AgentResponseStatus;
import org.thingsboard.trendz.domain.assistance.agent.AiAgentType;
import org.thingsboard.trendz.service.assistance.agent.AgentService;
import org.thingsboard.trendz.service.assistance.agent.errordescriber.ErrorDescriberExpertAgent;
import org.thingsboard.trendz.service.assistance.agent.errordescriber.domain.ErrorDescriberExpertRequest;
import org.thingsboard.trendz.service.assistance.agent.errordescriber.domain.ErrorDescriberExpertResponse;
import org.thingsboard.trendz.service.assistance.agent.errordescriber.domain.ErrorDescriberExpertResult;
import org.thingsboard.trendz.service.assistance.domain.ViewAssistanceContext;

@Service
public class ErrorDescriberExpertAgentImpl
implements ErrorDescriberExpertAgent {
    private final AgentService agentService;

    @Autowired
    public ErrorDescriberExpertAgentImpl(AgentService agentService) {
        this.agentService = agentService;
    }

    public ErrorDescriberExpertResult generate(ViewAssistanceContext context, ErrorMetadata errorMetadata) {
        ErrorDescriberExpertRequest errorDescriberExpertRequest = ErrorDescriberExpertRequest.builder().errorMetadata(errorMetadata).userQuestion(context.getQuestion()).build();
        ErrorDescriberExpertResponse errorDescriberExpertResponse = (ErrorDescriberExpertResponse)this.agentService.processAiRequest(context.getUser(), context.getAgentMetadataContainer(), (Object)errorDescriberExpertRequest, AiAgentType.ERROR_DESCRIBER_EXPERT);
        return ((ErrorDescriberExpertResult.ErrorDescriberExpertResultBuilder)((ErrorDescriberExpertResult.ErrorDescriberExpertResultBuilder)ErrorDescriberExpertResult.builder().question(errorDescriberExpertResponse.getQuestionToUser()).status(AgentResponseStatus.SUCCESS)).comment(errorDescriberExpertResponse.get_comment())).build();
    }
}

