/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.assistance.agent.datepicker;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.domain.assistance.agent.AiAgentType;
import org.thingsboard.trendz.domain.assistance.agent.lite.LiteDatePickerConfig;
import org.thingsboard.trendz.domain.assistance.agent.lite.LiteDatePickerConfigType;
import org.thingsboard.trendz.domain.assistance.agent.lite.LiteRelativeUnit;
import org.thingsboard.trendz.domain.assistance.agent.lite.LiteRelativityType;
import org.thingsboard.trendz.domain.definition.view.config.DatePickerConfig;
import org.thingsboard.trendz.domain.definition.view.config.DatePickerConfigSelectType;
import org.thingsboard.trendz.service.assistance.agent.AgentService;
import org.thingsboard.trendz.service.assistance.agent.datepicker.DatePickerExpertAgent;
import org.thingsboard.trendz.service.assistance.agent.datepicker.DatePickerExpertAgentImpl;
import org.thingsboard.trendz.service.assistance.agent.datepicker.domain.DatePickerExpertRequest;
import org.thingsboard.trendz.service.assistance.agent.datepicker.domain.DatePickerExpertResponse;
import org.thingsboard.trendz.service.assistance.agent.datepicker.domain.DatePickerExpertResult;
import org.thingsboard.trendz.service.assistance.domain.ViewAssistanceContext;
import org.thingsboard.trendz.service.assistance.domain.ViewAssistanceState;

@Service
public class DatePickerExpertAgentImpl
implements DatePickerExpertAgent {
    private final AgentService agentService;

    @Autowired
    public DatePickerExpertAgentImpl(AgentService agentService) {
        this.agentService = agentService;
    }

    public DatePickerExpertResult generateDatePickerConfig(ViewAssistanceContext context) {
        ViewAssistanceState state = context.getViewAssistanceState();
        if (state.getDatePicker() == null) {
            state.setDatePicker(this.process(context));
        }
        return state.getDatePicker();
    }

    public DatePickerExpertResult process(ViewAssistanceContext context) {
        String prepared = this.agentService.preparePreviousAnswerInfo(context, AiAgentType.DATE_PICKER_EXPERT);
        DatePickerExpertRequest datePickerExpertRequest = DatePickerExpertRequest.builder().question(context.getQuestion()).myPreviousResponseWas(prepared).currentDateString(ZonedDateTime.now(context.getZoneId()).format(DateTimeFormatter.ISO_DATE)).build();
        DatePickerExpertResponse datePickerExpertResponse = (DatePickerExpertResponse)this.agentService.processAiRequest(context.getUser(), context.getAgentMetadataContainer(), (Object)datePickerExpertRequest, AiAgentType.DATE_PICKER_EXPERT);
        DatePickerConfig datePickerConfig = this.mapLiteDatePickerConfigToDatePickerConfig(datePickerExpertResponse.get_3_config(), context.getZoneId());
        return ((DatePickerExpertResult.DatePickerExpertResultBuilder)((DatePickerExpertResult.DatePickerExpertResultBuilder)DatePickerExpertResult.builder().comment(datePickerExpertResponse.get_1_comment())).status(datePickerExpertResponse.get_2_status())).datePickerConfig(datePickerConfig).build();
    }

    private DatePickerConfig mapLiteDatePickerConfigToDatePickerConfig(LiteDatePickerConfig liteDatePickerConfig, ZoneId zoneId) {
        DatePickerConfig datePickerConfig = new DatePickerConfig();
        datePickerConfig.setSelectedType(this.mapLiteSelectedTypeToDatePickerConfigSelectType(liteDatePickerConfig.get_1_datePickerConfigType()));
        if (liteDatePickerConfig.get_1_datePickerConfigType() == LiteDatePickerConfigType.RANGE_OF_DATES) {
            liteDatePickerConfig.set_2_1_relativityType(LiteRelativityType.THIS);
            liteDatePickerConfig.set_2_2_relativeUnit(LiteRelativeUnit.WEEK);
            liteDatePickerConfig.set_2_3_relativeUnitAmount(Integer.valueOf(1));
            LocalDateTime startDate = LocalDate.of((int)liteDatePickerConfig.get_4_1_yearStart(), liteDatePickerConfig.get_4_2_monthStart(), (int)liteDatePickerConfig.get_4_3_dayOfMonthStart()).atTime(LocalTime.MIN);
            datePickerConfig.setStartTs(startDate.toEpochSecond(zoneId.getRules().getOffset(startDate)) * 1000L);
            LocalDateTime endDate = LocalDate.of((int)liteDatePickerConfig.get_5_1_yearEnd(), liteDatePickerConfig.get_5_2_monthEnd(), (int)liteDatePickerConfig.get_5_3_dayOfMonthEnd()).atTime(LocalTime.MAX);
            datePickerConfig.setEndTs(endDate.toEpochSecond(zoneId.getRules().getOffset(endDate)) * 1000L + 999L);
        } else {
            datePickerConfig.setRelativeUnit(liteDatePickerConfig.get_2_1_relativityType().name().toLowerCase());
            datePickerConfig.setSelectedUnit(this.mapLiteSelectedUnitToDatePickerConfigSelectType(liteDatePickerConfig.get_2_2_relativeUnit()));
            datePickerConfig.setRelativeLastAmount(liteDatePickerConfig.get_2_3_relativeUnitAmount().intValue());
        }
        return datePickerConfig;
    }

    public DatePickerConfigSelectType mapLiteSelectedTypeToDatePickerConfigSelectType(LiteDatePickerConfigType liteDatePickerConfigType) {
        return switch (1.$SwitchMap$org$thingsboard$trendz$domain$assistance$agent$lite$LiteDatePickerConfigType[liteDatePickerConfigType.ordinal()]) {
            default -> throw new IncompatibleClassChangeError();
            case 1 -> new DatePickerConfigSelectType("Relative Dates", DatePickerConfigSelectType.Value.relative, true);
            case 2 -> new DatePickerConfigSelectType("Range of Dates", DatePickerConfigSelectType.Value.range, false);
        };
    }

    public DatePickerConfigSelectType mapLiteSelectedUnitToDatePickerConfigSelectType(LiteRelativeUnit liteRelativeUnit) {
        return switch (1.$SwitchMap$org$thingsboard$trendz$domain$assistance$agent$lite$LiteRelativeUnit[liteRelativeUnit.ordinal()]) {
            default -> throw new IncompatibleClassChangeError();
            case 1 -> new DatePickerConfigSelectType("Years", DatePickerConfigSelectType.Value.year, true);
            case 2 -> new DatePickerConfigSelectType("Months", DatePickerConfigSelectType.Value.month, false);
            case 3 -> new DatePickerConfigSelectType("Weeks", DatePickerConfigSelectType.Value.week, false);
            case 4 -> new DatePickerConfigSelectType("Days", DatePickerConfigSelectType.Value.day, false);
        };
    }
}

