/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.assistance.agent.dategrouper;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.domain.assistance.agent.AiAgentType;
import org.thingsboard.trendz.domain.assistance.agent.lite.LiteViewType;
import org.thingsboard.trendz.service.assistance.agent.AgentService;
import org.thingsboard.trendz.service.assistance.agent.dategrouper.DateGrouperExpertAgent;
import org.thingsboard.trendz.service.assistance.agent.dategrouper.domain.DateGrouperExpertRequest;
import org.thingsboard.trendz.service.assistance.agent.dategrouper.domain.DateGrouperExpertResponse;
import org.thingsboard.trendz.service.assistance.agent.dategrouper.domain.DateGrouperExpertResult;
import org.thingsboard.trendz.service.assistance.domain.ViewAssistanceContext;
import org.thingsboard.trendz.service.assistance.domain.ViewAssistanceState;

@Service
public class DateGrouperExpertAgentImpl
implements DateGrouperExpertAgent {
    private static final Logger log = LoggerFactory.getLogger(DateGrouperExpertAgentImpl.class);
    private final AgentService agentService;

    @Autowired
    public DateGrouperExpertAgentImpl(AgentService agentService) {
        this.agentService = agentService;
    }

    public DateGrouperExpertResult findDateGroupings(ViewAssistanceContext context, LiteViewType viewType) {
        ViewAssistanceState state = context.getViewAssistanceState();
        if (state.getDateGrouper() == null) {
            state.setDateGrouper(this.process(context, viewType));
            state.setView(null);
        }
        return state.getDateGrouper();
    }

    private DateGrouperExpertResult process(ViewAssistanceContext context, LiteViewType viewType) {
        String prepared = this.agentService.preparePreviousAnswerInfo(context, AiAgentType.DATE_PICKER_EXPERT);
        DateGrouperExpertRequest request = DateGrouperExpertRequest.builder().question(context.getQuestion()).myPreviousResponseWas(prepared).viewType(viewType).build();
        DateGrouperExpertResponse response = (DateGrouperExpertResponse)this.agentService.processAiRequest(context.getUser(), context.getAgentMetadataContainer(), (Object)request, AiAgentType.DATE_GROUPER_EXPERT);
        return ((DateGrouperExpertResult.DateGrouperExpertResultBuilder)((DateGrouperExpertResult.DateGrouperExpertResultBuilder)DateGrouperExpertResult.builder().comment(response.get_comment())).status(response.get_status())).dateGroupingItems(response.getDateGroupingItems()).build();
    }
}

