/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.assistance.agent;

import java.lang.invoke.CallSite;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.domain.assistance.agent.lite.LiteBusinessEntity;
import org.thingsboard.trendz.domain.assistance.agent.lite.LiteBusinessEntityField;
import org.thingsboard.trendz.domain.assistance.agent.lite.LiteTopology;
import org.thingsboard.trendz.domain.chat.ChatAvailableTopology;
import org.thingsboard.trendz.domain.chat.ChatAvailableTopologyBusinessEntityField;
import org.thingsboard.trendz.domain.definition.entity.BusinessEntity;
import org.thingsboard.trendz.domain.definition.entity.field.BusinessEntityField;
import org.thingsboard.trendz.exception.assistance.TrendzViewAssistanceException;
import org.thingsboard.trendz.service.assistance.agent.TopologyMapper;
import org.thingsboard.trendz.service.graph.RelationGraph;
import org.thingsboard.trendz.service.graph.RelationGraphService;
import org.thingsboard.trendz.service.graph.RelationNode;

@Service
public class TopologyMapperImpl
implements TopologyMapper {
    private final RelationGraphService relationGraphService;

    @Autowired
    public TopologyMapperImpl(RelationGraphService relationGraphService) {
        this.relationGraphService = relationGraphService;
    }

    public List<BusinessEntity> filterBusinessEntities(List<BusinessEntity> topology, ChatAvailableTopology availableTopology, UUID tenantId) {
        if (availableTopology.getBusinessEntities().isEmpty()) {
            return topology;
        }
        Map sourceBusinessEntityMap = topology.stream().collect(Collectors.toMap(BusinessEntity::getId, Function.identity()));
        return availableTopology.getBusinessEntities().stream().filter(availableBusinessEntity -> sourceBusinessEntityMap.containsKey(availableBusinessEntity.getBusinessEntityUUID())).map(availableBusinessEntity -> {
            BusinessEntity businessEntity = new BusinessEntity((BusinessEntity)sourceBusinessEntityMap.get(availableBusinessEntity.getBusinessEntityUUID()));
            Map sourceBusinessEntityFieldMap = businessEntity.getFields().stream().collect(Collectors.toMap(BusinessEntityField::getId, Function.identity()));
            if (availableBusinessEntity.getFields().isEmpty()) {
                return businessEntity;
            }
            List<BusinessEntityField> businessEntityFields = availableBusinessEntity.getFields().stream().map(ChatAvailableTopologyBusinessEntityField::getFieldUUID).map(sourceBusinessEntityFieldMap::get).filter(Objects::nonNull).toList();
            businessEntity.setFields(businessEntityFields);
            return businessEntity;
        }).toList();
    }

    public String transformInputData(LiteTopology liteTopology, boolean withGroups) {
        return liteTopology.getLiteBusinessEntities().stream().sorted(Comparator.comparingInt(o -> Optional.ofNullable(liteTopology.getEntityIdToComponentMap()).map(components -> (Integer)components.get(liteTopology.getEntityNameToIdMap().get(o.getName()))).orElse(0))).map(businessEntity -> {
            String entity = businessEntity.getName();
            String description = businessEntity.getDescription();
            Object fields = businessEntity.getBusinessEntityFields().stream().map(businessEntityField -> {
                String fieldDescription = businessEntityField.getDescription();
                String fieldName = businessEntityField.getName();
                String fieldType = businessEntityField.getType().name();
                String fieldQueryType = businessEntityField.getQueryType().name();
                String typePart = withGroups ? "%s".formatted(fieldQueryType.equals("ENTITY_NAME") ? "(name)" : "") : "(Type: \"%s\" - %s)".formatted(fieldQueryType, fieldType);
                String descriptionPart = fieldDescription == null || fieldDescription.isEmpty() ? "" : ": %s".formatted(fieldDescription);
                return "\t\"%s\" %s%s".formatted(fieldName, typePart, descriptionPart);
            }).reduce((o1, o2) -> o1 + "\n" + o2).orElse("\tNo fields");
            if (liteTopology.getEntityIdToComponentMap() != null && withGroups) {
                UUID businessEntityUUID = (UUID)liteTopology.getEntityNameToIdMap().get(entity);
                Integer componentNumber = (Integer)liteTopology.getEntityIdToComponentMap().get(businessEntityUUID);
                fields = (String)fields + "\n\n\tGroup: " + componentNumber;
            }
            return description == null || description.isEmpty() ? "\"%s\" (\n%s\n)".formatted(entity, fields) : "\"%s\": %s (\n%s\n)".formatted(entity, description, fields);
        }).reduce((o1, o2) -> o1 + "\n\n" + o2).map(total -> "\n" + total).orElseThrow(() -> new TrendzViewAssistanceException("Empty topology exception. Please pick available topology."));
    }

    public LiteTopology convertBusinessEntities(List<BusinessEntity> availableTopology, List<BusinessEntity> allEntities) {
        LiteTopology liteTopology = this.convertBusinessEntities(availableTopology);
        RelationGraph relationGraph = this.relationGraphService.createGraph(allEntities);
        Set allConnectedComponents = this.relationGraphService.findAllConnectedComponents(relationGraph);
        List<Set> componentList = allConnectedComponents.stream().map(RelationGraph::getNodes).map(relationNodes -> relationNodes.stream().map(RelationNode::getEntityId).collect(Collectors.toSet())).sorted(Comparator.comparing(component -> (UUID)component.stream().min(UUID::compareTo).orElseThrow())).toList();
        Map<UUID, Integer> entityIdToComponentMap = IntStream.range(0, componentList.size()).boxed().flatMap(index -> ((Set)componentList.get((int)index)).stream().map(uuid -> Pair.of((Object)uuid, (Object)index))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        liteTopology.setEntityIdToComponentMap(entityIdToComponentMap);
        return liteTopology;
    }

    public LiteTopology convertBusinessEntities(List<BusinessEntity> availableTopology) {
        Map entityNameDuplicatesMap = availableTopology.stream().collect(Collectors.groupingBy(BusinessEntity::getName, Collectors.mapping(BusinessEntity::getId, Collectors.toSet())));
        Map<String, UUID> entityNameToIdMap = entityNameDuplicatesMap.entrySet().stream().map(entry -> {
            String name = (String)entry.getKey();
            Set ids = (Set)entry.getValue();
            Iterator idIterator = ids.iterator();
            HashSet<Map.Entry<CallSite, UUID>> entries = new HashSet<Map.Entry<CallSite, UUID>>();
            for (int i = 0; i < ids.size(); ++i) {
                UUID id = (UUID)idIterator.next();
                entries.add(Map.entry(name + (String)(i == 0 ? "" : "_" + i), id));
            }
            return entries;
        }).flatMap(Collection::stream).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        Map<UUID, String> entityIdToNameMap = entityNameToIdMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
        HashMap<UUID, Map<String, UUID>> entityToFieldNameToIdMap = new HashMap<UUID, Map<String, UUID>>();
        HashMap<UUID, Map<UUID, String>> entityToFieldIdToNameMap = new HashMap<UUID, Map<UUID, String>>();
        for (BusinessEntity businessEntity2 : availableTopology) {
            Map fieldNameDuplicatesMap = businessEntity2.getFields().stream().collect(Collectors.groupingBy(BusinessEntityField::getName, Collectors.mapping(BusinessEntityField::getId, Collectors.toSet())));
            Map<String, UUID> fieldNameToIdMap = fieldNameDuplicatesMap.entrySet().stream().map(entry -> {
                String name = (String)entry.getKey();
                Set ids = (Set)entry.getValue();
                Iterator idIterator = ids.iterator();
                HashSet<Map.Entry<CallSite, UUID>> entries = new HashSet<Map.Entry<CallSite, UUID>>();
                for (int i = 0; i < ids.size(); ++i) {
                    UUID id = (UUID)idIterator.next();
                    entries.add(Map.entry(name + (String)(i == 0 ? "" : "_" + i), id));
                }
                return entries;
            }).flatMap(Collection::stream).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            Map<UUID, String> fieldIdToNameMap = fieldNameToIdMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
            entityToFieldNameToIdMap.put(businessEntity2.getId(), fieldNameToIdMap);
            entityToFieldIdToNameMap.put(businessEntity2.getId(), fieldIdToNameMap);
        }
        Set liteBusinessEntities = availableTopology.stream().map(businessEntity -> LiteBusinessEntity.builder().name((String)entityIdToNameMap.get(businessEntity.getId())).description(businessEntity.getDescription()).businessEntityFields(this.convertBusinessEntityFields((Map)entityToFieldIdToNameMap.get(businessEntity.getId()), businessEntity.getFields())).build()).collect(Collectors.toSet());
        return LiteTopology.builder().liteBusinessEntities(liteBusinessEntities).entityNameToIdMap(entityNameToIdMap).entityToFieldNameToIdMap(entityToFieldNameToIdMap).build();
    }

    private Set<LiteBusinessEntityField> convertBusinessEntityFields(Map<UUID, String> fieldIdToNameMap, List<BusinessEntityField> businessEntityFields) {
        return businessEntityFields.stream().map(businessEntityField -> LiteBusinessEntityField.builder().name((String)fieldIdToNameMap.get(businessEntityField.getId())).description(businessEntityField.getDescription()).type(businessEntityField.getType()).queryType(businessEntityField.getQuery().getQueryType()).build()).collect(Collectors.toSet());
    }
}

