/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.assistance.agent;

import com.fasterxml.jackson.databind.JsonNode;
import dev.langchain4j.model.chat.ChatModel;
import dev.langchain4j.service.Result;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.dao.assistance.AgentAiDao;
import org.thingsboard.trendz.domain.assistance.agent.AgentAi;
import org.thingsboard.trendz.domain.assistance.agent.AgentChangeRequest;
import org.thingsboard.trendz.domain.assistance.agent.AgentMetadata;
import org.thingsboard.trendz.domain.assistance.agent.AiAgentType;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.assistance.agent.AgentFactory;
import org.thingsboard.trendz.service.assistance.agent.AgentMetadataService;
import org.thingsboard.trendz.service.assistance.agent.AgentService;
import org.thingsboard.trendz.service.assistance.agent.AgentServiceImpl;
import org.thingsboard.trendz.service.assistance.agent.businessanalytic.AiBusinessAnalyticExpert;
import org.thingsboard.trendz.service.assistance.agent.customprompt.AiCustomPromptExpert;
import org.thingsboard.trendz.service.assistance.agent.customprompt.AiViewSummaryExpert;
import org.thingsboard.trendz.service.assistance.agent.dategrouper.AiDateGrouperExpert;
import org.thingsboard.trendz.service.assistance.agent.dategrouper.domain.DateGrouperExpertRequest;
import org.thingsboard.trendz.service.assistance.agent.datepicker.AiDatePickerExpert;
import org.thingsboard.trendz.service.assistance.agent.datepicker.domain.DatePickerExpertRequest;
import org.thingsboard.trendz.service.assistance.agent.errordescriber.AiErrorDescriberExpert;
import org.thingsboard.trendz.service.assistance.agent.errordescriber.domain.ErrorDescriberExpertRequest;
import org.thingsboard.trendz.service.assistance.agent.filter.AiFilterExpert;
import org.thingsboard.trendz.service.assistance.agent.filter.domain.FilterExpertRequest;
import org.thingsboard.trendz.service.assistance.agent.groupfinder.AiGroupFinderExpert;
import org.thingsboard.trendz.service.assistance.agent.groupfinder.domain.GroupFinderExpertRequest;
import org.thingsboard.trendz.service.assistance.agent.memorymanager.AiMemoryManagerExpert;
import org.thingsboard.trendz.service.assistance.agent.memorymanager.domain.MemoryManagerExpertRequest;
import org.thingsboard.trendz.service.assistance.agent.queryanalyzer.AiQueryAnalyzerExpert;
import org.thingsboard.trendz.service.assistance.agent.queryanalyzer.domain.QueryAnalyzerExpertRequest;
import org.thingsboard.trendz.service.assistance.agent.resultanalyzer.AiResultAnalyzerExpert;
import org.thingsboard.trendz.service.assistance.agent.resultanalyzer.domain.ResultAnalyzerExpertRequest;
import org.thingsboard.trendz.service.assistance.agent.settings.AiGeneralViewSettingsExpert;
import org.thingsboard.trendz.service.assistance.agent.settings.domain.GeneralViewSettingsExpertRequest;
import org.thingsboard.trendz.service.assistance.agent.simpleoutput.AiSimpleOutputExpert;
import org.thingsboard.trendz.service.assistance.agent.simpleoutput.domain.SimpleOutputExpertRequest;
import org.thingsboard.trendz.service.assistance.agent.state.AiStateManagerExpert;
import org.thingsboard.trendz.service.assistance.agent.state.domain.StateManagerExpertRequest;
import org.thingsboard.trendz.service.assistance.agent.topicrouter.AiTopicRouterExpert;
import org.thingsboard.trendz.service.assistance.agent.topicrouter.domain.TopicRouterExpertRequest;
import org.thingsboard.trendz.service.assistance.agent.topologymapper.AiTopologyMapperExpert;
import org.thingsboard.trendz.service.assistance.agent.topologymapper.domain.TopologyMapperExpertRequest;
import org.thingsboard.trendz.service.assistance.agent.view.AiBarChartViewExpert;
import org.thingsboard.trendz.service.assistance.agent.view.AiCardViewExpert;
import org.thingsboard.trendz.service.assistance.agent.view.AiHeatmapCalendarViewExpert;
import org.thingsboard.trendz.service.assistance.agent.view.AiHeatmapViewExpert;
import org.thingsboard.trendz.service.assistance.agent.view.AiLineChartViewExpert;
import org.thingsboard.trendz.service.assistance.agent.view.AiPieChartViewExpert;
import org.thingsboard.trendz.service.assistance.agent.view.AiScatterPlotViewExpert;
import org.thingsboard.trendz.service.assistance.agent.view.AiTableViewExpert;
import org.thingsboard.trendz.service.assistance.agent.view.domain.ViewExpertRequest;
import org.thingsboard.trendz.service.assistance.domain.ViewAssistanceContext;
import org.thingsboard.trendz.service.assistance.llm.LlmService;
import org.thingsboard.trendz.service.metric.agent.AiMetricCreationExpert;
import org.thingsboard.trendz.service.metric.agent.AiMetricGenerationExpert;
import org.thingsboard.trendz.service.metric.agent.developer.AiPythonDeveloperExpert;
import org.thingsboard.trendz.service.metric.agent.input.AiMetricBusinessAnalystExpert;
import org.thingsboard.trendz.service.metric.agent.memorymanager.AiMetricMemoryManagerExpert;
import org.thingsboard.trendz.service.metric.agent.output.AiMetricOutputExpert;
import org.thingsboard.trendz.tools.json.JsonUtils;

@Service
public class AgentServiceImpl
implements AgentService {
    private static final Logger log = LoggerFactory.getLogger(AgentServiceImpl.class);
    private final AgentAiDao agentAiDao;
    private final AgentFactory agentFactory;
    private final AgentMetadataService agentMetadataService;
    private final Map<UUID, Map<AiAgentType, Pair<ChatModel, Object>>> agents = new ConcurrentHashMap();

    @Autowired
    public AgentServiceImpl(AgentAiDao agentAiDao, AgentFactory agentFactory, AgentMetadataService agentMetadataService, LlmService llmService) {
        this.agentAiDao = agentAiDao;
        this.agentFactory = agentFactory;
        this.agentMetadataService = agentMetadataService;
        llmService.insertEvictFunction(arg_0 -> this.evictTenantAgents(arg_0));
    }

    public List<AgentAi> getAiAgents(AiAgentType aiAgentType) {
        if (aiAgentType == null) {
            return this.agentAiDao.getAll();
        }
        return this.agentAiDao.getAllByType(aiAgentType);
    }

    public List<AgentAi> getAiAgents(AiAgentType aiAgentType, int version) {
        if (aiAgentType == null) {
            if (version == -1) {
                return this.agentAiDao.getAllWithLatestVersion();
            }
            return this.agentAiDao.getAllByVersion(version);
        }
        if (version == -1) {
            return this.agentAiDao.getByTypeWithLatestVersion(aiAgentType).stream().toList();
        }
        return this.agentAiDao.getAllByTypeAndVersion(aiAgentType, version);
    }

    public AgentAi modify(AgentChangeRequest agentChangeRequest, AiAgentType aiAgentType) {
        return this.agentAiDao.modify(agentChangeRequest, aiAgentType);
    }

    public Object processAiRequest(JwtSecurityUser user, List<AgentMetadata> agentMetadataContainer, Object request, AiAgentType aiAgentType) {
        Map tenantAgents = this.getTenantAgents(user);
        Object agent = ((Pair)tenantAgents.get(aiAgentType)).getRight();
        ChatModel model = (ChatModel)((Pair)tenantAgents.get(aiAgentType)).getLeft();
        long timestampStart = AgentMetadataService.getCurrentTimestampInNanos();
        Result res = this.processAgent(aiAgentType, agent, request);
        long timestampEnd = AgentMetadataService.getCurrentTimestampInNanos();
        this.agentMetadataService.extractMetadata(res, request, timestampEnd - timestampStart, aiAgentType, user, agentMetadataContainer, model.defaultRequestParameters().modelName());
        return res.content();
    }

    public String processAiRequestCustomPrompt(JwtSecurityUser user, String prompt, String data) {
        Map tenantAgents = this.getTenantAgents(user);
        AiCustomPromptExpert agent = (AiCustomPromptExpert)((Pair)tenantAgents.get(AiAgentType.CUSTOM_PROMPT_EXPERT)).getRight();
        ChatModel model = (ChatModel)((Pair)tenantAgents.get(AiAgentType.CUSTOM_PROMPT_EXPERT)).getLeft();
        long timestampStart = AgentMetadataService.getCurrentTimestampInNanos();
        Result res = agent.generate(prompt, data);
        long timestampEnd = AgentMetadataService.getCurrentTimestampInNanos();
        this.agentMetadataService.saveCustomPromptMetadata(prompt, data, res, timestampEnd - timestampStart, model.defaultRequestParameters().modelName(), user);
        return (String)res.content();
    }

    public String processAiRequestViewSummary(JwtSecurityUser user, String prompt, String data) {
        Map tenantAgents = this.getTenantAgents(user);
        AiViewSummaryExpert agent = (AiViewSummaryExpert)((Pair)tenantAgents.get(AiAgentType.VIEW_SUMMARY_EXPERT)).getRight();
        ChatModel model = (ChatModel)((Pair)tenantAgents.get(AiAgentType.VIEW_SUMMARY_EXPERT)).getLeft();
        long timestampStart = AgentMetadataService.getCurrentTimestampInNanos();
        Result res = agent.generate(prompt, data);
        long timestampEnd = AgentMetadataService.getCurrentTimestampInNanos();
        this.agentMetadataService.saveCustomPromptMetadata(prompt, data, res, timestampEnd - timestampStart, model.defaultRequestParameters().modelName(), user);
        return (String)res.content();
    }

    public String preparePreviousAnswerInfo(ViewAssistanceContext context, AiAgentType aiAgentType) {
        if (context.getPreviousMessageAgentMetadata() == null) {
            return null;
        }
        return context.getPreviousMessageAgentMetadata().stream().filter(agentMetadata -> agentMetadata.getAiAgentType() == aiAgentType).findFirst().map(AgentMetadata::getAiRequest).map(JsonUtils::toNodeFromObject).map(i -> i.get("question")).map(JsonNode::toPrettyString).map(question -> "Your answer on previous user question (\"%s\"):\n%s".formatted(question, context.getPreviousMessageAgentMetadata().stream().filter(agentMetadata -> agentMetadata.getAiAgentType() == aiAgentType).findFirst().map(AgentMetadata::getAiResponse).map(JsonUtils::toNodeFromObject).map(JsonNode::toPrettyString).orElse(""))).orElse(null);
    }

    private void evictTenantAgents(JwtSecurityUser user) {
        this.agents.remove(user.getTenantId());
    }

    private Map<AiAgentType, Pair<ChatModel, Object>> getTenantAgents(JwtSecurityUser user) {
        return this.agents.computeIfAbsent(user.getTenantId(), i -> this.agentFactory.createLlmAgentsBundle(user));
    }

    private Result<?> processAgent(AiAgentType aiAgentType, Object agent, Object request) {
        return switch (1.$SwitchMap$org$thingsboard$trendz$domain$assistance$agent$AiAgentType[aiAgentType.ordinal()]) {
            case 1 -> ((AiMemoryManagerExpert)agent).generate((MemoryManagerExpertRequest)request);
            case 2 -> ((AiBusinessAnalyticExpert)agent).generate((String)request);
            case 3 -> ((AiTopicRouterExpert)agent).generate((TopicRouterExpertRequest)request);
            case 4 -> ((AiStateManagerExpert)agent).generate((StateManagerExpertRequest)request);
            case 5 -> ((AiGroupFinderExpert)agent).generate((GroupFinderExpertRequest)request);
            case 6, 7 -> ((AiQueryAnalyzerExpert)agent).generate((QueryAnalyzerExpertRequest)request);
            case 8 -> ((AiTopologyMapperExpert)agent).generate((TopologyMapperExpertRequest)request);
            case 9 -> ((AiFilterExpert)agent).generate((FilterExpertRequest)request);
            case 10 -> ((AiDatePickerExpert)agent).generate((DatePickerExpertRequest)request);
            case 11 -> ((AiDateGrouperExpert)agent).generate((DateGrouperExpertRequest)request);
            case 12 -> ((AiGeneralViewSettingsExpert)agent).generate((GeneralViewSettingsExpertRequest)request);
            case 13 -> ((AiTableViewExpert)agent).generate((ViewExpertRequest)request);
            case 14 -> ((AiLineChartViewExpert)agent).generate((ViewExpertRequest)request);
            case 15 -> ((AiBarChartViewExpert)agent).generate((ViewExpertRequest)request);
            case 16 -> ((AiScatterPlotViewExpert)agent).generate((ViewExpertRequest)request);
            case 17 -> ((AiPieChartViewExpert)agent).generate((ViewExpertRequest)request);
            case 18 -> ((AiHeatmapViewExpert)agent).generate((ViewExpertRequest)request);
            case 19 -> ((AiHeatmapCalendarViewExpert)agent).generate((ViewExpertRequest)request);
            case 20 -> ((AiCardViewExpert)agent).generate((ViewExpertRequest)request);
            case 21 -> ((AiErrorDescriberExpert)agent).generate((ErrorDescriberExpertRequest)request);
            case 22 -> ((AiResultAnalyzerExpert)agent).generate((ResultAnalyzerExpertRequest)request);
            case 23 -> ((AiSimpleOutputExpert)agent).generate((SimpleOutputExpertRequest)request);
            case 24 -> ((AiMetricMemoryManagerExpert)agent).generate((String)request);
            case 25 -> ((AiMetricBusinessAnalystExpert)agent).generate((String)request);
            case 26 -> ((AiMetricOutputExpert)agent).generate((String)request);
            case 27, 28 -> ((AiMetricGenerationExpert)agent).generate((String)request);
            case 29, 30 -> ((AiMetricCreationExpert)agent).generate((String)request);
            case 31 -> ((AiPythonDeveloperExpert)agent).generate((String)request);
            default -> throw new IllegalArgumentException("%s expert forbidden to call from View Assistant".formatted(aiAgentType.name()));
        };
    }
}

