/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.assistance.agent;

import dev.langchain4j.model.chat.ChatModel;
import dev.langchain4j.service.AiServices;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.dao.assistance.AgentAiDao;
import org.thingsboard.trendz.domain.assistance.agent.AgentAi;
import org.thingsboard.trendz.domain.assistance.agent.AiAgentType;
import org.thingsboard.trendz.domain.assistance.model.LlmConfig;
import org.thingsboard.trendz.domain.assistance.model.LlmSettings;
import org.thingsboard.trendz.domain.chat.ChatType;
import org.thingsboard.trendz.exception.assistance.AgentSystemMessageException;
import org.thingsboard.trendz.exception.assistance.TrendzViewAssistanceException;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.assistance.agent.AgentFactory;
import org.thingsboard.trendz.service.assistance.llm.LlmService;

@Service
public class AgentFactoryImpl
implements AgentFactory {
    private static final Logger log = LoggerFactory.getLogger(AgentFactoryImpl.class);
    private final AgentAiDao agentAiDao;
    private final LlmService llmService;
    private final boolean usePromptsFromLocalDir;
    private final String promptsLocalDir;

    @Autowired
    public AgentFactoryImpl(AgentAiDao agentAiDao, LlmService llmService, @Value(value="${viewAssistance.prompt.source.useLocal}") boolean usePromptsFromLocalDir, @Value(value="${viewAssistance.prompt.source.localPath}") String promptsLocalDir) {
        this.agentAiDao = agentAiDao;
        this.llmService = llmService;
        this.usePromptsFromLocalDir = usePromptsFromLocalDir;
        this.promptsLocalDir = promptsLocalDir;
    }

    public Map<AiAgentType, Pair<ChatModel, Object>> createLlmAgentsBundle(JwtSecurityUser user) {
        LlmSettings llmSettings = this.llmService.findLlmSettings(user);
        if (!llmSettings.isActive()) {
            throw new TrendzViewAssistanceException("The View Assistance is not activated in the LLM Settings.");
        }
        HashSet<UUID> usedConfigSets = new HashSet<UUID>();
        usedConfigSets.add(llmSettings.getDefaultLlmConfigId());
        usedConfigSets.addAll(llmSettings.getChatTypeToLlmConfigMap().values());
        Set llmConfigs = this.llmService.findByIdSet(user, usedConfigSets);
        return this.createLlmAgentsBundle(llmSettings, llmConfigs);
    }

    private Map<AiAgentType, Pair<ChatModel, Object>> createLlmAgentsBundle(LlmSettings llmSettings, Set<LlmConfig> llmConfigs) {
        ConcurrentHashMap<ChatType, UUID> chatTypeToLlmConfigMap;
        if (llmSettings == null || llmConfigs == null) {
            throw new IllegalArgumentException("llmSettings or llmConfigs is null");
        }
        if (llmConfigs.isEmpty()) {
            throw new IllegalArgumentException("LLM models do not exist. Please, add LLM model on the settings page");
        }
        if (llmSettings.isUseDefault()) {
            UUID defaultLlmConfigId = llmSettings.getDefaultLlmConfigId();
            if (defaultLlmConfigId == null) {
                throw new IllegalArgumentException("Default LLM models is not set. Please, create and set default LLM model on the settings page");
            }
            chatTypeToLlmConfigMap = new ConcurrentHashMap<ChatType, UUID>();
            for (ChatType chatType : ChatType.values()) {
                chatTypeToLlmConfigMap.put(chatType, defaultLlmConfigId);
            }
        } else {
            chatTypeToLlmConfigMap = llmSettings.getChatTypeToLlmConfigMap();
        }
        Map idToLlmConfigMap = llmConfigs.stream().collect(Collectors.toMap(LlmConfig::getId, Function.identity()));
        ConcurrentHashMap<AiAgentType, Pair<ChatModel, Object>> result = new ConcurrentHashMap<AiAgentType, Pair<ChatModel, Object>>();
        for (AiAgentType agentType : AiAgentType.values()) {
            ChatType chatType = agentType.getChatType();
            UUID configId = (UUID)chatTypeToLlmConfigMap.get(chatType);
            LlmConfig llmConfig = (LlmConfig)idToLlmConfigMap.get(configId);
            if (llmConfig == null) continue;
            ChatModel chatModel = this.llmService.createChatModelByConfig(llmConfig);
            Function<Object, String> systemMessageProvider = o -> this.getSystemMessage(agentType);
            Object agent = AiServices.builder((Class)agentType.getExpert()).chatModel(chatModel).systemMessageProvider(systemMessageProvider).build();
            result.put(agentType, (Pair<ChatModel, Object>)Pair.of((Object)chatModel, (Object)agent));
        }
        return result;
    }

    private String getSystemMessage(AiAgentType agentType) {
        if (this.usePromptsFromLocalDir) {
            try {
                Path path = Path.of(this.promptsLocalDir, "%s.txt".formatted(agentType.name()));
                String systemMessage2 = String.join((CharSequence)"\n", Files.readAllLines(path));
                if (StringUtils.isEmpty((CharSequence)systemMessage2)) {
                    throw new AgentSystemMessageException(agentType, "The prompt is blank");
                }
                return systemMessage2;
            }
            catch (IOException e) {
                throw new AgentSystemMessageException(agentType, "Error during loading the prompt", (Throwable)e);
            }
        }
        return this.agentAiDao.getByTypeWithLatestVersion(agentType).map(AgentAi::getSystemMessage).filter(systemMessage -> !StringUtils.isBlank((CharSequence)systemMessage)).orElseThrow(() -> new AgentSystemMessageException(agentType, "The prompt is blank"));
    }
}

