/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.alarm.alarmfield;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.domain.definition.entity.BusinessEntity;
import org.thingsboard.trendz.domain.definition.entity.BusinessEntityType;
import org.thingsboard.trendz.domain.definition.entity.field.FieldType;
import org.thingsboard.trendz.domain.definition.view.FieldAggregation;
import org.thingsboard.trendz.domain.definition.view.config.ViewField;
import org.thingsboard.trendz.domain.measurement.Measurable;
import org.thingsboard.trendz.domain.measurement.MeasuredTaskType;
import org.thingsboard.trendz.domain.runtime.FieldValue;
import org.thingsboard.trendz.domain.runtime.Item;
import org.thingsboard.trendz.exception.TrendzException;
import org.thingsboard.trendz.service.alarm.alarmfield.AlarmField;
import org.thingsboard.trendz.service.alarm.alarmfield.AlarmFieldProcessor;
import org.thingsboard.trendz.service.alarm.alarmfield.TbAlarmData;
import org.thingsboard.trendz.service.provider.TbRestDataSource;
import org.thingsboard.trendz.service.view.ViewContext;
import org.thingsboard.trendz.service.view.proto.StreamTelemetryStore;
import org.thingsboard.trendz.service.view.proto.StreamTelemetryStoreKey;
import org.thingsboard.trendz.service.view.proto.ViewRequest;
import org.thingsboard.trendz.service.view.proto.WindowedStreamStore;
import org.thingsboard.trendz.tools.json.JsonUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Service
public class AlarmFieldProcessor {
    private static final Logger log = LoggerFactory.getLogger(AlarmFieldProcessor.class);
    private static final Set<FieldAggregation> PERMITTED_FIELD_AGGREGATIONS = Sets.newHashSet((Object[])new FieldAggregation[]{FieldAggregation.UNIQ, FieldAggregation.COUNT});
    private final TbRestDataSource dataSource;

    @Autowired
    public AlarmFieldProcessor(TbRestDataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Measurable(context="#ctx", type=MeasuredTaskType.ALARM_FIELD_PROCESSING, viewFieldName="#viewField.label", viewFieldAggregation="#viewField.aggregationType", itemName="#item.name")
    public Flux<FieldValue> processField(Item item, ViewField viewField, ViewRequest viewRequest, WindowedStreamStore windowedStore, ViewContext ctx) {
        Optional optional;
        log.trace("Alarm field processing is started...");
        UUID businessEntityId = viewField.getBusinessEntityId();
        BusinessEntity businessEntity = (BusinessEntity)ctx.getBusinessEntityMap().get(businessEntityId);
        if (businessEntity.getQuery().getEntityType().equals((Object)BusinessEntityType.EXTERNAL)) {
            throw new TrendzException("The alarm field does not support external fields (yet)");
        }
        if (!PERMITTED_FIELD_AGGREGATIONS.contains(viewField.getAggregationType())) {
            String message = "Alarm field can be used only with next aggregations: %s".formatted(Arrays.toString(PERMITTED_FIELD_AGGREGATIONS.toArray()));
            throw new IllegalStateException(message);
        }
        if (viewRequest.isStreamProcessingEnabled() && viewField.getAggregationType() == FieldAggregation.COUNT && (optional = this.loadFromStore(item, businessEntityId, viewField, viewRequest, windowedStore, ctx)).isPresent()) {
            return Flux.fromIterable((Iterable)((Iterable)optional.get()));
        }
        return this.loadRawAlarmData(ctx, businessEntityId, viewRequest, item, viewField).flatMapIterable(responseData -> this.transformToFieldValue(responseData, item, viewField)).doOnNext(fv -> {
            if (viewRequest.isStreamProcessingEnabled()) {
                StreamTelemetryStore streamStore = ctx.getStreamStore(businessEntityId);
                StreamTelemetryStoreKey storeKey = new StreamTelemetryStoreKey(item.getId(), viewField.getAggregationType(), viewRequest.getStartTs(viewField), viewRequest.getEndTs(viewField));
                streamStore.add(businessEntity, storeKey, fv);
            }
        }).map(fv -> {
            if (viewField.getAggregationType().equals((Object)FieldAggregation.COUNT)) {
                return new FieldValue(item, FieldType.NUMERIC, (Object)1, fv.getTs());
            }
            return fv;
        }).collectList().doOnNext(r -> this.releaseLock(ctx, businessEntityId, item, viewField)).flatMapIterable(l -> l).defaultIfEmpty((Object)new FieldValue(item, FieldType.BLANK, null));
    }

    private Optional<List<FieldValue>> loadFromStore(Item item, UUID businessEntityId, ViewField viewField, ViewRequest viewRequest, WindowedStreamStore windowedStore, ViewContext ctx) {
        this.waitForLockReleased(ctx, businessEntityId, item, viewField);
        if (this.hasValuesInStore(ctx, viewRequest, businessEntityId, item, viewField)) {
            ((CountDownLatch)ctx.getStreamStore(businessEntityId).getLoadLock(item, viewField.getAggregationType()).orElseThrow()).countDown();
            Set allowedTs = viewRequest.isStreamProcessingEnabled() ? this.getTimestampsForGroup(item, windowedStore, viewField, viewRequest, ctx) : null;
            List fieldValues = this.readFromStore(ctx, viewRequest, businessEntityId, item, allowedTs, viewField, viewRequest);
            return Optional.of(fieldValues);
        }
        return Optional.empty();
    }

    private List<FieldValue> transformToFieldValue(String responseData, Item item, ViewField viewField) {
        JsonNode dataListJson = JsonUtils.toNodeFromRaw((String)responseData).get("data");
        ArrayList jsonNodes = Lists.newArrayList((Iterator)dataListJson.elements());
        return jsonNodes.stream().map(TbAlarmData::mapFromJson).map(alarm -> this.mapToFieldValue(alarm, item, viewField.getSelectedAlarmField())).collect(Collectors.toList());
    }

    private Mono<String> loadRawAlarmData(ViewContext ctx, UUID businessEntityId, ViewRequest viewRequest, Item item, ViewField viewField) {
        BusinessEntity businessEntity = (BusinessEntity)ctx.getBusinessEntityMap().get(businessEntityId);
        BusinessEntityType entityType = businessEntity.getQuery().getEntityType();
        long startTs = viewRequest.getStartTs(viewField);
        long endTs = viewRequest.getEndTs(viewField);
        return this.dataSource.loadAlarms(ctx, entityType, item.getId(), ctx.getJwtToken(), startTs, endTs, 100000);
    }

    private void releaseLock(ViewContext ctx, UUID businessEntityId, Item item, ViewField viewField) {
        Optional lock = ctx.getStreamStore(businessEntityId).getLoadLock(item, viewField.getAggregationType());
        if (lock.isPresent()) {
            log.trace("Release lock {} {} {}", new Object[]{item.getName(), viewField.getLabel(), viewField.getAggregationType().name()});
            ((CountDownLatch)lock.get()).countDown();
        }
    }

    private void waitForLockReleased(ViewContext ctx, UUID businessEntityId, Item item, ViewField viewField) {
        Optional lock = ctx.getStreamStore(businessEntityId).getLoadLock(item, viewField.getAggregationType());
        if (lock.isPresent()) {
            try {
                ((CountDownLatch)lock.get()).await();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    private FieldValue mapToFieldValue(TbAlarmData alarm, Item item, AlarmField selectedAlarmField) {
        return switch (1.$SwitchMap$org$thingsboard$trendz$service$alarm$alarmfield$AlarmField[selectedAlarmField.ordinal()]) {
            case 1 -> new FieldValue(item, FieldType.STRING, (Object)alarm.getCustomerId().toString(), alarm.getStartTs());
            case 2 -> new FieldValue(item, FieldType.STRING, (Object)alarm.getType(), alarm.getStartTs());
            case 3 -> new FieldValue(item, FieldType.STRING, (Object)alarm.getStatus(), alarm.getStartTs());
            case 4 -> new FieldValue(item, FieldType.STRING, (Object)alarm.getSeverity(), alarm.getStartTs());
            case 5 -> new FieldValue(item, FieldType.DATE, (Object)alarm.getCreatedTime(), alarm.getStartTs());
            case 6 -> new FieldValue(item, FieldType.DATE, (Object)alarm.getStartTs(), alarm.getStartTs());
            case 7 -> new FieldValue(item, FieldType.DATE, (Object)alarm.getEndTs(), alarm.getStartTs());
            case 8 -> new FieldValue(item, FieldType.DATE, (Object)alarm.getAckTs(), alarm.getStartTs());
            case 9 -> new FieldValue(item, FieldType.DATE, (Object)alarm.getClearTs(), alarm.getStartTs());
            default -> throw new IllegalStateException("Unsupported alarm field: " + String.valueOf(selectedAlarmField));
        };
    }

    private boolean hasValuesInStore(ViewContext ctx, ViewRequest viewRequest, UUID beId, Item item, ViewField viewField) {
        StreamTelemetryStoreKey storeKey;
        StreamTelemetryStore streamStore = ctx.getStreamStore(beId);
        List values = streamStore.get(storeKey = new StreamTelemetryStoreKey(item.getId(), viewField.getAggregationType(), viewRequest.getStartTs(viewField), viewRequest.getEndTs(viewField)));
        if (CollectionUtils.isNotEmpty((Collection)values)) {
            return true;
        }
        StreamTelemetryStoreKey uniqueStoreKey = new StreamTelemetryStoreKey(item.getId(), FieldAggregation.UNIQ, viewRequest.getStartTs(viewField), viewRequest.getEndTs(viewField));
        List uniqValueFields = streamStore.get(uniqueStoreKey);
        return CollectionUtils.isNotEmpty((Collection)uniqValueFields);
    }

    private List<FieldValue> readFromStore(ViewContext ctx, ViewRequest viewRequest, UUID beId, Item item, Set<Long> allowedTs, ViewField viewField, ViewRequest request) {
        StreamTelemetryStoreKey storeKey;
        StreamTelemetryStore streamStore = ctx.getStreamStore(beId);
        List values = streamStore.get(storeKey = new StreamTelemetryStoreKey(item.getId(), viewField.getAggregationType(), viewRequest.getStartTs(viewField), viewRequest.getEndTs(viewField)));
        if (CollectionUtils.isEmpty((Collection)values)) {
            StreamTelemetryStoreKey uniqueStoreKey = new StreamTelemetryStoreKey(item.getId(), FieldAggregation.UNIQ, viewRequest.getStartTs(viewField), viewRequest.getEndTs(viewField));
            values = streamStore.get(uniqueStoreKey);
        }
        if (CollectionUtils.isNotEmpty((Collection)values)) {
            return values.stream().filter(fv -> allowedTs == null || allowedTs.contains(fv.getTs())).map(fv -> {
                if (request.isCacheItemTelemetry() && viewField.getAggregationType() == FieldAggregation.COUNT) {
                    return new FieldValue(item, FieldType.NUMERIC, (Object)1, fv.getTs());
                }
                return fv;
            }).collect(Collectors.toList());
        }
        return Lists.newArrayList((Object[])new FieldValue[]{new FieldValue(item, FieldType.BLANK, null)});
    }

    private Set<Long> getTimestampsForGroup(Item item, WindowedStreamStore windowedStore, ViewField viewField, ViewRequest viewRequest, ViewContext ctx) {
        Sets.SetView allowedTs = null;
        for (Map.Entry entry : windowedStore.getGroupKeys().entrySet()) {
            StreamTelemetryStore streamStore = ctx.getStreamStore(((ViewField)entry.getKey()).getBusinessEntityId());
            StreamTelemetryStoreKey storeKey = new StreamTelemetryStoreKey(item.getId(), viewField.getAggregationType(), viewRequest.getStartTs(viewField), viewRequest.getEndTs(viewField));
            Set allowedValues = entry.getValue() instanceof Set ? (Set)entry.getValue() : Sets.newHashSet((Object[])new Object[]{entry.getValue()});
            List fieldValues = streamStore.get(storeKey);
            if (fieldValues == null) {
                StreamTelemetryStoreKey uniqueStoreKey = new StreamTelemetryStoreKey(item.getId(), FieldAggregation.UNIQ, viewRequest.getStartTs(viewField), viewRequest.getEndTs(viewField));
                fieldValues = streamStore.get(uniqueStoreKey);
            }
            Sets.SetView timestamps = fieldValues.stream().filter(fv -> allowedValues.contains(fv.getInnerValue())).map(FieldValue::getTs).collect(Collectors.toSet());
            if (allowedTs == null) {
                allowedTs = timestamps;
                continue;
            }
            allowedTs = Sets.intersection(allowedTs, timestamps);
        }
        return allowedTs;
    }
}

