/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.aggregation;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.thingsboard.trendz.service.aggregation.DateAggregationGroup;
import org.thingsboard.trendz.service.aggregation.DateAggregationKey;
import org.thingsboard.trendz.service.aggregation.DateAggregationValue;

public class DateAggregationGroup {
    private Map<DateAggregationKey, DateAggregationValue> keys;

    public DateAggregationGroup() {
        this.keys = new HashMap();
    }

    public DateAggregationGroup(DateAggregationGroup that) {
        this.keys = that.keys == null ? null : that.keys.entrySet().stream().map(entry -> Map.entry(new DateAggregationKey((DateAggregationKey)entry.getKey()), new DateAggregationValue((DateAggregationValue)entry.getValue()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    @JsonIgnore
    public DateAggregationKey getLowestKey() {
        return this.keys.keySet().stream().min(Comparator.comparingInt(i -> i.getAggregationType().ordinal())).orElseThrow();
    }

    @JsonIgnore
    public DateAggregationValue get(DateAggregationKey key) {
        return (DateAggregationValue)this.keys.get(key);
    }

    public void put(DateAggregationKey key, DateAggregationValue value) {
        if (this.keys.containsKey(key)) {
            throw new IllegalArgumentException("The key already presents");
        }
        this.keys.put(key, value);
    }

    public static DateAggregationGroupBuilder builder() {
        return new DateAggregationGroupBuilder();
    }

    public Map<DateAggregationKey, DateAggregationValue> getKeys() {
        return this.keys;
    }

    public void setKeys(Map<DateAggregationKey, DateAggregationValue> keys) {
        this.keys = keys;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DateAggregationGroup)) {
            return false;
        }
        DateAggregationGroup other = (DateAggregationGroup)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Map this$keys = this.getKeys();
        Map other$keys = other.getKeys();
        return !(this$keys == null ? other$keys != null : !((Object)this$keys).equals(other$keys));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DateAggregationGroup;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map $keys = this.getKeys();
        result = result * 59 + ($keys == null ? 43 : ((Object)$keys).hashCode());
        return result;
    }

    public String toString() {
        return "DateAggregationGroup(keys=" + String.valueOf(this.getKeys()) + ")";
    }

    public DateAggregationGroup(Map<DateAggregationKey, DateAggregationValue> keys) {
        this.keys = keys;
    }
}

