/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.Sets;
import jakarta.transaction.Transactional;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.dao.TimeStampUUIDGenerator;
import org.thingsboard.trendz.dao.view.ViewConfigDao;
import org.thingsboard.trendz.domain.definition.view.config.CacheSettings;
import org.thingsboard.trendz.domain.definition.view.config.RuntimeFilterField;
import org.thingsboard.trendz.domain.definition.view.config.SavingCalculatedTelemetrySettings;
import org.thingsboard.trendz.domain.definition.view.config.ViewCollection;
import org.thingsboard.trendz.domain.definition.view.config.ViewConfig;
import org.thingsboard.trendz.domain.definition.view.config.ViewConfigLite;
import org.thingsboard.trendz.domain.definition.view.config.ViewConfigSortingField;
import org.thingsboard.trendz.domain.definition.view.config.ViewConfigTaskStatus;
import org.thingsboard.trendz.domain.definition.view.config.ViewConfigTaskStatusData;
import org.thingsboard.trendz.exception.TrendzException;
import org.thingsboard.trendz.exception.view.EmptySearchFilterException;
import org.thingsboard.trendz.exception.view.TrendzViewException;
import org.thingsboard.trendz.exception.view.ViewCollectionNotFoundException;
import org.thingsboard.trendz.exception.view.ViewCollectionNullIdException;
import org.thingsboard.trendz.exception.view.ViewConfigNotFoundException;
import org.thingsboard.trendz.exception.view.ViewConfigNullIdException;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.ViewCollectionService;
import org.thingsboard.trendz.service.cache.SavingCalculatedTelemetryService;
import org.thingsboard.trendz.service.provider.TbCustomerRelationService;
import org.thingsboard.trendz.service.task.TaskJob;
import org.thingsboard.trendz.service.task.TaskManagementService;
import org.thingsboard.trendz.service.task.TaskService;
import org.thingsboard.trendz.service.task.job.CacheRefreshJob;
import org.thingsboard.trendz.service.task.job.FilterRequestJob;
import org.thingsboard.trendz.service.task.job.SaveTelemetryToTbJob;
import org.thingsboard.trendz.service.task.job.ViewAiSummaryJob;
import org.thingsboard.trendz.service.task.job.ViewReportBuildJob;
import org.thingsboard.trendz.service.task.model.Task;
import org.thingsboard.trendz.service.task.model.TaskConfig;
import org.thingsboard.trendz.service.task.model.TaskReference;
import org.thingsboard.trendz.service.task.model.TaskReferencedEntityType;
import org.thingsboard.trendz.service.task.model.TaskSchedule;
import org.thingsboard.trendz.service.task.model.TaskTtlConfig;
import org.thingsboard.trendz.tools.PaginationPage;
import org.thingsboard.trendz.tools.json.JsonUtils;

@Service
@Transactional
public class ViewConfigService {
    private static final Logger log = LoggerFactory.getLogger(ViewConfigService.class);
    private final ViewConfigDao viewConfigDao;
    private final ViewCollectionService viewCollectionService;
    private final TaskService taskService;
    private final TaskManagementService taskManagementService;
    private final SavingCalculatedTelemetryService savingCalculatedTelemetryService;
    private final TbCustomerRelationService relationService;

    @Autowired
    public ViewConfigService(ViewConfigDao viewConfigDao, ViewCollectionService viewCollectionService, TaskService taskService, TaskManagementService taskManagementService, SavingCalculatedTelemetryService savingCalculatedTelemetryService, TbCustomerRelationService relationService) {
        this.viewConfigDao = viewConfigDao;
        this.viewCollectionService = viewCollectionService;
        this.taskService = taskService;
        this.taskManagementService = taskManagementService;
        this.savingCalculatedTelemetryService = savingCalculatedTelemetryService;
        this.relationService = relationService;
    }

    public PaginationPage<ViewConfigLite> getFavoriteConfigs(JwtSecurityUser user, int page, int pageSize, List<ViewConfigSortingField> sortingFields) {
        Set subCustomers = this.relationService.getAllSubCustomerIds(user);
        return new PaginationPage(this.viewConfigDao.getAllFavorite(user, subCustomers, page, pageSize, sortingFields));
    }

    public boolean addFavoriteConfig(JwtSecurityUser user, UUID configId) {
        Set subCustomers = this.relationService.getAllSubCustomerIds(user);
        ViewConfig viewConfig = (ViewConfig)this.findConfigById(user, configId).orElseThrow(() -> new ViewConfigNotFoundException(configId));
        if (!ViewConfig.checkUserOwnership((ViewConfig)viewConfig, (JwtSecurityUser)user)) {
            throw new TrendzViewException("You can not add to or remove from favorites configs that are not yours");
        }
        this.viewConfigDao.addToFavorite(user, subCustomers, viewConfig.getId());
        return true;
    }

    public boolean removeFavoriteConfig(JwtSecurityUser user, UUID configId) {
        Set subCustomers = this.relationService.getAllSubCustomerIds(user);
        ViewConfig viewConfig = (ViewConfig)this.findConfigById(user, configId).orElseThrow(() -> new ViewConfigNotFoundException(configId));
        if (!ViewConfig.checkUserOwnership((ViewConfig)viewConfig, (JwtSecurityUser)user)) {
            throw new TrendzViewException("You can not add to or remove from favorites configs that are not yours");
        }
        if (!viewConfig.isFavorite()) {
            throw new ViewConfigNotFoundException(configId);
        }
        this.viewConfigDao.removeFromFavorite(user, subCustomers, viewConfig.getId());
        return true;
    }

    public PaginationPage<ViewConfigLite> getAllConfigsByWord(JwtSecurityUser user, String prefix, int page, int pageSize, List<ViewConfigSortingField> sortingFields) {
        if (StringUtils.isEmpty((CharSequence)prefix)) {
            throw new EmptySearchFilterException();
        }
        Set subCustomers = this.relationService.getAllSubCustomerIds(user);
        Page all = this.viewConfigDao.getAllLiteByWord(user, subCustomers, prefix, page, pageSize, sortingFields);
        this.defineViewConfigTaskStatus(user, all);
        return new PaginationPage(all);
    }

    public Set<ViewConfig> getAllConfigs(JwtSecurityUser user) {
        Set subCustomers = this.relationService.getAllSubCustomerIds(user);
        return this.viewConfigDao.getAll(user, subCustomers);
    }

    public PaginationPage<ViewConfigLite> getAllLite(JwtSecurityUser user, int page, int pageSize, List<ViewConfigSortingField> sortingFields) {
        Set subCustomers = this.relationService.getAllSubCustomerIds(user);
        Page all = this.viewConfigDao.getAllLite(user, subCustomers, page, pageSize, sortingFields);
        this.defineViewConfigTaskStatus(user, all);
        return new PaginationPage(all);
    }

    public PaginationPage<ViewConfigLite> getAllLiteByCollection(JwtSecurityUser user, UUID collectionId, int page, int pageSize, List<ViewConfigSortingField> sortingFields) {
        Optional collection;
        if (collectionId == null) {
            throw new ViewCollectionNullIdException();
        }
        if (!collectionId.equals(ViewCollection.ROOT_ID) && (collection = this.viewCollectionService.findById(user, collectionId)).isEmpty()) {
            throw new ViewCollectionNotFoundException(collectionId);
        }
        Set subCustomers = this.relationService.getAllSubCustomerIds(user);
        Page all = this.viewConfigDao.getAllLiteByCollection(user, subCustomers, collectionId, page, pageSize, sortingFields);
        this.defineViewConfigTaskStatus(user, all);
        return new PaginationPage(all);
    }

    public Optional<ViewConfig> findConfigById(JwtSecurityUser user, UUID id) {
        return this.findConfigById(user, id, false);
    }

    public Optional<ViewConfig> findConfigById(JwtSecurityUser user, UUID id, boolean insecure) {
        if (id == null) {
            throw new ViewConfigNullIdException();
        }
        Set subCustomers = this.relationService.getAllSubCustomerIds(user);
        return this.viewConfigDao.findByUserAndId(user, subCustomers, id, insecure);
    }

    public boolean renameConfig(JwtSecurityUser user, UUID id, String newName) {
        ViewConfig config = (ViewConfig)this.findConfigById(user, id).orElseThrow(() -> new ViewConfigNotFoundException(id));
        if (!ViewConfig.checkUserOwnership((ViewConfig)config, (JwtSecurityUser)user)) {
            throw new TrendzViewException("You can rename only your config");
        }
        Set subCustomers = this.relationService.getAllSubCustomerIds(user);
        this.viewConfigDao.rename(newName, user, subCustomers, id);
        return true;
    }

    public ViewConfig saveConfig(JwtSecurityUser user, ViewConfig viewConfig) {
        if (viewConfig.getCollectionId() == null) {
            throw new TrendzViewException("The config must have collection id.");
        }
        UUID collectionId = viewConfig.getCollectionId();
        ViewCollection collection = (ViewCollection)this.viewCollectionService.findById(user, collectionId).orElseThrow(() -> new ViewCollectionNotFoundException(collectionId));
        if (!ViewCollection.checkUserOwnership((ViewCollection)collection, (JwtSecurityUser)user)) {
            throw new TrendzViewException("You can save your config only under own collections");
        }
        String path = this.viewCollectionService.getParentPathById(user, collectionId);
        viewConfig.setParentPath(path);
        if (viewConfig.getId() == null) {
            viewConfig.setCreatedAt(System.currentTimeMillis());
            viewConfig.setId(TimeStampUUIDGenerator.generateId());
            this.replaceViewFieldIds(viewConfig);
        }
        for (RuntimeFilterField filter : viewConfig.getRuntimeFilters()) {
            if (filter.getOptions() != null) {
                filter.setOptions(filter.getOptions().stream().limit(200L).collect(Collectors.toSet()));
            }
            if (filter.getSelection() == null) continue;
            filter.setSelection(filter.getSelection().stream().limit(200L).collect(Collectors.toSet()));
        }
        this.validateViewConfigSave(user, viewConfig);
        viewConfig.setUpdatedAt(System.currentTimeMillis());
        ViewConfig savedConfig = this.viewConfigDao.save(user, viewConfig);
        this.processViewReportBuildingTask(user, savedConfig);
        this.processFilterOptionTask(user, savedConfig);
        this.processAiSummaryTask(user, savedConfig);
        this.processCachingTask(user, savedConfig);
        this.processSavingCalculatedTelemetryTask(user, savedConfig);
        return savedConfig;
    }

    public ViewConfigLite duplicateConfig(JwtSecurityUser user, UUID id, String newName) {
        ViewConfig config = (ViewConfig)this.findConfigById(user, id).orElseThrow(() -> new ViewConfigNotFoundException(id));
        if (!ViewConfig.checkUserOwnership((ViewConfig)config, (JwtSecurityUser)user)) {
            throw new TrendzViewException("You can duplicate only your config");
        }
        ViewConfig duplicated = this.duplicate(config, newName, user);
        ViewConfig savedDuplicate = this.viewConfigDao.save(user, duplicated);
        return ViewConfigLite.builder().id(savedDuplicate.getId()).tenantId(savedDuplicate.getTenantId()).customerId(savedDuplicate.getCustomerId()).collectionId(savedDuplicate.getCollectionId()).name(savedDuplicate.getName()).viewType(savedDuplicate.getViewType()).createdAt(savedDuplicate.getCreatedAt()).updatedAt(savedDuplicate.getUpdatedAt()).taskStatus(ViewConfigTaskStatus.NO_TASKS).favorite(false).build();
    }

    public boolean moveConfig(JwtSecurityUser user, UUID configId, UUID parentCollectionId) {
        if (configId == null) {
            throw new ViewConfigNullIdException();
        }
        return this.moveConfigSet(user, Set.of(configId), parentCollectionId);
    }

    public boolean moveConfigSet(JwtSecurityUser user, Set<UUID> configIdSet, UUID parentCollectionId) {
        if (configIdSet.isEmpty()) {
            return true;
        }
        Set subCustomers = this.relationService.getAllSubCustomerIds(user);
        Set foundViewConfigs = this.viewConfigDao.getAllLiteByIdSet(user, subCustomers, configIdSet);
        foundViewConfigs.forEach(viewConfigLite -> {
            if (!ViewConfig.checkUserOwnership((ViewConfigLite)viewConfigLite, (JwtSecurityUser)user)) {
                throw new TrendzViewException("You can move only your config");
            }
        });
        Set foundIdSet = foundViewConfigs.stream().map(ViewConfigLite::getId).collect(Collectors.toSet());
        if (!configIdSet.equals(foundIdSet)) {
            Sets.SetView difference = Sets.difference(configIdSet, foundIdSet);
            throw new ViewConfigNotFoundException((UUID)difference.iterator().next());
        }
        ViewCollection newParent = (ViewCollection)this.viewCollectionService.findById(user, parentCollectionId).orElseThrow(() -> new ViewCollectionNotFoundException(parentCollectionId));
        if (!ViewCollection.checkUserOwnership((ViewCollection)newParent, (JwtSecurityUser)user)) {
            throw new TrendzViewException("User can move elements only to own collection.");
        }
        boolean atLeastOneToAnotherDirectory = foundViewConfigs.stream().anyMatch(collection -> !collection.getCollectionId().equals(parentCollectionId));
        if (!atLeastOneToAnotherDirectory) {
            throw new TrendzViewException("User trying to move element to the same collection.");
        }
        String parentPath = this.viewCollectionService.getParentPathById(user, parentCollectionId);
        this.viewConfigDao.moveByIdSetAndParent(user, subCustomers, configIdSet, parentCollectionId);
        this.viewConfigDao.setParentPathByParentId(user, subCustomers, parentCollectionId, parentPath);
        return true;
    }

    public boolean deleteConfig(JwtSecurityUser user, UUID configId) {
        if (configId == null) {
            throw new ViewConfigNullIdException();
        }
        return this.deleteConfigSet(user, Set.of(configId));
    }

    public boolean deleteConfigSet(JwtSecurityUser user, Set<UUID> idSet) {
        if (idSet.isEmpty()) {
            return true;
        }
        Set subCustomers = this.relationService.getAllSubCustomerIds(user);
        Set foundViewConfigs = this.viewConfigDao.getAllLiteByIdSet(user, subCustomers, idSet);
        foundViewConfigs.forEach(viewConfigLite -> {
            if (!ViewConfig.checkUserOwnership((ViewConfigLite)viewConfigLite, (JwtSecurityUser)user)) {
                throw new TrendzViewException("You can delete only your config");
            }
        });
        Set foundIdSet = foundViewConfigs.stream().map(ViewConfigLite::getId).collect(Collectors.toSet());
        if (!idSet.equals(foundIdSet)) {
            Sets.SetView difference = Sets.difference(idSet, foundIdSet);
            throw new ViewConfigNotFoundException((UUID)difference.iterator().next());
        }
        foundViewConfigs.forEach(viewConfigLite -> this.removeTasks(user, viewConfigLite.getId()));
        this.viewConfigDao.deleteByIdSet(user, subCustomers, idSet);
        return true;
    }

    private void validateViewConfigSave(JwtSecurityUser user, ViewConfig viewConfig) {
        SavingCalculatedTelemetrySettings settings = viewConfig.getSavingCalculatedTelemetrySettings();
        if (settings != null && settings.isEnable()) {
            this.savingCalculatedTelemetryService.validateViewConfig(user, viewConfig);
        }
    }

    private void processViewReportBuildingTask(JwtSecurityUser user, ViewConfig viewConfig) {
        String taskName = "View config, build: " + viewConfig.getName();
        ViewReportBuildJob taskJob = new ViewReportBuildJob();
        TaskReference reference = new TaskReference(TaskReferencedEntityType.VIEW_CONFIG_BUILD_VIEW, viewConfig.getId().toString());
        this.taskManagementService.createOrUpdateTask(user, reference, taskName, (TaskJob)taskJob);
    }

    private void processFilterOptionTask(JwtSecurityUser user, ViewConfig viewConfig) {
        String taskName = "View config, filter: " + viewConfig.getName();
        FilterRequestJob taskJob = new FilterRequestJob();
        TaskReference reference = new TaskReference(TaskReferencedEntityType.VIEW_CONFIG_FILTER_REQUEST, viewConfig.getId().toString());
        Consumer<TaskConfig> onAny = taskConfig -> taskConfig.setTtlConfig(new TaskTtlConfig(true, 60000L));
        this.taskManagementService.createOrUpdateTask(user, reference, taskName, (TaskJob)taskJob, onAny);
    }

    private void processAiSummaryTask(JwtSecurityUser user, ViewConfig viewConfig) {
        String taskName = "View config, AI summary: " + viewConfig.getName();
        ViewAiSummaryJob taskJob = new ViewAiSummaryJob();
        TaskReference reference = new TaskReference(TaskReferencedEntityType.VIEW_CONFIG_AI_SUMMARY_TASK, viewConfig.getId().toString());
        this.taskManagementService.createOrUpdateTask(user, reference, taskName, (TaskJob)taskJob);
    }

    private void processCachingTask(JwtSecurityUser user, ViewConfig viewConfig) {
        CacheSettings cacheSettings = viewConfig.getCacheSettings();
        TaskSchedule schedule = this.taskService.makeSchedulingConfig(cacheSettings.getRefreshFrequencyTimeUnitCount(), cacheSettings.getRefreshFrequencyTimeUnit(), false, viewConfig.getTzName());
        TaskReference reference = new TaskReference(TaskReferencedEntityType.VIEW_CONFIG_CACHE_TASK, viewConfig.getId().toString());
        String taskName = "View config, cache: " + viewConfig.getName();
        CacheRefreshJob taskJob = new CacheRefreshJob();
        Consumer<TaskConfig> onAny = taskConfig -> {
            taskConfig.setEnabled(Boolean.valueOf(cacheSettings.isAutoRefreshCache()));
            taskConfig.setSchedule(schedule);
        };
        Consumer<TaskConfig> onCreate = taskConfig -> taskConfig.setJob((TaskJob)CacheRefreshJob.builder().viewConfigId(viewConfig.getId()).lastRefreshTime(viewConfig.getDatePickerConfig().getStartTs()).build());
        BiConsumer<Task, TaskConfig> onUpdate = (task, taskConfig) -> {
            CacheRefreshJob job = (CacheRefreshJob)task.getJob();
            job.setLastRefreshTime(viewConfig.getDatePickerConfig().getStartTs());
            taskConfig.setJob((TaskJob)job);
        };
        this.taskManagementService.createOrUpdateTask(user, reference, taskName, (TaskJob)taskJob, onAny, onUpdate, onCreate);
    }

    private void processSavingCalculatedTelemetryTask(JwtSecurityUser user, ViewConfig viewConfig) {
        SavingCalculatedTelemetrySettings settings = viewConfig.getSavingCalculatedTelemetrySettings();
        TaskSchedule schedule = this.taskService.makeSchedulingConfig(settings.getExecutionTimeUnitCount(), settings.getExecutionTimeUnit(), false, viewConfig.getTzName());
        TaskReference reference = new TaskReference(TaskReferencedEntityType.VIEW_CONFIG_SAVE_TO_TB_TASK, viewConfig.getId().toString());
        String taskName = "View config, save to TB: " + viewConfig.getName();
        SaveTelemetryToTbJob taskJob = new SaveTelemetryToTbJob();
        Consumer<TaskConfig> onAny = taskConfig -> {
            taskConfig.setEnabled(Boolean.valueOf(settings.isEnable()));
            taskConfig.setSchedule(schedule);
        };
        Consumer<TaskConfig> onCreate = taskConfig -> taskConfig.setJob((TaskJob)SaveTelemetryToTbJob.builder().viewConfigId(viewConfig.getId()).lastExecutionTime(viewConfig.getDatePickerConfig().getStartTs()).build());
        BiConsumer<Task, TaskConfig> onUpdate = (task, taskConfig) -> {
            SaveTelemetryToTbJob job = (SaveTelemetryToTbJob)task.getJob();
            job.setLastExecutionTime(viewConfig.getDatePickerConfig().getStartTs());
            taskConfig.setJob((TaskJob)job);
        };
        this.taskManagementService.createOrUpdateTask(user, reference, taskName, (TaskJob)taskJob, onAny, onUpdate, onCreate);
    }

    private void removeTasks(JwtSecurityUser user, UUID viewConfigId) {
        Stream.of(TaskReferencedEntityType.VIEW_CONFIG_BUILD_VIEW, TaskReferencedEntityType.VIEW_CONFIG_FILTER_REQUEST, TaskReferencedEntityType.VIEW_CONFIG_AI_SUMMARY_TASK, TaskReferencedEntityType.VIEW_CONFIG_CACHE_TASK, TaskReferencedEntityType.VIEW_CONFIG_SAVE_TO_TB_TASK).forEach(entityType -> this.taskManagementService.deleteByTaskReference(user, new TaskReference(entityType, viewConfigId.toString())));
    }

    private ViewConfig duplicate(ViewConfig config, String newName, JwtSecurityUser user) {
        long now = System.currentTimeMillis();
        ViewConfig duplicated = new ViewConfig(config);
        duplicated.setId(TimeStampUUIDGenerator.generateId());
        duplicated.setName(newName);
        duplicated.setTenantId(user.getTenantId());
        duplicated.setCustomerId(user.getCustomerId());
        duplicated.setCreatedAt(now);
        duplicated.setUpdatedAt(now);
        HashMap oldToNewMap = new HashMap();
        duplicated.getXAxis().forEach(viewField -> {
            UUID uuid = TimeStampUUIDGenerator.generateId();
            oldToNewMap.put(viewField.getId(), uuid);
            viewField.setId(uuid);
        });
        duplicated.getYAxis().forEach(viewField -> {
            UUID uuid = TimeStampUUIDGenerator.generateId();
            oldToNewMap.put(viewField.getId(), uuid);
            viewField.setId(uuid);
        });
        duplicated.getSeries().forEach(viewField -> {
            UUID uuid = TimeStampUUIDGenerator.generateId();
            oldToNewMap.put(viewField.getId(), uuid);
            viewField.setId(uuid);
        });
        duplicated.getHiddenFields().forEach(viewField -> {
            UUID uuid = TimeStampUUIDGenerator.generateId();
            oldToNewMap.put(viewField.getId(), uuid);
            viewField.setId(uuid);
        });
        duplicated.getRuntimeFilters().forEach(filterField -> {
            UUID newId = (UUID)oldToNewMap.get(filterField.getViewFieldId());
            filterField.setViewFieldId(newId);
        });
        return duplicated;
    }

    private void defineViewConfigTaskStatus(JwtSecurityUser user, Page<ViewConfigLite> configLites) {
        UUID tenantId = user.getTenantId();
        Set idSet = configLites.stream().map(ViewConfigLite::getId).collect(Collectors.toSet());
        List viewConfigStatusData = this.taskService.getViewConfigStatusData(tenantId, idSet);
        Map idToDataMap = viewConfigStatusData.stream().collect(Collectors.toMap(ViewConfigTaskStatusData::getViewConfigId, Function.identity()));
        for (ViewConfigLite configLite : configLites) {
            UUID viewConfigId = configLite.getId();
            ViewConfigTaskStatusData statusData = (ViewConfigTaskStatusData)idToDataMap.get(viewConfigId);
            if (statusData.contains("RUNNING")) {
                configLite.setTaskStatus(ViewConfigTaskStatus.RUNNING);
                continue;
            }
            if (statusData.contains("FAILED") || statusData.contains("LOST")) {
                configLite.setTaskStatus(ViewConfigTaskStatus.FAILED);
                continue;
            }
            if (statusData.contains("CANCELED")) {
                configLite.setTaskStatus(ViewConfigTaskStatus.CANCELLED);
                continue;
            }
            if (statusData.contains("FINISHED")) {
                configLite.setTaskStatus(ViewConfigTaskStatus.SUCCESS);
                continue;
            }
            if (statusData.contains("CREATED") || statusData.contains("NO_EXECUTION")) {
                configLite.setTaskStatus(ViewConfigTaskStatus.INITIALIZED);
                continue;
            }
            if (statusData.contains("NO_TASK_REFERENCE") || statusData.contains("NO_TASK_FOUND")) {
                configLite.setTaskStatus(ViewConfigTaskStatus.NO_TASKS);
                continue;
            }
            throw new TrendzException("Undefined state of view config tasks");
        }
    }

    private void replaceViewFieldIds(ViewConfig viewConfig) {
        List fields = viewConfig.getAllFields();
        HashMap oldIdMap = new HashMap();
        fields.forEach(f -> {
            UUID oldId = f.getId();
            UUID newId = TimeStampUUIDGenerator.generateId();
            if (oldId == null) {
                throw new TrendzViewException("The view config has view field with null id");
            }
            oldIdMap.put(oldId, newId);
            f.setId(newId);
        });
        if (CollectionUtils.isNotEmpty((Collection)viewConfig.getRuntimeFilters())) {
            viewConfig.getRuntimeFilters().forEach(rf -> {
                UUID updatedId = (UUID)oldIdMap.get(rf.getViewFieldId());
                if (updatedId != null) {
                    rf.setViewFieldId(updatedId);
                }
            });
        }
        JsonNode settingsNode = viewConfig.getSettings();
        Set<String> mapKeys = Set.of("customFormatterMap", "decimalPointMap", "enableAutoFormattingMap", "paletteColorMap", "unitsRoundtMap");
        for (String mapKey : mapKeys) {
            JsonNode mapNode = settingsNode.get(mapKey);
            if (mapNode == null || !mapNode.isObject()) continue;
            ObjectNode newMapNode = JsonUtils.getObjectMapper().createObjectNode();
            Iterator mapFields = mapNode.fields();
            while (mapFields.hasNext()) {
                Map.Entry entry = (Map.Entry)mapFields.next();
                UUID oldKey = UUID.fromString((String)entry.getKey());
                UUID newKey = (UUID)oldIdMap.get(oldKey);
                if (newKey == null) continue;
                newMapNode.set(newKey.toString(), (JsonNode)entry.getValue());
            }
            ((ObjectNode)settingsNode).set(mapKey, (JsonNode)newMapNode);
        }
    }
}

