/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service;

import com.google.common.collect.Sets;
import jakarta.transaction.Transactional;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import java.util.UUID;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.dao.view.ViewCollectionDao;
import org.thingsboard.trendz.dao.view.ViewConfigDao;
import org.thingsboard.trendz.domain.definition.view.config.ViewCollection;
import org.thingsboard.trendz.exception.view.TrendzViewException;
import org.thingsboard.trendz.exception.view.ViewCollectionNotFoundException;
import org.thingsboard.trendz.exception.view.ViewCollectionNullIdException;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.provider.TbCustomerRelationService;

@Service
@Transactional
public class ViewCollectionService {
    private static final Logger log = LoggerFactory.getLogger(ViewCollectionService.class);
    private final TbCustomerRelationService relationService;
    private final ViewCollectionDao viewCollectionDao;
    private final ViewConfigDao viewConfigDao;

    @Autowired
    public ViewCollectionService(TbCustomerRelationService relationService, ViewCollectionDao viewCollectionDao, ViewConfigDao viewConfigDao) {
        this.relationService = relationService;
        this.viewCollectionDao = viewCollectionDao;
        this.viewConfigDao = viewConfigDao;
    }

    public Set<ViewCollection> getAllCollectionsByPrefix(JwtSecurityUser user, String prefix) {
        Set subCustomers = this.relationService.getAllSubCustomerIds(user);
        return this.viewCollectionDao.findAllByPrefix(user, subCustomers, prefix);
    }

    public Set<ViewCollection> getAllCollections(JwtSecurityUser user) {
        Set subCustomers = this.relationService.getAllSubCustomerIds(user);
        return this.viewCollectionDao.findAll(user, subCustomers);
    }

    public Set<ViewCollection> getAllCollectionsByParent(JwtSecurityUser user, UUID parentId) {
        if (parentId == null) {
            throw new ViewCollectionNullIdException();
        }
        return this.getAllCollectionsByParentSet(user, Set.of(parentId));
    }

    public Set<ViewCollection> getAllCollectionsByParentSet(JwtSecurityUser user, Set<UUID> parentIdSet) {
        Set allCollections;
        Set actualIdSet;
        if (parentIdSet.isEmpty()) {
            return Collections.emptySet();
        }
        Set subCustomers = this.relationService.getAllSubCustomerIds(user);
        Sets.SetView expectedIdSet = Sets.difference(parentIdSet, Set.of(ViewCollection.ROOT_ID));
        if (!expectedIdSet.isEmpty() && !expectedIdSet.equals(actualIdSet = (allCollections = this.viewCollectionDao.findAllByIdSet(user, subCustomers, (Set)expectedIdSet)).stream().map(ViewCollection::getId).collect(Collectors.toSet()))) {
            Sets.SetView difference = Sets.difference((Set)expectedIdSet, actualIdSet);
            throw new ViewCollectionNotFoundException((UUID)difference.iterator().next());
        }
        return this.viewCollectionDao.findAllByParentCollectionSet(user, subCustomers, parentIdSet);
    }

    public Optional<ViewCollection> findById(JwtSecurityUser user, UUID id) {
        if (id == null) {
            throw new ViewCollectionNullIdException();
        }
        if (id.equals(ViewCollection.ROOT_ID)) {
            return Optional.of(ViewCollection.getRootCollection((JwtSecurityUser)user));
        }
        Set subCustomers = this.relationService.getAllSubCustomerIds(user);
        return this.viewCollectionDao.findByIdAndUserSet(user, subCustomers, id);
    }

    public boolean renameCollection(JwtSecurityUser user, UUID id, String newName) {
        if (ViewCollection.ROOT_ID.equals(id)) {
            throw new TrendzViewException("User can not rename root collection");
        }
        ViewCollection collection = (ViewCollection)this.findById(user, id).orElseThrow(() -> new ViewCollectionNotFoundException(id));
        if (!ViewCollection.checkUserOwnership((ViewCollection)collection, (JwtSecurityUser)user)) {
            throw new TrendzViewException("User can rename only own collection.");
        }
        Set subCustomers = this.relationService.getAllSubCustomerIds(user);
        this.viewCollectionDao.renameById(newName, user, subCustomers, id);
        this.updateParentPathForAllSubConfigs(user, Set.of(id));
        return true;
    }

    public ViewCollection saveCollection(JwtSecurityUser user, ViewCollection collection) {
        if (ViewCollection.ROOT_ID.equals(collection.getId())) {
            throw new TrendzViewException("Saving root collection is not allowed!");
        }
        ViewCollection parent = (ViewCollection)this.findById(user, collection.getParentId()).orElseThrow(() -> new ViewCollectionNotFoundException(collection.getParentId()));
        if (!ViewCollection.checkUserOwnership((ViewCollection)parent, (JwtSecurityUser)user)) {
            throw new TrendzViewException("User can save collections only under own collection");
        }
        return this.viewCollectionDao.save(user, collection);
    }

    public boolean moveCollection(JwtSecurityUser user, UUID collectionId, UUID parentId) {
        return this.moveCollectionSet(user, Set.of(collectionId), parentId);
    }

    public boolean moveCollectionSet(JwtSecurityUser user, Set<UUID> collectionIdSet, UUID parentId) {
        if (collectionIdSet.isEmpty()) {
            return true;
        }
        if (collectionIdSet.contains(ViewCollection.ROOT_ID)) {
            throw new TrendzViewException("Moving root collection is not allowed!");
        }
        Set subCustomers = this.relationService.getAllSubCustomerIds(user);
        Set foundViewCollections = this.viewCollectionDao.findAllByIdSet(user, subCustomers, collectionIdSet);
        foundViewCollections.forEach(viewCollection -> {
            if (!ViewCollection.checkUserOwnership((ViewCollection)viewCollection, (JwtSecurityUser)user)) {
                throw new TrendzViewException("User can move only own collection.");
            }
        });
        Set foundIdSet = foundViewCollections.stream().map(ViewCollection::getId).collect(Collectors.toSet());
        if (!collectionIdSet.equals(foundIdSet)) {
            Sets.SetView difference = Sets.difference(collectionIdSet, foundIdSet);
            throw new ViewCollectionNotFoundException((UUID)difference.iterator().next());
        }
        ViewCollection newParent = (ViewCollection)this.viewCollectionDao.findByIdAndUserSet(user, subCustomers, parentId).orElseThrow(() -> new ViewCollectionNotFoundException(parentId));
        if (!ViewCollection.checkUserOwnership((ViewCollection)newParent, (JwtSecurityUser)user)) {
            throw new TrendzViewException("User can move elements only to own collection.");
        }
        if (collectionIdSet.contains(parentId)) {
            throw new TrendzViewException("User can not move collection to itself.");
        }
        boolean atLeastOneToAnotherDirectory = foundViewCollections.stream().anyMatch(collection -> !collection.getParentId().equals(parentId));
        if (!atLeastOneToAnotherDirectory) {
            throw new TrendzViewException("User trying to move element to the same collection.");
        }
        this.viewCollectionDao.moveByIdSetAndParent(user, subCustomers, collectionIdSet, parentId);
        this.updateParentPathForAllSubConfigs(user, collectionIdSet);
        return true;
    }

    public boolean deleteCollection(JwtSecurityUser user, UUID id) {
        if (id == null) {
            throw new ViewCollectionNullIdException();
        }
        return this.deleteCollectionSet(user, Set.of(id));
    }

    public boolean deleteCollectionSet(JwtSecurityUser user, Set<UUID> idSet) {
        if (idSet.isEmpty()) {
            return true;
        }
        if (idSet.contains(ViewCollection.ROOT_ID)) {
            throw new TrendzViewException("Deletion root collection is not allowed!");
        }
        Set subCustomers = this.relationService.getAllSubCustomerIds(user);
        Set foundViewCollections = this.viewCollectionDao.findAllByIdSet(user, subCustomers, idSet);
        foundViewCollections.forEach(viewCollection -> {
            if (!ViewCollection.checkUserOwnership((ViewCollection)viewCollection, (JwtSecurityUser)user)) {
                throw new TrendzViewException("User can delete only own collection");
            }
        });
        Set foundIdSet = foundViewCollections.stream().map(ViewCollection::getId).collect(Collectors.toSet());
        if (!idSet.equals(foundIdSet)) {
            Sets.SetView difference = Sets.difference(idSet, foundIdSet);
            throw new ViewCollectionNotFoundException((UUID)difference.iterator().next());
        }
        Set allLiteByCollectionSet = this.viewConfigDao.getAllLiteByCollectionSet(user, subCustomers, idSet);
        if (!allLiteByCollectionSet.isEmpty()) {
            throw new TrendzViewException("You can not delete collection if it stores any configs.");
        }
        Set allCollectionsByParentSet = this.getAllCollectionsByParentSet(user, idSet);
        if (!allCollectionsByParentSet.isEmpty()) {
            throw new TrendzViewException("You can not delete collection if it stores any collection.");
        }
        this.viewCollectionDao.deleteByIdSet(user, subCustomers, idSet);
        return true;
    }

    public List<String> getParentPathListById(JwtSecurityUser user, UUID id) {
        if (ViewCollection.ROOT_ID.equals(id)) {
            return new ArrayList<String>();
        }
        ViewCollection collection = (ViewCollection)this.findById(user, id).orElseThrow(() -> new ViewCollectionNotFoundException(id));
        Set subCustomers = this.relationService.getAllSubCustomerIds(user);
        return this.viewCollectionDao.getParentPathById(user, subCustomers, id);
    }

    public String getParentPathById(JwtSecurityUser user, UUID id) {
        List pathList = this.getParentPathListById(user, id);
        return pathList.stream().reduce((o1, o2) -> o1 + "/" + o2).map(p -> "/" + p).orElse("/");
    }

    private void updateParentPathForAllSubConfigs(JwtSecurityUser user, Set<UUID> collectionIdSet) {
        Set subCustomers = this.relationService.getAllSubCustomerIds(user);
        Set allCollectionSet = this.viewCollectionDao.findAll(user, subCustomers);
        Map<UUID, String> idToNameMap = allCollectionSet.stream().collect(Collectors.toMap(ViewCollection::getId, ViewCollection::getName));
        Map<UUID, UUID> idToParentIdMap = allCollectionSet.stream().collect(Collectors.toMap(ViewCollection::getId, ViewCollection::getParentId));
        Map idToChildrenListMap = allCollectionSet.stream().collect(Collectors.groupingBy(ViewCollection::getParentId, Collectors.mapping(ViewCollection::getId, Collectors.toSet())));
        LinkedList<UUID> neededCollectionIdList = new LinkedList<UUID>();
        try {
            LinkedList<UUID> l1 = new LinkedList<UUID>(collectionIdSet);
            LinkedList l2 = new LinkedList();
            do {
                for (UUID id : l1) {
                    Set childrenIdSet = idToChildrenListMap.get(id);
                    if (childrenIdSet == null) continue;
                    l2.addAll(childrenIdSet);
                }
                neededCollectionIdList.addAll(l1);
                l1 = l2;
                l2 = new LinkedList();
            } while (!l1.isEmpty());
        }
        catch (Exception e) {
            throw new RuntimeException("Error during collecting affected collections!", e);
        }
        HashMap<UUID, CallSite> idToPath = new HashMap<UUID, CallSite>();
        try {
            Stack<UUID> iterationStack = new Stack<UUID>();
            neededCollectionIdList.forEach(iterationStack::push);
            while (!iterationStack.empty()) {
                UUID id = (UUID)iterationStack.peek();
                UUID parentId = idToParentIdMap.get(id);
                String name = idToNameMap.get(id);
                if (parentId.equals(ViewCollection.ROOT_ID)) {
                    String result = "/" + name;
                    idToPath.put(id, (CallSite)((Object)result));
                    iterationStack.pop();
                    continue;
                }
                String parentResult = (String)idToPath.get(parentId);
                if (parentResult == null) {
                    iterationStack.push(parentId);
                    continue;
                }
                String result = parentResult + "/" + name;
                idToPath.put(id, (CallSite)((Object)result));
                iterationStack.pop();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error during generating new parent paths!", e);
        }
        for (UUID collectionId : neededCollectionIdList) {
            String newPath = (String)idToPath.get(collectionId);
            this.viewConfigDao.setParentPathByParentId(user, subCustomers, collectionId, newPath);
        }
    }
}

