/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.security.service;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.Jwt;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.impl.DefaultClaims;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Base64;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.stereotype.Component;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.security.Authority;
import org.thingsboard.trendz.security.entity.AuthToken;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.security.entity.SecurityUser;
import org.thingsboard.trendz.tools.json.JsonUtils;

@Component
public class TokenExtractor {
    private static final Logger log = LoggerFactory.getLogger(TokenExtractor.class);
    public static final String JWT_TOKEN__PROPERTY_NAME = "jwt";
    public static final String API_TOKEN__PROPERTY_NAME = "api-token";

    public String extractJwtToken(HttpServletRequest request) {
        return this.extract(request, JWT_TOKEN__PROPERTY_NAME);
    }

    public String extractApiToken(HttpServletRequest request) {
        return this.extract(request, API_TOKEN__PROPERTY_NAME);
    }

    public JwtSecurityUser extractUser(String rawToken) {
        try {
            String[] splitToken = rawToken.split("\\.");
            String bodyString = new String(Base64.getUrlDecoder().decode(splitToken[1]));
            Claims body = (Claims)JsonUtils.getObjectMapper().readValue(bodyString, DefaultClaims.class);
            String tenantIdRaw = (String)body.get("tenantId", String.class);
            String customerIdRaw = (String)body.get("customerId", String.class);
            String userIdRaw = (String)body.get("userId", String.class);
            UUID tenantId = StringUtils.isNotBlank((CharSequence)tenantIdRaw) ? UUID.fromString(tenantIdRaw) : EntityId.NULL_UUID;
            UUID customerId = StringUtils.isNotBlank((CharSequence)customerIdRaw) ? UUID.fromString(customerIdRaw) : EntityId.NULL_UUID;
            UUID userId = StringUtils.isNotBlank((CharSequence)userIdRaw) ? UUID.fromString(userIdRaw) : EntityId.NULL_UUID;
            return new JwtSecurityUser(tenantId, customerId, userId);
        }
        catch (Exception ex) {
            log.error("Invalid JWT Token", (Throwable)ex);
            throw new BadCredentialsException("Invalid JWT token: ", (Throwable)ex);
        }
    }

    public SecurityUser parseAccessJwtToken(AuthToken authToken) {
        try {
            String userId;
            String customerId;
            String[] splitToken = authToken.getToken().split("\\.");
            String unsignedToken = splitToken[0] + "." + splitToken[1] + ".";
            Jwt jwtClaims = Jwts.parser().parseClaimsJwt(unsignedToken);
            Claims claims = (Claims)jwtClaims.getBody();
            String subject = claims.getSubject();
            List scopes = (List)claims.get("scopes", List.class);
            if (scopes == null || scopes.isEmpty()) {
                throw new IllegalArgumentException("JWT Token doesn't have any scopes");
            }
            SecurityUser securityUser = new SecurityUser();
            securityUser.setAuthToken(authToken);
            securityUser.setEmail(subject);
            securityUser.setAuthority(Authority.parse((String)((String)scopes.get(0))));
            String tenantId = (String)claims.get("tenantId", String.class);
            if (tenantId != null) {
                securityUser.setTenantId(UUID.fromString(tenantId));
            }
            if ((customerId = (String)claims.get("customerId", String.class)) != null) {
                securityUser.setCustomerId(UUID.fromString(customerId));
            }
            if ((userId = (String)claims.get("userId", String.class)) != null) {
                securityUser.setUserId(UUID.fromString(userId));
            }
            if (Authority.SYS_ADMIN.equals((Object)securityUser.getAuthority())) {
                throw new BadCredentialsException("Please use Tenant or Customer user credentials instead of System Administrator");
            }
            return securityUser;
        }
        catch (ExpiredJwtException ex) {
            throw new BadCredentialsException("Token expired");
        }
        catch (IllegalArgumentException iae) {
            throw new BadCredentialsException("Illegal arguments: %s".formatted(iae.getMessage()), (Throwable)iae);
        }
        catch (Exception ex) {
            throw new BadCredentialsException("Unexpected jwt token", (Throwable)ex);
        }
    }

    private String extract(HttpServletRequest request, String propertyName) {
        String header = this.extractFromHeader(request, propertyName);
        if (StringUtils.isBlank((CharSequence)header)) {
            return this.extractFromQuery(request, propertyName);
        }
        return header;
    }

    private String extractFromHeader(HttpServletRequest request, String propertyName) {
        return request.getHeader(propertyName);
    }

    private String extractFromQuery(HttpServletRequest request, String propertyName) {
        String[] tokenParamValue;
        String token = null;
        if (request.getParameterMap() != null && !request.getParameterMap().isEmpty() && (tokenParamValue = (String[])request.getParameterMap().get(propertyName)) != null && tokenParamValue.length == 1) {
            token = tokenParamValue[0];
        }
        return token;
    }
}

