/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.security.service;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jwt;
import io.jsonwebtoken.JwtException;
import io.jsonwebtoken.Jwts;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.Cache;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.dao.system.ApplicationPropertyDao;
import org.thingsboard.trendz.domain.definition.ApplicationProperty;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.security.jwt.JwtSettings;
import org.thingsboard.trendz.security.jwt.JwtTokenBuilder;
import org.thingsboard.trendz.service.provider.TbRestDataSource;
import org.thingsboard.trendz.service.provider.cache.CacheConfigurationName;
import org.thingsboard.trendz.service.provider.cache.CacheService;
import org.thingsboard.trendz.tools.DonReactive;
import reactor.core.publisher.Mono;

@Service
public class AuthenticationService {
    private static final Logger log = LoggerFactory.getLogger(AuthenticationService.class);
    private static final Duration MARGIN = Duration.ofSeconds(30L);
    private final Cache tokenCache;
    private final Cache tokenValidationCache;
    private final JwtTokenBuilder jwtTokenBuilder;
    private final TbRestDataSource tbRestDataSource;
    private final ApplicationPropertyDao applicationPropertyDao;
    private final JwtSettings jwtSettings;

    @Autowired
    public AuthenticationService(CacheService cacheService, JwtTokenBuilder jwtTokenBuilder, TbRestDataSource tbRestDataSource, ApplicationPropertyDao applicationPropertyDao, JwtSettings jwtSettings) {
        this.tokenCache = cacheService.getCache(CacheConfigurationName.jwtTokenCacheName);
        this.tokenValidationCache = cacheService.getCache(CacheConfigurationName.jwtTokenValidationCacheName);
        this.jwtTokenBuilder = jwtTokenBuilder;
        this.tbRestDataSource = tbRestDataSource;
        this.applicationPropertyDao = applicationPropertyDao;
        this.jwtSettings = jwtSettings;
    }

    public void cacheToken(JwtSecurityUser user, String jwtToken) {
        this.tokenCache.put((Object)user, (Object)jwtToken);
    }

    public String getToken(JwtSecurityUser user) {
        String jwtToken = (String)this.tokenCache.get((Object)user, () -> this.createTokenFromSigningKey(user));
        if (jwtToken == null || !this.validateTokenUnsigned(jwtToken)) {
            String newToken = this.createTokenFromSigningKey(user);
            this.tokenCache.put((Object)user, (Object)newToken);
            return newToken;
        }
        return jwtToken;
    }

    public boolean validateToken(String jwtToken) {
        Boolean valid = (Boolean)this.tokenValidationCache.get((Object)jwtToken, () -> (Boolean)DonReactive.block((Mono)this.tbRestDataSource.checkTokenIsValid(jwtToken), (Duration)Duration.of(1L, ChronoUnit.MINUTES)));
        return Boolean.TRUE.equals(valid);
    }

    public boolean validateTokenUnsigned(String jwtToken) {
        try {
            String[] parts = jwtToken.split("\\.");
            if (parts.length < 2) {
                return false;
            }
            String unsigned = parts[0] + "." + parts[1] + ".";
            Jwt jwt = Jwts.parser().parseClaimsJwt(unsigned);
            Instant exp = ((Claims)jwt.getBody()).getExpiration().toInstant();
            return Instant.now().plus(MARGIN).isBefore(exp);
        }
        catch (JwtException | IllegalArgumentException e) {
            return false;
        }
    }

    public String createTokenFromSigningKey(JwtSecurityUser user) {
        String signingKey = this.applicationPropertyDao.getPropertyByKey("signing_key").map(ApplicationProperty::getValue).orElse(this.jwtSettings.getTokenSigningKey());
        JwtSettings settings = new JwtSettings(this.jwtSettings);
        settings.setTokenSigningKey(signingKey);
        return this.jwtTokenBuilder.buildToken(user, settings);
    }
}

