/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.security.service;

import jakarta.transaction.Transactional;
import java.util.Optional;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.dao.TimeStampUUIDGenerator;
import org.thingsboard.trendz.dao.apikey.ApiKeyDao;
import org.thingsboard.trendz.domain.apikey.ApiKey;
import org.thingsboard.trendz.domain.customize.UserRecord;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.customize.UserManagementService;

@Service
public class ApiKeyService {
    private static final Logger log = LoggerFactory.getLogger(ApiKeyService.class);
    private final UserManagementService userManagementService;
    private final ApiKeyDao apiKeyDao;
    private final PasswordEncoder passwordEncoder;

    @Autowired
    public ApiKeyService(UserManagementService userManagementService, ApiKeyDao apiKeyDao, PasswordEncoder passwordEncoder) {
        this.userManagementService = userManagementService;
        this.apiKeyDao = apiKeyDao;
        this.passwordEncoder = passwordEncoder;
    }

    @Transactional
    public void generateApiKey(UUID tenantId) {
        this.apiKeyDao.findByTenantId(tenantId).ifPresentOrElse(apiKey -> log.debug("The API key for tenant [{}] is already generated", (Object)tenantId), () -> {
            this.refreshApiKey(tenantId);
            log.info("The API key for tenant [{}] is generated", (Object)tenantId);
        });
    }

    public void refreshApiKey(UUID tenantId) {
        UserRecord userRecord = (UserRecord)this.userManagementService.findFirstTenantUserByTenantId(tenantId).orElseThrow(() -> new RuntimeException("The tenant user is not found"));
        UUID id = this.apiKeyDao.findByTenantId(tenantId).map(ApiKey::getId).orElse(TimeStampUUIDGenerator.generateId());
        String token = this.passwordEncoder.encode((CharSequence)id.toString());
        ApiKey apiKey = ApiKey.builder().id(id).tenantId(userRecord.getUser().getTenantId()).token(token).build();
        this.apiKeyDao.save(apiKey);
    }

    public Optional<JwtSecurityUser> getTenantUserByApiKey(String token) {
        return this.apiKeyDao.findByToken(token).flatMap(apiKey -> this.userManagementService.findFirstTenantUserByTenantId(apiKey.getTenantId())).map(UserRecord::getUser);
    }

    public String getApiKeyByTenantId(UUID tenantId) {
        ApiKey apiKey = (ApiKey)this.apiKeyDao.findByTenantId(tenantId).orElseThrow(() -> new RuntimeException("The API key is not found"));
        return apiKey.getToken();
    }
}

