/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.security.provider;

import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.stereotype.Component;
import org.thingsboard.trendz.security.entity.AuthToken;
import org.thingsboard.trendz.security.service.ApiKeyService;
import org.thingsboard.trendz.security.service.AuthenticationService;
import org.thingsboard.trendz.security.service.TokenExtractor;
import org.thingsboard.trendz.security.token.ApiKeyAuthenticationToken;

@Component
public class ApiTokenAuthenticationProvider
implements AuthenticationProvider {
    private static final Logger log = LoggerFactory.getLogger(ApiTokenAuthenticationProvider.class);
    private final ApiKeyService apiKeyService;
    private final AuthenticationService authenticationService;
    private final TokenExtractor tokenExtractor;

    @Autowired
    public ApiTokenAuthenticationProvider(ApiKeyService apiKeyService, AuthenticationService authenticationService, TokenExtractor tokenExtractor) {
        this.apiKeyService = apiKeyService;
        this.authenticationService = authenticationService;
        this.tokenExtractor = tokenExtractor;
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        String apiToken = (String)authentication.getCredentials();
        return (Authentication)Optional.of(apiToken).flatMap(token -> this.apiKeyService.getTenantUserByApiKey(apiToken)).map(arg_0 -> ((AuthenticationService)this.authenticationService).getToken(arg_0)).map(jwtToken -> new AuthToken(jwtToken, null)).map(arg_0 -> ((TokenExtractor)this.tokenExtractor).parseAccessJwtToken(arg_0)).map(ApiKeyAuthenticationToken::new).orElse(new ApiKeyAuthenticationToken());
    }

    public boolean supports(Class<?> authentication) {
        return ApiKeyAuthenticationToken.class.isAssignableFrom(authentication);
    }
}

