/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.security.jwt;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.trendz.exception.security.JwtTokenException;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.security.jwt.JwtSettings;

@Component
public class JwtTokenBuilder {
    private static final Logger log = LoggerFactory.getLogger(JwtTokenBuilder.class);
    private static final String SCOPES = "scopes";
    private static final String USER_ID = "userId";
    private static final String ENABLED = "enabled";
    private static final String IS_PUBLIC = "isPublic";
    private static final String TENANT_ID = "tenantId";
    private static final String CUSTOMER_ID = "customerId";

    public String buildToken(JwtSecurityUser user, JwtSettings settings) {
        ZonedDateTime currentTime = ZonedDateTime.now();
        String issuer = settings.getTokenIssuer();
        String tokenSigningKey = settings.getTokenSigningKey();
        long tokenExpirationTimeSec = TimeUnit.SECONDS.toSeconds(settings.getTokenExpirationTime().intValue());
        String subject = "trendzJob";
        Claims claims = Jwts.claims().setSubject(subject);
        claims.put((Object)SCOPES, Collections.singletonList(this.getTokenScope(user)));
        claims.put((Object)ENABLED, (Object)true);
        claims.put((Object)IS_PUBLIC, (Object)false);
        claims.put((Object)TENANT_ID, (Object)user.getTenantId().toString());
        if (user.getCustomerId() != null) {
            claims.put((Object)CUSTOMER_ID, (Object)user.getCustomerId().toString());
        }
        if (user.getUserId() != null) {
            claims.put((Object)USER_ID, (Object)user.getUserId().toString());
        }
        String token = Jwts.builder().setClaims(claims).setIssuer(issuer).setIssuedAt(Date.from(currentTime.toInstant())).setExpiration(Date.from(currentTime.plusSeconds(tokenExpirationTimeSec).toInstant())).signWith(SignatureAlgorithm.HS512, tokenSigningKey).compact();
        log.debug("Build jwt-token for {}, token: {}", (Object)user, (Object)token);
        return token;
    }

    private String getTokenScope(JwtSecurityUser user) {
        if (user.getCustomerId() != null && !user.getCustomerId().equals(EntityId.NULL_UUID)) {
            return "CUSTOMER_USER";
        }
        if (user.getTenantId() != null && !user.getTenantId().equals(EntityId.NULL_UUID)) {
            return "TENANT_ADMIN";
        }
        throw new JwtTokenException("Invalid security user for token building");
    }
}

