/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.security.jwt;

import jakarta.annotation.PostConstruct;
import java.nio.charset.StandardCharsets;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.thingsboard.trendz.exception.security.JwtTokenException;
import org.thingsboard.trendz.security.jwt.JwtSettings;

@Configuration
@ConfigurationProperties(prefix="security.jwt")
public class JwtSettings {
    private String tokenIssuer;
    private String tokenSigningKey;
    private Integer tokenExpirationTime;

    public JwtSettings(JwtSettings that) {
        this.tokenIssuer = that.tokenIssuer;
        this.tokenSigningKey = that.tokenSigningKey;
        this.tokenExpirationTime = that.tokenExpirationTime;
    }

    @PostConstruct
    public void init() {
        if (this.tokenSigningKey == null || this.tokenSigningKey.isEmpty()) {
            throw new JwtTokenException("The signing key is invalid: key cannot be null or empty");
        }
        int minimalByteCount = 4;
        byte[] signingKeyBytes = this.tokenSigningKey.getBytes(StandardCharsets.UTF_8);
        if (signingKeyBytes.length < minimalByteCount) {
            String message = String.format("The signing key is invalid: key length for HS512 should be at least %s bytes, current = %s", minimalByteCount, signingKeyBytes.length);
            throw new JwtTokenException(message);
        }
    }

    public static JwtSettingsBuilder builder() {
        return new JwtSettingsBuilder();
    }

    public String getTokenIssuer() {
        return this.tokenIssuer;
    }

    public String getTokenSigningKey() {
        return this.tokenSigningKey;
    }

    public Integer getTokenExpirationTime() {
        return this.tokenExpirationTime;
    }

    public void setTokenIssuer(String tokenIssuer) {
        this.tokenIssuer = tokenIssuer;
    }

    public void setTokenSigningKey(String tokenSigningKey) {
        this.tokenSigningKey = tokenSigningKey;
    }

    public void setTokenExpirationTime(Integer tokenExpirationTime) {
        this.tokenExpirationTime = tokenExpirationTime;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JwtSettings)) {
            return false;
        }
        JwtSettings other = (JwtSettings)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Integer this$tokenExpirationTime = this.getTokenExpirationTime();
        Integer other$tokenExpirationTime = other.getTokenExpirationTime();
        if (this$tokenExpirationTime == null ? other$tokenExpirationTime != null : !((Object)this$tokenExpirationTime).equals(other$tokenExpirationTime)) {
            return false;
        }
        String this$tokenIssuer = this.getTokenIssuer();
        String other$tokenIssuer = other.getTokenIssuer();
        if (this$tokenIssuer == null ? other$tokenIssuer != null : !this$tokenIssuer.equals(other$tokenIssuer)) {
            return false;
        }
        String this$tokenSigningKey = this.getTokenSigningKey();
        String other$tokenSigningKey = other.getTokenSigningKey();
        return !(this$tokenSigningKey == null ? other$tokenSigningKey != null : !this$tokenSigningKey.equals(other$tokenSigningKey));
    }

    protected boolean canEqual(Object other) {
        return other instanceof JwtSettings;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $tokenExpirationTime = this.getTokenExpirationTime();
        result = result * 59 + ($tokenExpirationTime == null ? 43 : ((Object)$tokenExpirationTime).hashCode());
        String $tokenIssuer = this.getTokenIssuer();
        result = result * 59 + ($tokenIssuer == null ? 43 : $tokenIssuer.hashCode());
        String $tokenSigningKey = this.getTokenSigningKey();
        result = result * 59 + ($tokenSigningKey == null ? 43 : $tokenSigningKey.hashCode());
        return result;
    }

    public String toString() {
        return "JwtSettings(tokenIssuer=" + this.getTokenIssuer() + ", tokenSigningKey=" + this.getTokenSigningKey() + ", tokenExpirationTime=" + this.getTokenExpirationTime() + ")";
    }

    public JwtSettings() {
    }

    public JwtSettings(String tokenIssuer, String tokenSigningKey, Integer tokenExpirationTime) {
        this.tokenIssuer = tokenIssuer;
        this.tokenSigningKey = tokenSigningKey;
        this.tokenExpirationTime = tokenExpirationTime;
    }
}

