/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.security.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.UUID;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;

public class JwtSecurityUser {
    public static final JwtSecurityUser NOT_USER = new JwtSecurityUser(EntityId.NULL_UUID, EntityId.NULL_UUID, EntityId.NULL_UUID);
    private UUID tenantId;
    private UUID customerId;
    private UUID userId;

    public JwtSecurityUser(JwtSecurityUser that) {
        this.tenantId = that.tenantId;
        this.customerId = that.customerId;
        this.userId = that.userId;
    }

    @JsonIgnore
    public TenantId getTenant() {
        return TenantId.fromUUID((UUID)this.tenantId);
    }

    @JsonIgnore
    public CustomerId getCustomer() {
        return new CustomerId(this.customerId);
    }

    @JsonIgnore
    public boolean isTenantUser() {
        return EntityId.NULL_UUID.equals(this.customerId);
    }

    @JsonIgnore
    public boolean isCustomerUser() {
        return !EntityId.NULL_UUID.equals(this.customerId);
    }

    @JsonIgnore
    public String getTenantCustomerKey() {
        return String.format("%s - %s", this.tenantId, this.customerId);
    }

    @JsonIgnore
    public EntityType getEntityType() {
        if (this.isTenantUser()) {
            return EntityType.TENANT;
        }
        if (this.isCustomerUser()) {
            return EntityType.CUSTOMER;
        }
        throw new RuntimeException("Unknown entity type");
    }

    public static JwtSecurityUserBuilder builder() {
        return new JwtSecurityUserBuilder();
    }

    public UUID getTenantId() {
        return this.tenantId;
    }

    public UUID getCustomerId() {
        return this.customerId;
    }

    public UUID getUserId() {
        return this.userId;
    }

    public void setTenantId(UUID tenantId) {
        this.tenantId = tenantId;
    }

    public void setCustomerId(UUID customerId) {
        this.customerId = customerId;
    }

    public void setUserId(UUID userId) {
        this.userId = userId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JwtSecurityUser)) {
            return false;
        }
        JwtSecurityUser other = (JwtSecurityUser)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        UUID this$tenantId = this.getTenantId();
        UUID other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !((Object)this$tenantId).equals(other$tenantId)) {
            return false;
        }
        UUID this$customerId = this.getCustomerId();
        UUID other$customerId = other.getCustomerId();
        if (this$customerId == null ? other$customerId != null : !((Object)this$customerId).equals(other$customerId)) {
            return false;
        }
        UUID this$userId = this.getUserId();
        UUID other$userId = other.getUserId();
        return !(this$userId == null ? other$userId != null : !((Object)this$userId).equals(other$userId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof JwtSecurityUser;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : ((Object)$tenantId).hashCode());
        UUID $customerId = this.getCustomerId();
        result = result * 59 + ($customerId == null ? 43 : ((Object)$customerId).hashCode());
        UUID $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : ((Object)$userId).hashCode());
        return result;
    }

    public String toString() {
        return "JwtSecurityUser(tenantId=" + String.valueOf(this.getTenantId()) + ", customerId=" + String.valueOf(this.getCustomerId()) + ", userId=" + String.valueOf(this.getUserId()) + ")";
    }

    public JwtSecurityUser() {
    }

    public JwtSecurityUser(UUID tenantId, UUID customerId, UUID userId) {
        this.tenantId = tenantId;
        this.customerId = customerId;
        this.userId = userId;
    }
}

