/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.interceptor;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.Cache;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.HandlerInterceptor;
import org.thingsboard.trendz.controller.BaseController;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.security.service.ApiKeyService;
import org.thingsboard.trendz.security.service.AuthenticationService;
import org.thingsboard.trendz.service.customize.CustomizationService;
import org.thingsboard.trendz.service.customize.UserManagementService;
import org.thingsboard.trendz.service.executor.ExecutorManagementService;
import org.thingsboard.trendz.service.executor.ExecutorName;
import org.thingsboard.trendz.service.provider.cache.CacheConfigurationName;
import org.thingsboard.trendz.service.provider.cache.CacheService;
import org.thingsboard.trendz.service.task.TaskInitializationService;

@Component
@Order(value=2)
public class TrackingInterceptor
extends BaseController
implements HandlerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(TrackingInterceptor.class);
    private final AuthenticationService authenticationService;
    private final UserManagementService userManagementService;
    private final ApiKeyService apiKeyService;
    private final CustomizationService customizationService;
    private final TaskInitializationService taskInitializationService;
    private final ExecutorService trackingExecutor;
    private final Cache userTrackCache;

    public TrackingInterceptor(AuthenticationService authenticationService, UserManagementService userManagementService, ApiKeyService apiKeyService, CustomizationService customizationService, TaskInitializationService taskInitializationService, ExecutorManagementService executorManagementService, CacheService cacheService) {
        this.authenticationService = authenticationService;
        this.userManagementService = userManagementService;
        this.apiKeyService = apiKeyService;
        this.customizationService = customizationService;
        this.taskInitializationService = taskInitializationService;
        this.trackingExecutor = executorManagementService.getExecutorByName(ExecutorName.TRACKING);
        this.userTrackCache = cacheService.getCache(CacheConfigurationName.userTrackCacheName);
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        try {
            if (this.isAuthenticated()) {
                String jwtToken = this.getJwtToken();
                JwtSecurityUser user = this.getSecurityUser();
                String domain = request.getServerName();
                boolean valid = this.authenticationService.validateToken(jwtToken);
                if (!valid) {
                    response.setStatus(401);
                    return false;
                }
                this.authenticationService.cacheToken(user, jwtToken);
                Future<?> future = this.trackingExecutor.submit(() -> this.trackUser(jwtToken, user, domain));
            }
        }
        catch (Exception e) {
            log.error("Error during tracking interceptor job", (Throwable)e);
        }
        return true;
    }

    public void trackUser(String jwtToken, JwtSecurityUser user, String domain) {
        try {
            this.userTrackCache.get((Object)user, () -> {
                this.userManagementService.trackUser(jwtToken, user);
                this.apiKeyService.generateApiKey(user.getTenantId());
                this.customizationService.trackDomain(user, domain);
                this.taskInitializationService.proceedInitialization(user);
                return true;
            });
        }
        catch (Exception e) {
            this.userTrackCache.evict((Object)user);
            log.error("Error during user tracking!", (Throwable)e);
        }
    }
}

