/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.exception.service.script;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.script.ScriptException;
import org.thingsboard.trendz.domain.definition.calculation.CalculationFieldType;
import org.thingsboard.trendz.domain.definition.view.config.ScriptLanguage;
import org.thingsboard.trendz.exception.TrendzException;
import org.thingsboard.trendz.exception.service.script.ScriptFormatException;
import org.thingsboard.trendz.exception.service.script.ScriptProcessingException;
import org.thingsboard.trendz.exception.service.script.engine.JsException;
import org.thingsboard.trendz.exception.service.script.engine.PythonException;
import org.thingsboard.trendz.service.script.command.CommandExecutionResult;

public class ScriptProcessingException
extends TrendzException {
    private static final String patternOfErrorInfoLineFirstStr = "at transformFunction \\(<eval>:\\d+\\)";
    private static final String patternOfErrorInfoLineSecondStr = "at line number \\d+";
    private static final String patternOfErrorInfoColumnStr = "at column number \\d+";
    private static final String patternOfErrorInfoBothStr = "<eval>:\\d+:\\d+";
    private static final String patternOfNumberStr = "\\d+";
    private static final Pattern patternOfErrorInfoFirstLine = Pattern.compile("at transformFunction \\(<eval>:\\d+\\)");
    private static final Pattern patternOfErrorInfoSecondLine = Pattern.compile("at line number \\d+");
    private static final Pattern patternOfErrorInfoColumn = Pattern.compile("at column number \\d+");
    private static final Pattern patternOfErrorInfoBoth = Pattern.compile("<eval>:\\d+:\\d+");
    private static final Pattern patternOfNumber = Pattern.compile("\\d+");
    private static final int excessLinesInJsCode = 10;
    private static final int excessLinesInPythonCode = 10;
    private static final int NECESSARY_FIELDS_COUNT = 7;
    private String fieldName;
    private String script;
    private ScriptLanguage scriptLanguage;
    private List<String> argNames;
    private boolean batched;
    private boolean nativeCalculation;
    private boolean state;
    private long line;
    private int column;
    private String fixedMessage;

    public ScriptProcessingException(String fieldName, String script, List<String> argNames, ScriptLanguage scriptLanguage, Throwable cause, CalculationFieldType fieldType) {
        super("", cause);
        this.fieldName = fieldName;
        this.script = script == null ? "" : script.replaceAll("\\n\\s*", " ");
        this.scriptLanguage = scriptLanguage;
        this.argNames = new ArrayList<String>(argNames);
        this.batched = fieldType == CalculationFieldType.BATCH;
        this.nativeCalculation = fieldType == CalculationFieldType.NATIVE;
        boolean bl = this.state = fieldType == null;
        if (cause instanceof ScriptFormatException) {
            ScriptFormatException formatException = (ScriptFormatException)cause;
            this.defineLineAndColumnFormat(formatException);
        } else {
            switch (1.$SwitchMap$org$thingsboard$trendz$domain$definition$view$config$ScriptLanguage[scriptLanguage.ordinal()]) {
                case 1: {
                    this.defineLineAndColumnJs((JsException)cause);
                    break;
                }
                case 2: {
                    this.defineLineAndColumnPython((PythonException)cause);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported value: " + String.valueOf(scriptLanguage));
                }
            }
        }
    }

    public String getMessage() {
        return "Error during the processing script!\n\nLine: %s\nColumn: %s\n\nCause:\n%s\n".formatted(this.line, this.column, this.fixedMessage);
    }

    private void defineLineAndColumnFormat(ScriptFormatException formatException) {
        this.line = this.script.lines().count();
        this.column = -1;
        this.fixedMessage = formatException.getMessage();
    }

    private void defineLineAndColumnJs(JsException exception) {
        ScriptException cause = (ScriptException)exception.getCause();
        Object message = cause.getMessage();
        Matcher matcherLineFirst = patternOfErrorInfoFirstLine.matcher((CharSequence)message);
        Matcher matcherLineSecond = patternOfErrorInfoSecondLine.matcher((CharSequence)message);
        if (matcherLineFirst.find()) {
            result = matcherLineFirst.group();
            line = this.getLine(result);
            message = ((String)message).substring(0, ((String)message).indexOf(10));
            message = (String)message + " at line number " + line;
        } else if (matcherLineSecond.find()) {
            result = matcherLineSecond.group();
            line = this.getLine(result);
            message = ((String)message).replaceAll(patternOfErrorInfoLineSecondStr, "at line number " + line);
        } else {
            this.line = -1L;
        }
        Matcher matcherColumn = patternOfErrorInfoColumn.matcher((CharSequence)message);
        if (matcherColumn.find()) {
            String result = matcherColumn.group();
            Matcher matcherNumber = patternOfNumber.matcher(result);
            this.column = Integer.parseInt(matcherNumber.group()) - 4;
        } else {
            this.column = -1;
        }
        Matcher matcherBoth = patternOfErrorInfoBoth.matcher((CharSequence)message);
        if (matcherBoth.find()) {
            message = ((String)message).replaceAll(patternOfErrorInfoBothStr, "<eval>:" + this.line + ":" + this.column);
        }
        int indexNextLine = ((String)message).indexOf(10) == -1 ? ((String)message).length() : ((String)message).indexOf(10);
        this.fixedMessage = ((String)message).substring(0, indexNextLine);
    }

    private long getLine(String line) {
        Matcher matcherNumber = patternOfNumber.matcher(line);
        this.line = Integer.parseInt(matcherNumber.group());
        this.line = this.line - 10L - (long)this.argNames.size() * 2L - (long)(this.state ? 2 : (this.batched ? 0 : 14));
        return this.line;
    }

    private void defineLineAndColumnPython(PythonException exception) {
        CommandExecutionResult executionResult = exception.getExecutionResult();
        List errorLines = executionResult.getErrorOutput();
        this.column = this.defineColumn(errorLines);
        this.line = this.defineLine(errorLines);
        this.fixedMessage = this.getFixedMessage(errorLines);
    }

    private String getFixedMessage(List<String> errorLines) {
        int size = errorLines.size();
        if (this.column == -1) {
            return errorLines.get(size - 1);
        }
        List<String> last3Lines = errorLines.subList(size - 3, size);
        if (last3Lines.size() == 3) {
            last3Lines.set(0, last3Lines.get(0).substring(4));
            last3Lines.set(1, last3Lines.get(1).substring(2));
        }
        return String.join((CharSequence)"\n", last3Lines);
    }

    private int defineColumn(List<String> errorLines) {
        String pointerLine = errorLines.get(errorLines.size() - 2);
        return pointerLine.trim().matches("^ *\\^$") ? pointerLine.length() - 4 : -1;
    }

    private long defineLine(List<String> errorLines) {
        Optional<String> lastLineOptional = errorLines.stream().filter(s -> s.contains(", line")).reduce((first, second) -> second);
        if (lastLineOptional.isEmpty()) {
            return -1L;
        }
        String lastLine = lastLineOptional.get();
        int lineNumberStart = lastLine.indexOf(", line ") + 7;
        int lineNumberEnd = lastLine.indexOf(", in ");
        if (lineNumberEnd == -1) {
            lineNumberEnd = lastLine.length();
        }
        String lineNumberString = lastLine.substring(lineNumberStart, lineNumberEnd);
        return (long)Integer.parseInt(lineNumberString) - this.calculateCorrection();
    }

    private long calculateCorrection() {
        long correction;
        if (this.state) {
            correction = 0L;
        } else if (this.nativeCalculation) {
            correction = "_script_execution_id = \"%s\"\n\n%s\n\n".lines().count() + "import requests\nimport json\n\n_base_url = \"http://localhost:8181\"\n_originator_type = \"%s\"\n_originator_id = \"%s\"\n\ndef get_originator_type():\n    return _originator_type\n\ndef get_originator_id():\n    return _originator_id\n\ndef _post_json(url, body):\n    headers = {\n        \"Content-Type\": \"application/json\"\n    }\n    try:\n        resp = requests.post(url, headers=headers, json=body, timeout=30)\n    except requests.RequestException as e:\n        raise requests.RequestException(\n            f\"[REQUEST ERROR] {e}\\nURL: {url}\\nRequest body: {body}\"\n        ) from e\n\n    if resp.status_code >= 400:\n        # \u041f\u043e\u043f\u0440\u043e\u0431\u0443\u0435\u043c \u0434\u043e\u0441\u0442\u0430\u0442\u044c JSON, \u0438\u043d\u0430\u0447\u0435 \u0432\u043e\u0437\u044c\u043c\u0451\u043c \u0442\u0435\u043a\u0441\u0442\n        try:\n            detail = json.dumps(resp.json(), ensure_ascii=False)\n        except Exception:\n            detail = resp.text\n        # \u0414\u043e\u0431\u0430\u0432\u0438\u043c \u043c\u0430\u043a\u0441\u0438\u043c\u0443\u043c \u043a\u043e\u043d\u0442\u0435\u043a\u0441\u0442\u0430 \u0432 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435 \u043e\u0431 \u043e\u0448\u0438\u0431\u043a\u0435\n        msg = (\n            f\"[HTTP {resp.status_code}] POST {url}\\n\"\n            f\"Request body: {body}\\n\"\n            f\"Response: {detail[:4000]}\"\n        )\n        # \u0421\u043e\u0445\u0440\u0430\u043d\u0438\u043c \u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c\u043e\u0441\u0442\u044c \u0441 raise_for_status, \u043d\u043e \u0441 \u0431\u043e\u0433\u0430\u0442\u044b\u043c \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435\u043c\n        http_err = requests.HTTPError(msg, response=resp)\n        raise http_err\n\n    # \u0412\u0435\u0440\u043d\u0451\u043c JSON, \u0435\u0441\u043b\u0438 \u043e\u043d \u0435\u0441\u0442\u044c, \u0438\u043d\u0430\u0447\u0435 \u0441\u043e\u043e\u0431\u0449\u0438\u043c \u043e \u043f\u0440\u043e\u0431\u043b\u0435\u043c\u0435 \u043f\u0430\u0440\u0441\u0438\u043d\u0433\u0430\n    try:\n        return resp.json()\n    except ValueError:\n        raise ValueError(\n            f\"[PARSE ERROR] Expected JSON but got:\\n{resp.text[:4000]}\\nURL: {url}\"\n        )\n\ndef get_telemetries(keys, from_ts=startTs, to_ts=endTs, entity_id=_originator_id, entity_type=_originator_type):\n    url = f\"{_base_url}/proxy/telemetry/{_script_execution_id}\"\n    body = {\n        \"entityType\": entity_type,\n        \"entityId\": entity_id,\n        \"startTs\": from_ts,\n        \"endTs\": to_ts,\n        \"keys\": keys\n    }\n    return _post_json(url, body)\n\ndef get_attributes(attributes, entity_id=_originator_id, entity_type=_originator_type):\n    url = f\"{_base_url}/proxy/attributes/{_script_execution_id}\"\n    body = {\n        \"entityType\": entity_type,\n        \"entityId\": entity_id,\n        \"attributes\": attributes\n    }\n    return _post_json(url, body)\n\ndef get_relations(entity_id=_originator_id, entity_type=_originator_type, direction=None, relation_type=None, target_entity_type=None, target_entity_profile_name=None):\n    url = f\"{_base_url}/proxy/relations/{_script_execution_id}\"\n    body = {\n        \"entityType\": entity_type,\n        \"entityId\": entity_id\n    }\n    if direction is not None:\n        body[\"direction\"] = direction\n    if relation_type is not None:\n        body[\"relationType\"] = relation_type\n    if target_entity_type is not None:\n        body[\"targetEntityType\"] = target_entity_type\n    if target_entity_profile_name is not None:\n        body[\"targetEntityProfileName\"] = target_entity_profile_name\n\n    return _post_json(url, body)\n\n%s\n".lines().count() - 3L;
        } else {
            correction = this.argNames.size();
            if (this.batched) {
                --correction;
            }
        }
        return correction + 10L;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String getScript() {
        return this.script;
    }

    public ScriptLanguage getScriptLanguage() {
        return this.scriptLanguage;
    }

    public List<String> getArgNames() {
        return this.argNames;
    }

    public boolean isBatched() {
        return this.batched;
    }

    public boolean isNativeCalculation() {
        return this.nativeCalculation;
    }

    public boolean isState() {
        return this.state;
    }

    public long getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    public String getFixedMessage() {
        return this.fixedMessage;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public void setScript(String script) {
        this.script = script;
    }

    public void setScriptLanguage(ScriptLanguage scriptLanguage) {
        this.scriptLanguage = scriptLanguage;
    }

    public void setArgNames(List<String> argNames) {
        this.argNames = argNames;
    }

    public void setBatched(boolean batched) {
        this.batched = batched;
    }

    public void setNativeCalculation(boolean nativeCalculation) {
        this.nativeCalculation = nativeCalculation;
    }

    public void setState(boolean state) {
        this.state = state;
    }

    public void setLine(long line) {
        this.line = line;
    }

    public void setColumn(int column) {
        this.column = column;
    }

    public void setFixedMessage(String fixedMessage) {
        this.fixedMessage = fixedMessage;
    }

    public String toString() {
        return "ScriptProcessingException(fieldName=" + this.getFieldName() + ", script=" + this.getScript() + ", scriptLanguage=" + String.valueOf(this.getScriptLanguage()) + ", argNames=" + String.valueOf(this.getArgNames()) + ", batched=" + this.isBatched() + ", nativeCalculation=" + this.isNativeCalculation() + ", state=" + this.isState() + ", line=" + this.getLine() + ", column=" + this.getColumn() + ", fixedMessage=" + this.getFixedMessage() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ScriptProcessingException)) {
            return false;
        }
        ScriptProcessingException other = (ScriptProcessingException)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isBatched() != other.isBatched()) {
            return false;
        }
        if (this.isNativeCalculation() != other.isNativeCalculation()) {
            return false;
        }
        if (this.isState() != other.isState()) {
            return false;
        }
        if (this.getLine() != other.getLine()) {
            return false;
        }
        if (this.getColumn() != other.getColumn()) {
            return false;
        }
        String this$fieldName = this.getFieldName();
        String other$fieldName = other.getFieldName();
        if (this$fieldName == null ? other$fieldName != null : !this$fieldName.equals(other$fieldName)) {
            return false;
        }
        String this$script = this.getScript();
        String other$script = other.getScript();
        if (this$script == null ? other$script != null : !this$script.equals(other$script)) {
            return false;
        }
        ScriptLanguage this$scriptLanguage = this.getScriptLanguage();
        ScriptLanguage other$scriptLanguage = other.getScriptLanguage();
        if (this$scriptLanguage == null ? other$scriptLanguage != null : !this$scriptLanguage.equals(other$scriptLanguage)) {
            return false;
        }
        List this$argNames = this.getArgNames();
        List other$argNames = other.getArgNames();
        if (this$argNames == null ? other$argNames != null : !((Object)this$argNames).equals(other$argNames)) {
            return false;
        }
        String this$fixedMessage = this.getFixedMessage();
        String other$fixedMessage = other.getFixedMessage();
        return !(this$fixedMessage == null ? other$fixedMessage != null : !this$fixedMessage.equals(other$fixedMessage));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ScriptProcessingException;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isBatched() ? 79 : 97);
        result = result * 59 + (this.isNativeCalculation() ? 79 : 97);
        result = result * 59 + (this.isState() ? 79 : 97);
        long $line = this.getLine();
        result = result * 59 + (int)($line >>> 32 ^ $line);
        result = result * 59 + this.getColumn();
        String $fieldName = this.getFieldName();
        result = result * 59 + ($fieldName == null ? 43 : $fieldName.hashCode());
        String $script = this.getScript();
        result = result * 59 + ($script == null ? 43 : $script.hashCode());
        ScriptLanguage $scriptLanguage = this.getScriptLanguage();
        result = result * 59 + ($scriptLanguage == null ? 43 : $scriptLanguage.hashCode());
        List $argNames = this.getArgNames();
        result = result * 59 + ($argNames == null ? 43 : ((Object)$argNames).hashCode());
        String $fixedMessage = this.getFixedMessage();
        result = result * 59 + ($fixedMessage == null ? 43 : $fixedMessage.hashCode());
        return result;
    }
}

