/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.domain.user;

import java.util.UUID;
import org.thingsboard.trendz.domain.definition.migration.TrendzEntity;
import org.thingsboard.trendz.domain.definition.view.config.DatePickerConfig;
import org.thingsboard.trendz.domain.runtime.ItemLite;
import org.thingsboard.trendz.domain.user.UserMetadata;

public class UserMetadata
implements TrendzEntity {
    private UUID id;
    private UUID tenantId;
    private UUID customerId;
    private UUID defaultBusinessEntityId;
    private DatePickerConfig defaultDatePickerConfig;
    private ItemLite defaultItem;

    public UserMetadata(UserMetadata that) {
        this.id = that.id;
        this.tenantId = that.tenantId;
        this.customerId = that.customerId;
        this.defaultBusinessEntityId = that.defaultBusinessEntityId;
        this.defaultDatePickerConfig = that.defaultDatePickerConfig == null ? null : new DatePickerConfig(that.defaultDatePickerConfig);
        this.defaultItem = that.defaultItem == null ? null : new ItemLite(that.defaultItem);
    }

    public String getName() {
        return "%s/%s".formatted(this.tenantId, this.customerId);
    }

    public static UserMetadataBuilder builder() {
        return new UserMetadataBuilder();
    }

    public UUID getId() {
        return this.id;
    }

    public UUID getTenantId() {
        return this.tenantId;
    }

    public UUID getCustomerId() {
        return this.customerId;
    }

    public UUID getDefaultBusinessEntityId() {
        return this.defaultBusinessEntityId;
    }

    public DatePickerConfig getDefaultDatePickerConfig() {
        return this.defaultDatePickerConfig;
    }

    public ItemLite getDefaultItem() {
        return this.defaultItem;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public void setTenantId(UUID tenantId) {
        this.tenantId = tenantId;
    }

    public void setCustomerId(UUID customerId) {
        this.customerId = customerId;
    }

    public void setDefaultBusinessEntityId(UUID defaultBusinessEntityId) {
        this.defaultBusinessEntityId = defaultBusinessEntityId;
    }

    public void setDefaultDatePickerConfig(DatePickerConfig defaultDatePickerConfig) {
        this.defaultDatePickerConfig = defaultDatePickerConfig;
    }

    public void setDefaultItem(ItemLite defaultItem) {
        this.defaultItem = defaultItem;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UserMetadata)) {
            return false;
        }
        UserMetadata other = (UserMetadata)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        UUID this$tenantId = this.getTenantId();
        UUID other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !((Object)this$tenantId).equals(other$tenantId)) {
            return false;
        }
        UUID this$customerId = this.getCustomerId();
        UUID other$customerId = other.getCustomerId();
        if (this$customerId == null ? other$customerId != null : !((Object)this$customerId).equals(other$customerId)) {
            return false;
        }
        UUID this$defaultBusinessEntityId = this.getDefaultBusinessEntityId();
        UUID other$defaultBusinessEntityId = other.getDefaultBusinessEntityId();
        if (this$defaultBusinessEntityId == null ? other$defaultBusinessEntityId != null : !((Object)this$defaultBusinessEntityId).equals(other$defaultBusinessEntityId)) {
            return false;
        }
        DatePickerConfig this$defaultDatePickerConfig = this.getDefaultDatePickerConfig();
        DatePickerConfig other$defaultDatePickerConfig = other.getDefaultDatePickerConfig();
        if (this$defaultDatePickerConfig == null ? other$defaultDatePickerConfig != null : !this$defaultDatePickerConfig.equals(other$defaultDatePickerConfig)) {
            return false;
        }
        ItemLite this$defaultItem = this.getDefaultItem();
        ItemLite other$defaultItem = other.getDefaultItem();
        return !(this$defaultItem == null ? other$defaultItem != null : !this$defaultItem.equals(other$defaultItem));
    }

    protected boolean canEqual(Object other) {
        return other instanceof UserMetadata;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        UUID $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : ((Object)$tenantId).hashCode());
        UUID $customerId = this.getCustomerId();
        result = result * 59 + ($customerId == null ? 43 : ((Object)$customerId).hashCode());
        UUID $defaultBusinessEntityId = this.getDefaultBusinessEntityId();
        result = result * 59 + ($defaultBusinessEntityId == null ? 43 : ((Object)$defaultBusinessEntityId).hashCode());
        DatePickerConfig $defaultDatePickerConfig = this.getDefaultDatePickerConfig();
        result = result * 59 + ($defaultDatePickerConfig == null ? 43 : $defaultDatePickerConfig.hashCode());
        ItemLite $defaultItem = this.getDefaultItem();
        result = result * 59 + ($defaultItem == null ? 43 : $defaultItem.hashCode());
        return result;
    }

    public String toString() {
        return "UserMetadata(id=" + String.valueOf(this.getId()) + ", tenantId=" + String.valueOf(this.getTenantId()) + ", customerId=" + String.valueOf(this.getCustomerId()) + ", defaultBusinessEntityId=" + String.valueOf(this.getDefaultBusinessEntityId()) + ", defaultDatePickerConfig=" + String.valueOf(this.getDefaultDatePickerConfig()) + ", defaultItem=" + String.valueOf(this.getDefaultItem()) + ")";
    }

    public UserMetadata() {
    }

    public UserMetadata(UUID id, UUID tenantId, UUID customerId, UUID defaultBusinessEntityId, DatePickerConfig defaultDatePickerConfig, ItemLite defaultItem) {
        this.id = id;
        this.tenantId = tenantId;
        this.customerId = customerId;
        this.defaultBusinessEntityId = defaultBusinessEntityId;
        this.defaultDatePickerConfig = defaultDatePickerConfig;
        this.defaultItem = defaultItem;
    }
}

