/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.domain.tb.widget.v2;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.WidgetsBundleId;
import org.thingsboard.trendz.domain.tb.widget.v2.TbWidgetBundleItemV2;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class TbWidgetBundleItemV2
implements Comparable<TbWidgetBundleItemV2> {
    private WidgetsBundleId id;
    private long createdTime;
    private TenantId tenantId;
    private String alias;
    private String title;
    private String name;
    private String image;
    private String description;
    private int version;
    private Map<String, Object> additionalProperties;

    public TbWidgetBundleItemV2() {
        this.additionalProperties = new HashMap();
    }

    public TbWidgetBundleItemV2(TbWidgetBundleItemV2 that) {
        this.id = that.id == null ? null : new WidgetsBundleId(that.id.getId());
        this.createdTime = that.createdTime;
        this.tenantId = that.tenantId == null ? null : new TenantId(that.tenantId.getId());
        this.alias = that.alias;
        this.title = that.title;
        this.name = that.name;
        this.image = that.image;
        this.description = that.description;
        this.version = that.version;
        this.additionalProperties = that.additionalProperties == null ? null : that.additionalProperties.entrySet().stream().map(entry -> Map.entry((String)entry.getKey(), entry.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String key, Object value) {
        this.additionalProperties.put(key, value);
    }

    @JsonIgnore
    public boolean isSystem() {
        return EntityId.NULL_UUID.equals(this.tenantId.getId());
    }

    @Override
    public int compareTo(TbWidgetBundleItemV2 that) {
        return this.alias.compareTo(that.alias);
    }

    public static TbWidgetBundleItemV2Builder builder() {
        return new TbWidgetBundleItemV2Builder();
    }

    public WidgetsBundleId getId() {
        return this.id;
    }

    public long getCreatedTime() {
        return this.createdTime;
    }

    public TenantId getTenantId() {
        return this.tenantId;
    }

    public String getAlias() {
        return this.alias;
    }

    public String getTitle() {
        return this.title;
    }

    public String getName() {
        return this.name;
    }

    public String getImage() {
        return this.image;
    }

    public String getDescription() {
        return this.description;
    }

    public int getVersion() {
        return this.version;
    }

    public void setId(WidgetsBundleId id) {
        this.id = id;
    }

    public void setCreatedTime(long createdTime) {
        this.createdTime = createdTime;
    }

    public void setTenantId(TenantId tenantId) {
        this.tenantId = tenantId;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public void setAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TbWidgetBundleItemV2)) {
            return false;
        }
        TbWidgetBundleItemV2 other = (TbWidgetBundleItemV2)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getCreatedTime() != other.getCreatedTime()) {
            return false;
        }
        if (this.getVersion() != other.getVersion()) {
            return false;
        }
        WidgetsBundleId this$id = this.getId();
        WidgetsBundleId other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        TenantId this$tenantId = this.getTenantId();
        TenantId other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !this$tenantId.equals(other$tenantId)) {
            return false;
        }
        String this$alias = this.getAlias();
        String other$alias = other.getAlias();
        if (this$alias == null ? other$alias != null : !this$alias.equals(other$alias)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$image = this.getImage();
        String other$image = other.getImage();
        if (this$image == null ? other$image != null : !this$image.equals(other$image)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        Map this$additionalProperties = this.getAdditionalProperties();
        Map other$additionalProperties = other.getAdditionalProperties();
        return !(this$additionalProperties == null ? other$additionalProperties != null : !((Object)this$additionalProperties).equals(other$additionalProperties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TbWidgetBundleItemV2;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $createdTime = this.getCreatedTime();
        result = result * 59 + (int)($createdTime >>> 32 ^ $createdTime);
        result = result * 59 + this.getVersion();
        WidgetsBundleId $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        TenantId $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : $tenantId.hashCode());
        String $alias = this.getAlias();
        result = result * 59 + ($alias == null ? 43 : $alias.hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $image = this.getImage();
        result = result * 59 + ($image == null ? 43 : $image.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        Map $additionalProperties = this.getAdditionalProperties();
        result = result * 59 + ($additionalProperties == null ? 43 : ((Object)$additionalProperties).hashCode());
        return result;
    }

    public String toString() {
        return "TbWidgetBundleItemV2(id=" + String.valueOf(this.getId()) + ", createdTime=" + this.getCreatedTime() + ", tenantId=" + String.valueOf(this.getTenantId()) + ", alias=" + this.getAlias() + ", title=" + this.getTitle() + ", name=" + this.getName() + ", image=" + this.getImage() + ", description=" + this.getDescription() + ", version=" + this.getVersion() + ", additionalProperties=" + String.valueOf(this.getAdditionalProperties()) + ")";
    }

    public TbWidgetBundleItemV2(WidgetsBundleId id, long createdTime, TenantId tenantId, String alias, String title, String name, String image, String description, int version, Map<String, Object> additionalProperties) {
        this.id = id;
        this.createdTime = createdTime;
        this.tenantId = tenantId;
        this.alias = alias;
        this.title = title;
        this.name = name;
        this.image = image;
        this.description = description;
        this.version = version;
        this.additionalProperties = additionalProperties;
    }
}

