/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.domain.tb.widget.v2;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.thingsboard.trendz.domain.tb.widget.v2.TbWidgetBundleConfigV2;
import org.thingsboard.trendz.domain.tb.widget.v2.TbWidgetBundleItemV2;
import org.thingsboard.trendz.domain.tb.widget.v2.TbWidgetTypeItemV2;

public class TbWidgetBundleConfigV2
implements Comparable<TbWidgetBundleConfigV2> {
    private TbWidgetBundleItemV2 widgetsBundle;
    private List<TbWidgetTypeItemV2> widgetTypes;
    private Set<String> widgetTypeFqns;
    private Map<String, Object> additionalProperties;

    public TbWidgetBundleConfigV2() {
        this.widgetsBundle = null;
        this.widgetTypes = new ArrayList();
        this.widgetTypeFqns = new HashSet();
        this.additionalProperties = new HashMap();
    }

    public TbWidgetBundleConfigV2(TbWidgetBundleItemV2 widgetsBundle, List<TbWidgetTypeItemV2> widgetTypes, Set<String> widgetTypeFqns) {
        this.widgetsBundle = widgetsBundle;
        this.widgetTypes = new ArrayList<TbWidgetTypeItemV2>(widgetTypes);
        this.widgetTypeFqns = new HashSet<String>(widgetTypeFqns);
        Collections.sort(this.widgetTypes);
    }

    public TbWidgetBundleConfigV2(TbWidgetBundleConfigV2 that) {
        this.widgetsBundle = that.widgetsBundle == null ? null : new TbWidgetBundleItemV2(that.widgetsBundle);
        this.widgetTypes = that.widgetTypes == null ? null : that.widgetTypes.stream().map(TbWidgetTypeItemV2::new).sorted().collect(Collectors.toList());
        this.widgetTypeFqns = that.widgetTypeFqns == null ? null : new HashSet(that.widgetTypeFqns);
        this.additionalProperties = that.additionalProperties == null ? null : that.additionalProperties.entrySet().stream().map(entry -> Map.entry((String)entry.getKey(), entry.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String key, Object value) {
        this.additionalProperties.put(key, value);
    }

    @Override
    public int compareTo(TbWidgetBundleConfigV2 that) {
        return Comparator.nullsFirst(Comparator.naturalOrder()).compare(this.widgetsBundle, that.widgetsBundle);
    }

    public static TbWidgetBundleConfigV2Builder builder() {
        return new TbWidgetBundleConfigV2Builder();
    }

    public TbWidgetBundleItemV2 getWidgetsBundle() {
        return this.widgetsBundle;
    }

    public List<TbWidgetTypeItemV2> getWidgetTypes() {
        return this.widgetTypes;
    }

    public Set<String> getWidgetTypeFqns() {
        return this.widgetTypeFqns;
    }

    public void setWidgetsBundle(TbWidgetBundleItemV2 widgetsBundle) {
        this.widgetsBundle = widgetsBundle;
    }

    public void setWidgetTypes(List<TbWidgetTypeItemV2> widgetTypes) {
        this.widgetTypes = widgetTypes;
    }

    public void setWidgetTypeFqns(Set<String> widgetTypeFqns) {
        this.widgetTypeFqns = widgetTypeFqns;
    }

    public void setAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TbWidgetBundleConfigV2)) {
            return false;
        }
        TbWidgetBundleConfigV2 other = (TbWidgetBundleConfigV2)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        TbWidgetBundleItemV2 this$widgetsBundle = this.getWidgetsBundle();
        TbWidgetBundleItemV2 other$widgetsBundle = other.getWidgetsBundle();
        if (this$widgetsBundle == null ? other$widgetsBundle != null : !this$widgetsBundle.equals(other$widgetsBundle)) {
            return false;
        }
        List this$widgetTypes = this.getWidgetTypes();
        List other$widgetTypes = other.getWidgetTypes();
        if (this$widgetTypes == null ? other$widgetTypes != null : !((Object)this$widgetTypes).equals(other$widgetTypes)) {
            return false;
        }
        Set this$widgetTypeFqns = this.getWidgetTypeFqns();
        Set other$widgetTypeFqns = other.getWidgetTypeFqns();
        if (this$widgetTypeFqns == null ? other$widgetTypeFqns != null : !((Object)this$widgetTypeFqns).equals(other$widgetTypeFqns)) {
            return false;
        }
        Map this$additionalProperties = this.getAdditionalProperties();
        Map other$additionalProperties = other.getAdditionalProperties();
        return !(this$additionalProperties == null ? other$additionalProperties != null : !((Object)this$additionalProperties).equals(other$additionalProperties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TbWidgetBundleConfigV2;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TbWidgetBundleItemV2 $widgetsBundle = this.getWidgetsBundle();
        result = result * 59 + ($widgetsBundle == null ? 43 : $widgetsBundle.hashCode());
        List $widgetTypes = this.getWidgetTypes();
        result = result * 59 + ($widgetTypes == null ? 43 : ((Object)$widgetTypes).hashCode());
        Set $widgetTypeFqns = this.getWidgetTypeFqns();
        result = result * 59 + ($widgetTypeFqns == null ? 43 : ((Object)$widgetTypeFqns).hashCode());
        Map $additionalProperties = this.getAdditionalProperties();
        result = result * 59 + ($additionalProperties == null ? 43 : ((Object)$additionalProperties).hashCode());
        return result;
    }

    public String toString() {
        return "TbWidgetBundleConfigV2(widgetsBundle=" + String.valueOf(this.getWidgetsBundle()) + ", widgetTypes=" + String.valueOf(this.getWidgetTypes()) + ", widgetTypeFqns=" + String.valueOf(this.getWidgetTypeFqns()) + ", additionalProperties=" + String.valueOf(this.getAdditionalProperties()) + ")";
    }

    public TbWidgetBundleConfigV2(TbWidgetBundleItemV2 widgetsBundle, List<TbWidgetTypeItemV2> widgetTypes, Set<String> widgetTypeFqns, Map<String, Object> additionalProperties) {
        this.widgetsBundle = widgetsBundle;
        this.widgetTypes = widgetTypes;
        this.widgetTypeFqns = widgetTypeFqns;
        this.additionalProperties = additionalProperties;
    }
}

