/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.domain.tb.provider;

import java.util.function.Supplier;
import org.thingsboard.trendz.domain.tb.provider.RequestPriority;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Sinks;

public class RequestTask<T>
implements Comparable<RequestTask<?>> {
    private final long submittedAt;
    private final Supplier<Mono<T>> work;
    private final RequestPriority priority;
    private final Sinks.One<T> resultSink = Sinks.one();

    public RequestTask(Supplier<Mono<T>> work, RequestPriority priority) {
        this.work = work;
        this.submittedAt = System.currentTimeMillis();
        this.priority = priority;
    }

    @Override
    public int compareTo(RequestTask<?> other) {
        int priorityCompare = Integer.compare(this.priority.getIndex(), other.priority.getIndex());
        if (priorityCompare != 0) {
            return priorityCompare;
        }
        return Long.compare(this.submittedAt, other.submittedAt);
    }

    public long getSubmittedAt() {
        return this.submittedAt;
    }

    public Supplier<Mono<T>> getWork() {
        return this.work;
    }

    public RequestPriority getPriority() {
        return this.priority;
    }

    public Sinks.One<T> getResultSink() {
        return this.resultSink;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RequestTask)) {
            return false;
        }
        RequestTask other = (RequestTask)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getSubmittedAt() != other.getSubmittedAt()) {
            return false;
        }
        Supplier this$work = this.getWork();
        Supplier other$work = other.getWork();
        if (this$work == null ? other$work != null : !this$work.equals(other$work)) {
            return false;
        }
        RequestPriority this$priority = this.getPriority();
        RequestPriority other$priority = other.getPriority();
        if (this$priority == null ? other$priority != null : !this$priority.equals(other$priority)) {
            return false;
        }
        Sinks.One this$resultSink = this.getResultSink();
        Sinks.One other$resultSink = other.getResultSink();
        return !(this$resultSink == null ? other$resultSink != null : !this$resultSink.equals(other$resultSink));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RequestTask;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $submittedAt = this.getSubmittedAt();
        result = result * 59 + (int)($submittedAt >>> 32 ^ $submittedAt);
        Supplier $work = this.getWork();
        result = result * 59 + ($work == null ? 43 : $work.hashCode());
        RequestPriority $priority = this.getPriority();
        result = result * 59 + ($priority == null ? 43 : $priority.hashCode());
        Sinks.One $resultSink = this.getResultSink();
        result = result * 59 + ($resultSink == null ? 43 : $resultSink.hashCode());
        return result;
    }

    public String toString() {
        return "RequestTask(submittedAt=" + this.getSubmittedAt() + ", work=" + String.valueOf(this.getWork()) + ", priority=" + String.valueOf(this.getPriority()) + ", resultSink=" + String.valueOf(this.getResultSink()) + ")";
    }
}

