/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.domain.tb.dashboard.entity;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.thingsboard.trendz.domain.tb.dashboard.dto.Dashboard;
import org.thingsboard.trendz.domain.tb.dashboard.entity.DashboardAliasLite;
import org.thingsboard.trendz.domain.tb.dashboard.entity.DashboardData;

public class DashboardData {
    private UUID id;
    private String name;
    private Set<String> states;
    private Set<DashboardAliasLite> aliases;

    public DashboardData(Dashboard dashboard) {
        this.id = dashboard.getId().getId();
        this.name = dashboard.getName();
        this.states = dashboard.getConfiguration() == null ? Collections.emptySet() : dashboard.getConfiguration().getStates().keySet();
        this.aliases = dashboard.getConfiguration() == null ? Collections.emptySet() : dashboard.getConfiguration().getEntityAliases().values().stream().map(DashboardAliasLite::new).collect(Collectors.toSet());
    }

    public DashboardData(DashboardData that) {
        this.id = that.id;
        this.name = that.name;
        this.states = that.states == null ? null : new HashSet(that.states);
        this.aliases = that.aliases == null ? null : that.aliases.stream().map(DashboardAliasLite::new).collect(Collectors.toSet());
    }

    public static DashboardDataBuilder builder() {
        return new DashboardDataBuilder();
    }

    public UUID getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Set<String> getStates() {
        return this.states;
    }

    public Set<DashboardAliasLite> getAliases() {
        return this.aliases;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setStates(Set<String> states) {
        this.states = states;
    }

    public void setAliases(Set<DashboardAliasLite> aliases) {
        this.aliases = aliases;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DashboardData)) {
            return false;
        }
        DashboardData other = (DashboardData)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Set this$states = this.getStates();
        Set other$states = other.getStates();
        if (this$states == null ? other$states != null : !((Object)this$states).equals(other$states)) {
            return false;
        }
        Set this$aliases = this.getAliases();
        Set other$aliases = other.getAliases();
        return !(this$aliases == null ? other$aliases != null : !((Object)this$aliases).equals(other$aliases));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DashboardData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Set $states = this.getStates();
        result = result * 59 + ($states == null ? 43 : ((Object)$states).hashCode());
        Set $aliases = this.getAliases();
        result = result * 59 + ($aliases == null ? 43 : ((Object)$aliases).hashCode());
        return result;
    }

    public String toString() {
        return "DashboardData(id=" + String.valueOf(this.getId()) + ", name=" + this.getName() + ", states=" + String.valueOf(this.getStates()) + ", aliases=" + String.valueOf(this.getAliases()) + ")";
    }

    public DashboardData() {
    }

    public DashboardData(UUID id, String name, Set<String> states, Set<DashboardAliasLite> aliases) {
        this.id = id;
        this.name = name;
        this.states = states;
        this.aliases = aliases;
    }
}

