/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.domain.runtime;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.thingsboard.trendz.domain.runtime.Item;
import org.thingsboard.trendz.domain.runtime.ItemLite;
import org.thingsboard.trendz.exception.TrendzException;
import org.thingsboard.trendz.service.provider.tb3.tb31filter.query.TsValue;

public class Item {
    private UUID id;
    private UUID parentId;
    private String type;
    private UUID ownerId;
    private String name;
    private String label;
    private Map<String, TsValue> attributes;
    private Map<String, TsValue> latestTelemetry;

    public Item(Item that) {
        this.id = that.id;
        this.parentId = that.parentId;
        this.type = that.type;
        this.ownerId = that.ownerId;
        this.name = that.name;
        this.label = that.label;
        this.attributes = that.attributes == null ? null : that.attributes.entrySet().stream().map(entry -> Map.entry((String)entry.getKey(), new TsValue((TsValue)entry.getValue()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        this.latestTelemetry = that.latestTelemetry == null ? null : that.latestTelemetry.entrySet().stream().map(entry -> Map.entry((String)entry.getKey(), new TsValue((TsValue)entry.getValue()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public Item(UUID id, UUID parentId, UUID ownerId, String name, String label) {
        this.id = id;
        this.parentId = parentId;
        this.ownerId = ownerId;
        this.name = name;
        this.label = label;
    }

    public ItemLite toLite() {
        return new ItemLite(this.id, this.name);
    }

    public static Set<UUID> getRootParents(Set<UUID> itemIdSet, Map<UUID, Set<UUID>> childItemIdToParentItemIdSetMap) {
        Set<UUID> iteratedItemIdSet;
        Set<UUID> nextItemIdSet = itemIdSet;
        int circuitBreakerCounter = 0;
        do {
            iteratedItemIdSet = nextItemIdSet;
            nextItemIdSet = new HashSet<UUID>();
            ++circuitBreakerCounter;
            for (UUID itemId : iteratedItemIdSet) {
                Set parentIdSet = childItemIdToParentItemIdSetMap.getOrDefault(itemId, Collections.emptySet());
                nextItemIdSet.addAll(parentIdSet);
            }
            if (circuitBreakerCounter <= 10000) continue;
            throw new TrendzException("Error during root item search - endless cycle was stopped.");
        } while (!nextItemIdSet.isEmpty());
        return iteratedItemIdSet;
    }

    public static ItemBuilder builder() {
        return new ItemBuilder();
    }

    public UUID getId() {
        return this.id;
    }

    public UUID getParentId() {
        return this.parentId;
    }

    public String getType() {
        return this.type;
    }

    public UUID getOwnerId() {
        return this.ownerId;
    }

    public String getName() {
        return this.name;
    }

    public String getLabel() {
        return this.label;
    }

    public Map<String, TsValue> getAttributes() {
        return this.attributes;
    }

    public Map<String, TsValue> getLatestTelemetry() {
        return this.latestTelemetry;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public void setParentId(UUID parentId) {
        this.parentId = parentId;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setOwnerId(UUID ownerId) {
        this.ownerId = ownerId;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setAttributes(Map<String, TsValue> attributes) {
        this.attributes = attributes;
    }

    public void setLatestTelemetry(Map<String, TsValue> latestTelemetry) {
        this.latestTelemetry = latestTelemetry;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Item)) {
            return false;
        }
        Item other = (Item)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        UUID this$parentId = this.getParentId();
        UUID other$parentId = other.getParentId();
        if (this$parentId == null ? other$parentId != null : !((Object)this$parentId).equals(other$parentId)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        UUID this$ownerId = this.getOwnerId();
        UUID other$ownerId = other.getOwnerId();
        if (this$ownerId == null ? other$ownerId != null : !((Object)this$ownerId).equals(other$ownerId)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$label = this.getLabel();
        String other$label = other.getLabel();
        if (this$label == null ? other$label != null : !this$label.equals(other$label)) {
            return false;
        }
        Map this$attributes = this.getAttributes();
        Map other$attributes = other.getAttributes();
        if (this$attributes == null ? other$attributes != null : !((Object)this$attributes).equals(other$attributes)) {
            return false;
        }
        Map this$latestTelemetry = this.getLatestTelemetry();
        Map other$latestTelemetry = other.getLatestTelemetry();
        return !(this$latestTelemetry == null ? other$latestTelemetry != null : !((Object)this$latestTelemetry).equals(other$latestTelemetry));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Item;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        UUID $parentId = this.getParentId();
        result = result * 59 + ($parentId == null ? 43 : ((Object)$parentId).hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        UUID $ownerId = this.getOwnerId();
        result = result * 59 + ($ownerId == null ? 43 : ((Object)$ownerId).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $label = this.getLabel();
        result = result * 59 + ($label == null ? 43 : $label.hashCode());
        Map $attributes = this.getAttributes();
        result = result * 59 + ($attributes == null ? 43 : ((Object)$attributes).hashCode());
        Map $latestTelemetry = this.getLatestTelemetry();
        result = result * 59 + ($latestTelemetry == null ? 43 : ((Object)$latestTelemetry).hashCode());
        return result;
    }

    public String toString() {
        return "Item(id=" + String.valueOf(this.getId()) + ", parentId=" + String.valueOf(this.getParentId()) + ", type=" + this.getType() + ", ownerId=" + String.valueOf(this.getOwnerId()) + ", name=" + this.getName() + ", label=" + this.getLabel() + ", attributes=" + String.valueOf(this.getAttributes()) + ", latestTelemetry=" + String.valueOf(this.getLatestTelemetry()) + ")";
    }

    public Item() {
    }

    public Item(UUID id, UUID parentId, String type, UUID ownerId, String name, String label, Map<String, TsValue> attributes, Map<String, TsValue> latestTelemetry) {
        this.id = id;
        this.parentId = parentId;
        this.type = type;
        this.ownerId = ownerId;
        this.name = name;
        this.label = label;
        this.attributes = attributes;
        this.latestTelemetry = latestTelemetry;
    }
}

