/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.domain.runtime;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.thingsboard.trendz.domain.runtime.DataCell;
import org.thingsboard.trendz.domain.runtime.DataRow;

public class DataRow {
    private List<EntityIdAndName> entityIds;
    private List<DataCell> cells;

    public DataRow(DataRow that) {
        this.entityIds = that.entityIds == null ? null : new ArrayList(that.entityIds);
        this.cells = that.cells == null ? null : that.cells.stream().map(DataCell::new).collect(Collectors.toList());
    }

    public DataRow clone() {
        return new DataRow(this);
    }

    public DataCell findCellByFieldId(UUID id) {
        return this.cells.stream().filter(c -> c.getViewFieldId().equals(id)).findFirst().orElse(null);
    }

    public static DataRowBuilder builder() {
        return new DataRowBuilder();
    }

    public List<EntityIdAndName> getEntityIds() {
        return this.entityIds;
    }

    public List<DataCell> getCells() {
        return this.cells;
    }

    public void setEntityIds(List<EntityIdAndName> entityIds) {
        this.entityIds = entityIds;
    }

    public void setCells(List<DataCell> cells) {
        this.cells = cells;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataRow)) {
            return false;
        }
        DataRow other = (DataRow)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        List this$entityIds = this.getEntityIds();
        List other$entityIds = other.getEntityIds();
        if (this$entityIds == null ? other$entityIds != null : !((Object)this$entityIds).equals(other$entityIds)) {
            return false;
        }
        List this$cells = this.getCells();
        List other$cells = other.getCells();
        return !(this$cells == null ? other$cells != null : !((Object)this$cells).equals(other$cells));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DataRow;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List $entityIds = this.getEntityIds();
        result = result * 59 + ($entityIds == null ? 43 : ((Object)$entityIds).hashCode());
        List $cells = this.getCells();
        result = result * 59 + ($cells == null ? 43 : ((Object)$cells).hashCode());
        return result;
    }

    public String toString() {
        return "DataRow(entityIds=" + String.valueOf(this.getEntityIds()) + ", cells=" + String.valueOf(this.getCells()) + ")";
    }

    public DataRow() {
    }

    public DataRow(List<EntityIdAndName> entityIds, List<DataCell> cells) {
        this.entityIds = entityIds;
        this.cells = cells;
    }
}

