/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.domain.metric;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.time.ZoneId;
import org.thingsboard.trendz.domain.definition.view.config.DatePickerConfig;
import org.thingsboard.trendz.domain.metric.MetricFinderRequest;
import org.thingsboard.trendz.tools.DateTimeUtils;

public class MetricFinderRequest {
    private Mode mode;
    private AiSuggestionsRequest aiSuggestionsRequest;
    private ManualRequest manualRequest;
    private DatePickerConfig datePickerConfig;
    private String tzName;

    public MetricFinderRequest(MetricFinderRequest that) {
        this.mode = that.mode;
        this.aiSuggestionsRequest = that.aiSuggestionsRequest == null ? null : new AiSuggestionsRequest(that.aiSuggestionsRequest);
        this.manualRequest = that.manualRequest == null ? null : new ManualRequest(that.manualRequest);
        this.datePickerConfig = that.datePickerConfig == null ? null : new DatePickerConfig(that.datePickerConfig);
        this.tzName = that.tzName;
    }

    @JsonIgnore
    public ZoneId getZoneId() {
        return DateTimeUtils.fromTzName((String)this.tzName);
    }

    public static MetricFinderRequestBuilder builder() {
        return new MetricFinderRequestBuilder();
    }

    public Mode getMode() {
        return this.mode;
    }

    public AiSuggestionsRequest getAiSuggestionsRequest() {
        return this.aiSuggestionsRequest;
    }

    public ManualRequest getManualRequest() {
        return this.manualRequest;
    }

    public DatePickerConfig getDatePickerConfig() {
        return this.datePickerConfig;
    }

    public String getTzName() {
        return this.tzName;
    }

    public void setMode(Mode mode) {
        this.mode = mode;
    }

    public void setAiSuggestionsRequest(AiSuggestionsRequest aiSuggestionsRequest) {
        this.aiSuggestionsRequest = aiSuggestionsRequest;
    }

    public void setManualRequest(ManualRequest manualRequest) {
        this.manualRequest = manualRequest;
    }

    public void setDatePickerConfig(DatePickerConfig datePickerConfig) {
        this.datePickerConfig = datePickerConfig;
    }

    public void setTzName(String tzName) {
        this.tzName = tzName;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MetricFinderRequest)) {
            return false;
        }
        MetricFinderRequest other = (MetricFinderRequest)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Mode this$mode = this.getMode();
        Mode other$mode = other.getMode();
        if (this$mode == null ? other$mode != null : !this$mode.equals(other$mode)) {
            return false;
        }
        AiSuggestionsRequest this$aiSuggestionsRequest = this.getAiSuggestionsRequest();
        AiSuggestionsRequest other$aiSuggestionsRequest = other.getAiSuggestionsRequest();
        if (this$aiSuggestionsRequest == null ? other$aiSuggestionsRequest != null : !this$aiSuggestionsRequest.equals(other$aiSuggestionsRequest)) {
            return false;
        }
        ManualRequest this$manualRequest = this.getManualRequest();
        ManualRequest other$manualRequest = other.getManualRequest();
        if (this$manualRequest == null ? other$manualRequest != null : !this$manualRequest.equals(other$manualRequest)) {
            return false;
        }
        DatePickerConfig this$datePickerConfig = this.getDatePickerConfig();
        DatePickerConfig other$datePickerConfig = other.getDatePickerConfig();
        if (this$datePickerConfig == null ? other$datePickerConfig != null : !this$datePickerConfig.equals(other$datePickerConfig)) {
            return false;
        }
        String this$tzName = this.getTzName();
        String other$tzName = other.getTzName();
        return !(this$tzName == null ? other$tzName != null : !this$tzName.equals(other$tzName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MetricFinderRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Mode $mode = this.getMode();
        result = result * 59 + ($mode == null ? 43 : $mode.hashCode());
        AiSuggestionsRequest $aiSuggestionsRequest = this.getAiSuggestionsRequest();
        result = result * 59 + ($aiSuggestionsRequest == null ? 43 : $aiSuggestionsRequest.hashCode());
        ManualRequest $manualRequest = this.getManualRequest();
        result = result * 59 + ($manualRequest == null ? 43 : $manualRequest.hashCode());
        DatePickerConfig $datePickerConfig = this.getDatePickerConfig();
        result = result * 59 + ($datePickerConfig == null ? 43 : $datePickerConfig.hashCode());
        String $tzName = this.getTzName();
        result = result * 59 + ($tzName == null ? 43 : $tzName.hashCode());
        return result;
    }

    public String toString() {
        return "MetricFinderRequest(mode=" + String.valueOf(this.getMode()) + ", aiSuggestionsRequest=" + String.valueOf(this.getAiSuggestionsRequest()) + ", manualRequest=" + String.valueOf(this.getManualRequest()) + ", datePickerConfig=" + String.valueOf(this.getDatePickerConfig()) + ", tzName=" + this.getTzName() + ")";
    }

    public MetricFinderRequest() {
    }

    public MetricFinderRequest(Mode mode, AiSuggestionsRequest aiSuggestionsRequest, ManualRequest manualRequest, DatePickerConfig datePickerConfig, String tzName) {
        this.mode = mode;
        this.aiSuggestionsRequest = aiSuggestionsRequest;
        this.manualRequest = manualRequest;
        this.datePickerConfig = datePickerConfig;
        this.tzName = tzName;
    }
}

