/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.domain.measurement;

import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.thingsboard.trendz.domain.measurement.FieldTrace;
import org.thingsboard.trendz.domain.measurement.MeasuredTaskType;
import org.thingsboard.trendz.domain.measurement.MeasurementInfo;
import org.thingsboard.trendz.domain.measurement.MeasurementParameters;
import org.thingsboard.trendz.domain.measurement.RequestTrace;

@Component
public class MeasurementLogger {
    private static final Logger log = LoggerFactory.getLogger(MeasurementLogger.class);
    @Value(value="${measurement.enable}")
    private boolean enabled;

    public void log(Map<MeasuredTaskType, List<MeasurementInfo>> taskTypeListMap, RequestTrace trace) {
        if (!this.enabled || trace == null || CollectionUtils.isEmpty(taskTypeListMap.keySet())) {
            return;
        }
        if (log.isTraceEnabled()) {
            List measurements = taskTypeListMap.values().stream().flatMap(Collection::stream).sorted(Comparator.comparing(MeasurementInfo::getRuntimeStartTs)).collect(Collectors.toList());
            this.printDetails(measurements);
        }
        this.logTaskTrace(trace);
    }

    private void printDetails(List<MeasurementInfo> measurements) {
        StringBuilder logBuilder = new StringBuilder();
        MeasurementInfo buildView = measurements.stream().filter(m -> m.getType().equals((Object)MeasuredTaskType.BUILD_VIEW)).findFirst().orElse(null);
        MeasurementInfo firstFieldProcessing = measurements.stream().filter(m -> m.getType().equals((Object)MeasuredTaskType.FIELD_PROCESSING)).findFirst().orElse(null);
        String lastFieldKey = measurements.stream().filter(m -> m.getType().equals((Object)MeasuredTaskType.FIELD_PROCESSING)).reduce((f, s) -> s).map(arg_0 -> this.getKey(arg_0)).orElse(null);
        long lastFieldProcessingMaxEndTs = measurements.stream().filter(m -> this.getKey(m).equals(lastFieldKey)).mapToLong(MeasurementInfo::getRuntimeEndTs).max().orElse(-1L);
        if (buildView != null && firstFieldProcessing != null && lastFieldProcessingMaxEndTs != -1L) {
            long initTime = firstFieldProcessing.getScheduleTs() - buildView.getRuntimeStartTs();
            long postTime = buildView.getRuntimeEndTs() - lastFieldProcessingMaxEndTs;
            logBuilder.append('\n').append("initTime ").append(initTime).append('\n').append("postTime ").append(postTime);
        }
        MeasurementInfo prev = null;
        for (MeasurementInfo info : measurements) {
            logBuilder.append('\n').append(this.toLine(info, prev));
            prev = info;
        }
        log.trace("The measurements of request: {}", (Object)logBuilder);
    }

    private String toLine(MeasurementInfo current, MeasurementInfo prev) {
        long currSchedTime = current.getScheduleTs() != 0L ? current.getScheduleTs() : current.getRuntimeStartTs();
        long prevSchedTime = 0L;
        if (prev != null) {
            prevSchedTime = prev.getScheduleTs() != 0L ? prev.getScheduleTs() : prev.getRuntimeStartTs();
        }
        long schedDelta = currSchedTime - prevSchedTime;
        long currStartTime = current.getRuntimeStartTs();
        long prevStartTime = 0L;
        if (prev != null) {
            prevStartTime = prev.getRuntimeStartTs();
        }
        long runDelta = currStartTime - prevStartTime;
        String line = "field = " + StringUtils.rightPad((String)(current.getMeasurementParameters().getViewFieldName() + "_" + String.valueOf(current.getMeasurementParameters().getViewFieldAggregation())), (int)15) + "type = " + StringUtils.rightPad((String)(String.valueOf(current.getType()) + " "), (int)30) + "exec = " + StringUtils.rightPad((String)(current.getRuntimeEndTs() - current.getRuntimeStartTs() + " "), (int)10) + "sched = " + StringUtils.rightPad((String)(schedDelta + " "), (int)10) + "start = " + StringUtils.rightPad((String)(runDelta + " "), (int)10) + "item = " + StringUtils.rightPad((String)(current.getMeasurementParameters().getItemName() + " "), (int)1);
        return line;
    }

    private void logTaskTrace(RequestTrace trace) {
        StringBuilder sb = new StringBuilder();
        sb.append("\ntotal: ").append(trace.getTotalTime()).append("\n\t init: ").append(trace.getInitTime()).append("\n\t post: ").append(trace.getPostTime()).append("\n\t waitFilter: ").append(trace.getWaitFilterTime()).append("\n\t fields: ").append(trace.getFieldsProcessTime()).append("\n\t rest time: ").append(trace.getRestRequestTime()).append("\n\t rest count: ").append(trace.getRestRequestCount()).append("\n\t rest average time: ").append(trace.getRestRequestCount() == 0L ? 0L : trace.getRestRequestTime() / trace.getRestRequestCount()).append("\n\t untracked: ").append(trace.getUntracked());
        for (FieldTrace fieldTrace : trace.getFieldTraces()) {
            sb.append("\nfield: ").append(fieldTrace.getFieldName()).append("\n\ttotal: ").append(fieldTrace.getTotalTime());
            this.appendIfNotZero(sb, fieldTrace.getItemsCnt(), "itemsCnt");
            this.appendIfNotZero(sb, fieldTrace.getRawValuesSize(), "valuesCnt");
            this.appendIfNotZero(sb, fieldTrace.getItemLoad(), "itemLoad");
            this.appendIfNotZero(sb, fieldTrace.getRelatedItemLoad(), "relatedItemLoad");
            this.appendIfNotZero(sb, fieldTrace.getTbLoadTime(), "tbLoadTime");
            this.appendIfNotZero(sb, fieldTrace.getCacheLoadTime(), "cacheLoadTime");
            this.appendIfNotZero(sb, fieldTrace.getScriptLoadTime(), "scriptLoadTime");
            this.appendIfNotZero(sb, fieldTrace.getBatchCalcTime(), "batchCalcTime");
            this.appendIfNotZero(sb, fieldTrace.getStateTime(), "stateTime");
            this.appendIfNotZero(sb, fieldTrace.getPredictTime(), "predictTime");
            this.appendIfNotZero(sb, fieldTrace.getAnomalyTime(), "anomalyTime");
            this.appendIfNotZero(sb, fieldTrace.getAggTime(), "aggTime");
            this.appendIfNotZero(sb, fieldTrace.getPreAggTime(), "preAggTime");
            this.appendIfNotZero(sb, fieldTrace.getDateGroupTime(), "dateGroupTime");
        }
        log.info("============== view task trace: {}", (Object)sb);
    }

    private void appendIfNotZero(StringBuilder sb, long val, String key) {
        if (val != 0L) {
            sb.append("\n\t\t ").append(key).append(": ").append(val);
        }
    }

    private String getKey(MeasurementInfo info) {
        MeasurementParameters parameters = info.getMeasurementParameters();
        return parameters.getViewFieldName() + "_" + String.valueOf(parameters.getViewFieldAggregation());
    }
}

