/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.domain.definition.view.config;

import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalField;
import org.thingsboard.trendz.domain.base.TimeRange;
import org.thingsboard.trendz.domain.definition.view.config.DatePickerConfig;
import org.thingsboard.trendz.domain.definition.view.config.DatePickerConfigSelectType;
import org.thingsboard.trendz.exception.BadConfiguredTaskException;
import org.thingsboard.trendz.tools.DateTimeUtils;

public class DatePickerConfig {
    private long startTs;
    private long endTs;
    private DatePickerConfigSelectType selectedType;
    private DatePickerConfigSelectType selectedUnit;
    private String relativeUnit;
    private int relativeLastAmount;
    private String rangeBy;

    public DatePickerConfig(long startTs, long endTs, String groupBy) {
        this.startTs = startTs;
        this.endTs = endTs;
        this.rangeBy = groupBy;
    }

    public DatePickerConfig(DatePickerConfig that) {
        this.startTs = that.startTs;
        this.endTs = that.endTs;
        this.selectedType = that.selectedType == null ? null : new DatePickerConfigSelectType(that.selectedType);
        this.selectedUnit = that.selectedUnit == null ? null : new DatePickerConfigSelectType(that.selectedUnit);
        this.relativeUnit = that.relativeUnit;
        this.relativeLastAmount = that.relativeLastAmount;
        this.rangeBy = that.rangeBy;
    }

    public TimeRange buildStartEndPair(ZoneId zoneId, long now) {
        long localStart;
        if (this.selectedType == null || !DatePickerConfigSelectType.Value.relative.equals((Object)this.selectedType.getValue())) {
            return new TimeRange(this.startTs, this.endTs);
        }
        TemporalField temporalField = this.selectedUnit.getTemporalField();
        ZonedDateTime truncatedNow = DateTimeUtils.fromTs((long)now, (ZoneId)zoneId).with(temporalField, 1L).truncatedTo(ChronoUnit.DAYS);
        return new TimeRange(localStart, switch (this.relativeUnit) {
            case "prev" -> {
                localStart = DateTimeUtils.toTs((ZonedDateTime)truncatedNow.minus(1L, temporalField.getRangeUnit()));
                yield DateTimeUtils.toTs((ZonedDateTime)truncatedNow) - 1L;
            }
            case "this" -> {
                localStart = DateTimeUtils.toTs((ZonedDateTime)truncatedNow);
                yield DateTimeUtils.toTs((ZonedDateTime)truncatedNow.plus(1L, temporalField.getRangeUnit())) - 1L;
            }
            case "last" -> {
                localStart = DateTimeUtils.toTs((ZonedDateTime)truncatedNow.minus(this.relativeLastAmount - 1, temporalField.getRangeUnit()));
                yield DateTimeUtils.toTs((ZonedDateTime)truncatedNow.plus(1L, temporalField.getRangeUnit())) - 1L;
            }
            default -> throw new BadConfiguredTaskException("Date picker relative unit not supported : " + this.relativeUnit);
        });
    }

    public static DatePickerConfigBuilder builder() {
        return new DatePickerConfigBuilder();
    }

    public long getStartTs() {
        return this.startTs;
    }

    public long getEndTs() {
        return this.endTs;
    }

    public DatePickerConfigSelectType getSelectedType() {
        return this.selectedType;
    }

    public DatePickerConfigSelectType getSelectedUnit() {
        return this.selectedUnit;
    }

    public String getRelativeUnit() {
        return this.relativeUnit;
    }

    public int getRelativeLastAmount() {
        return this.relativeLastAmount;
    }

    public String getRangeBy() {
        return this.rangeBy;
    }

    public void setStartTs(long startTs) {
        this.startTs = startTs;
    }

    public void setEndTs(long endTs) {
        this.endTs = endTs;
    }

    public void setSelectedType(DatePickerConfigSelectType selectedType) {
        this.selectedType = selectedType;
    }

    public void setSelectedUnit(DatePickerConfigSelectType selectedUnit) {
        this.selectedUnit = selectedUnit;
    }

    public void setRelativeUnit(String relativeUnit) {
        this.relativeUnit = relativeUnit;
    }

    public void setRelativeLastAmount(int relativeLastAmount) {
        this.relativeLastAmount = relativeLastAmount;
    }

    public void setRangeBy(String rangeBy) {
        this.rangeBy = rangeBy;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DatePickerConfig)) {
            return false;
        }
        DatePickerConfig other = (DatePickerConfig)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getStartTs() != other.getStartTs()) {
            return false;
        }
        if (this.getEndTs() != other.getEndTs()) {
            return false;
        }
        if (this.getRelativeLastAmount() != other.getRelativeLastAmount()) {
            return false;
        }
        DatePickerConfigSelectType this$selectedType = this.getSelectedType();
        DatePickerConfigSelectType other$selectedType = other.getSelectedType();
        if (this$selectedType == null ? other$selectedType != null : !this$selectedType.equals(other$selectedType)) {
            return false;
        }
        DatePickerConfigSelectType this$selectedUnit = this.getSelectedUnit();
        DatePickerConfigSelectType other$selectedUnit = other.getSelectedUnit();
        if (this$selectedUnit == null ? other$selectedUnit != null : !this$selectedUnit.equals(other$selectedUnit)) {
            return false;
        }
        String this$relativeUnit = this.getRelativeUnit();
        String other$relativeUnit = other.getRelativeUnit();
        if (this$relativeUnit == null ? other$relativeUnit != null : !this$relativeUnit.equals(other$relativeUnit)) {
            return false;
        }
        String this$rangeBy = this.getRangeBy();
        String other$rangeBy = other.getRangeBy();
        return !(this$rangeBy == null ? other$rangeBy != null : !this$rangeBy.equals(other$rangeBy));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DatePickerConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $startTs = this.getStartTs();
        result = result * 59 + (int)($startTs >>> 32 ^ $startTs);
        long $endTs = this.getEndTs();
        result = result * 59 + (int)($endTs >>> 32 ^ $endTs);
        result = result * 59 + this.getRelativeLastAmount();
        DatePickerConfigSelectType $selectedType = this.getSelectedType();
        result = result * 59 + ($selectedType == null ? 43 : $selectedType.hashCode());
        DatePickerConfigSelectType $selectedUnit = this.getSelectedUnit();
        result = result * 59 + ($selectedUnit == null ? 43 : $selectedUnit.hashCode());
        String $relativeUnit = this.getRelativeUnit();
        result = result * 59 + ($relativeUnit == null ? 43 : $relativeUnit.hashCode());
        String $rangeBy = this.getRangeBy();
        result = result * 59 + ($rangeBy == null ? 43 : $rangeBy.hashCode());
        return result;
    }

    public String toString() {
        return "DatePickerConfig(startTs=" + this.getStartTs() + ", endTs=" + this.getEndTs() + ", selectedType=" + String.valueOf(this.getSelectedType()) + ", selectedUnit=" + String.valueOf(this.getSelectedUnit()) + ", relativeUnit=" + this.getRelativeUnit() + ", relativeLastAmount=" + this.getRelativeLastAmount() + ", rangeBy=" + this.getRangeBy() + ")";
    }

    public DatePickerConfig() {
    }

    public DatePickerConfig(long startTs, long endTs, DatePickerConfigSelectType selectedType, DatePickerConfigSelectType selectedUnit, String relativeUnit, int relativeLastAmount, String rangeBy) {
        this.startTs = startTs;
        this.endTs = endTs;
        this.selectedType = selectedType;
        this.selectedUnit = selectedUnit;
        this.relativeUnit = relativeUnit;
        this.relativeLastAmount = relativeLastAmount;
        this.rangeBy = rangeBy;
    }
}

